/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.util.Arrays;
import java.util.Map;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.engine.Attribute;
import org.thymeleaf.engine.AttributeDefinition;
import org.thymeleaf.engine.AttributeDefinitions;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.Attributes;
import org.thymeleaf.engine.CDATASection;
import org.thymeleaf.engine.CloseElementTag;
import org.thymeleaf.engine.Comment;
import org.thymeleaf.engine.DocType;
import org.thymeleaf.engine.ElementDefinition;
import org.thymeleaf.engine.ElementDefinitions;
import org.thymeleaf.engine.Model;
import org.thymeleaf.engine.OpenElementTag;
import org.thymeleaf.engine.ProcessingInstruction;
import org.thymeleaf.engine.StandaloneElementTag;
import org.thymeleaf.engine.TemplateData;
import org.thymeleaf.engine.Text;
import org.thymeleaf.engine.XMLDeclaration;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.AttributeValueQuotes;
import org.thymeleaf.model.ICDATASection;
import org.thymeleaf.model.ICloseElementTag;
import org.thymeleaf.model.IComment;
import org.thymeleaf.model.IDocType;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IOpenElementTag;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.IProcessingInstruction;
import org.thymeleaf.model.IStandaloneElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.model.IText;
import org.thymeleaf.model.IXMLDeclaration;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.Validate;

public class StandardModelFactory
implements IModelFactory {
    private static final String[][] SYNTHETIC_INNER_WHITESPACES = new String[][]{new String[0], Attributes.DEFAULT_WHITE_SPACE_ARRAY, {" ", " "}, {" ", " ", " "}, {" ", " ", " ", " "}, {" ", " ", " ", " ", " "}};
    private final IEngineConfiguration configuration;
    private final AttributeDefinitions attributeDefinitions;
    private final ElementDefinitions elementDefinitions;
    private final TemplateMode templateMode;

    public StandardModelFactory(IEngineConfiguration configuration, TemplateMode templateMode) {
        Validate.notNull(configuration, "Configuration cannot be null");
        Validate.notNull(configuration.getAttributeDefinitions(), "Attribute Definitions returned by Engine Configuration cannot be null");
        Validate.notNull(configuration.getElementDefinitions(), "Element Definitions returned by Engine Configuration cannot be null");
        Validate.notNull((Object)templateMode, "Template Mode cannot be null");
        this.configuration = configuration;
        this.attributeDefinitions = this.configuration.getAttributeDefinitions();
        this.elementDefinitions = this.configuration.getElementDefinitions();
        this.templateMode = templateMode;
    }

    private void checkRestrictedEventForTextTemplateMode(String eventClass) {
        if (this.templateMode.isText()) {
            throw new TemplateProcessingException("Events of class " + eventClass + " cannot be created in a text-type template mode (" + (Object)((Object)this.templateMode) + ")");
        }
    }

    @Override
    public IModel createModel() {
        return new Model(this.configuration, this.templateMode);
    }

    @Override
    public IModel createModel(ITemplateEvent event) {
        Model model = new Model(this.configuration, this.templateMode);
        model.add(event);
        return model;
    }

    @Override
    public IModel parse(TemplateData ownerTemplate, String template) {
        return this.configuration.getTemplateManager().parseString(ownerTemplate, template, 0, 0, this.templateMode, false);
    }

    @Override
    public ICDATASection createCDATASection(CharSequence content) {
        this.checkRestrictedEventForTextTemplateMode("CDATASection");
        return new CDATASection(content);
    }

    @Override
    public IComment createComment(CharSequence content) {
        this.checkRestrictedEventForTextTemplateMode("Comment");
        return new Comment(content);
    }

    @Override
    public IDocType createHTML5DocType() {
        this.checkRestrictedEventForTextTemplateMode("DocType");
        return new DocType(null, null);
    }

    @Override
    public IDocType createDocType(String publicId, String systemId) {
        this.checkRestrictedEventForTextTemplateMode("DocType");
        return new DocType(publicId, systemId);
    }

    @Override
    public IDocType createDocType(String keyword, String elementName, String publicId, String systemId, String internalSubset) {
        this.checkRestrictedEventForTextTemplateMode("DocType");
        return new DocType(keyword, elementName, publicId, systemId, internalSubset);
    }

    @Override
    public IProcessingInstruction createProcessingInstruction(String target, String content) {
        this.checkRestrictedEventForTextTemplateMode("ProcessingInstruction");
        return new ProcessingInstruction(target, content);
    }

    @Override
    public IText createText(CharSequence text) {
        return new Text(text);
    }

    @Override
    public IXMLDeclaration createXMLDeclaration(String version, String encoding, String standalone) {
        this.checkRestrictedEventForTextTemplateMode("XMLDeclaration");
        return new XMLDeclaration("xml", version, encoding, standalone);
    }

    @Override
    public IStandaloneElementTag createStandaloneElementTag(String elementName) {
        return this.createStandaloneElementTag(elementName, false, true);
    }

    @Override
    public IStandaloneElementTag createStandaloneElementTag(String elementName, String attributeName, String attributeValue) {
        return this.createStandaloneElementTag(elementName, attributeName, attributeValue, false, true);
    }

    @Override
    public IStandaloneElementTag createStandaloneElementTag(String elementName, boolean synthetic, boolean minimized) {
        ElementDefinition elementDefinition = this.elementDefinitions.forName(this.templateMode, elementName);
        return new StandaloneElementTag(this.templateMode, elementDefinition, elementName, null, synthetic, minimized);
    }

    @Override
    public IStandaloneElementTag createStandaloneElementTag(String elementName, String attributeName, String attributeValue, boolean synthetic, boolean minimized) {
        ElementDefinition elementDefinition = this.elementDefinitions.forName(this.templateMode, elementName);
        Attributes attributes = this.buildAttributes(new Attribute[]{this.buildAttribute(attributeName, attributeValue, null)});
        return new StandaloneElementTag(this.templateMode, elementDefinition, elementName, attributes, synthetic, minimized);
    }

    @Override
    public IStandaloneElementTag createStandaloneElementTag(String elementName, Map<String, String> attributes, AttributeValueQuotes attributeValueQuotes, boolean synthetic, boolean minimized) {
        ElementDefinition elementDefinition = this.elementDefinitions.forName(this.templateMode, elementName);
        Attributes attributesObj = this.buildAttributes(this.buildAttributeArray(attributes, attributeValueQuotes));
        return new StandaloneElementTag(this.templateMode, elementDefinition, elementName, attributesObj, synthetic, minimized);
    }

    @Override
    public IOpenElementTag createOpenElementTag(String elementName) {
        return this.createOpenElementTag(elementName, false);
    }

    @Override
    public IOpenElementTag createOpenElementTag(String elementName, String attributeName, String attributeValue) {
        return this.createOpenElementTag(elementName, attributeName, attributeValue, false);
    }

    @Override
    public IOpenElementTag createOpenElementTag(String elementName, boolean synthetic) {
        ElementDefinition elementDefinition = this.elementDefinitions.forName(this.templateMode, elementName);
        return new OpenElementTag(this.templateMode, elementDefinition, elementName, null, synthetic);
    }

    @Override
    public IOpenElementTag createOpenElementTag(String elementName, String attributeName, String attributeValue, boolean synthetic) {
        ElementDefinition elementDefinition = this.elementDefinitions.forName(this.templateMode, elementName);
        Attributes attributes = this.buildAttributes(new Attribute[]{this.buildAttribute(attributeName, attributeValue, null)});
        return new OpenElementTag(this.templateMode, elementDefinition, elementName, attributes, synthetic);
    }

    @Override
    public IOpenElementTag createOpenElementTag(String elementName, Map<String, String> attributes, AttributeValueQuotes attributeValueQuotes, boolean synthetic) {
        ElementDefinition elementDefinition = this.elementDefinitions.forName(this.templateMode, elementName);
        Attributes attributesObj = this.buildAttributes(this.buildAttributeArray(attributes, attributeValueQuotes));
        return new OpenElementTag(this.templateMode, elementDefinition, elementName, attributesObj, synthetic);
    }

    @Override
    public <T extends IProcessableElementTag> T setAttribute(T tag, String attributeName, String attributeValue) {
        if (tag == null) {
            return null;
        }
        if (tag instanceof IOpenElementTag) {
            return (T)this.setAttribute((IOpenElementTag)tag, attributeName, attributeValue);
        }
        if (tag instanceof IStandaloneElementTag) {
            return (T)this.setAttribute((IStandaloneElementTag)tag, attributeName, attributeValue);
        }
        throw new TemplateProcessingException("Unknown type of processable element tag: " + tag.getClass().getName());
    }

    @Override
    public <T extends IProcessableElementTag> T setAttribute(T tag, String attributeName, String attributeValue, AttributeValueQuotes attributeValueQuotes) {
        if (tag == null) {
            return null;
        }
        if (tag instanceof IOpenElementTag) {
            return (T)this.setAttribute((IOpenElementTag)tag, attributeName, attributeValue, attributeValueQuotes);
        }
        if (tag instanceof IStandaloneElementTag) {
            return (T)this.setAttribute((IStandaloneElementTag)tag, attributeName, attributeValue, attributeValueQuotes);
        }
        throw new TemplateProcessingException("Unknown type of processable element tag: " + tag.getClass().getName());
    }

    @Override
    public <T extends IProcessableElementTag> T replaceAttribute(T tag, AttributeName oldAttributeName, String attributeName, String attributeValue) {
        if (tag == null) {
            return null;
        }
        if (tag instanceof IOpenElementTag) {
            return (T)this.replaceAttribute((IOpenElementTag)tag, oldAttributeName, attributeName, attributeValue);
        }
        if (tag instanceof IStandaloneElementTag) {
            return (T)this.replaceAttribute((IStandaloneElementTag)tag, oldAttributeName, attributeName, attributeValue);
        }
        throw new TemplateProcessingException("Unknown type of processable element tag: " + tag.getClass().getName());
    }

    @Override
    public <T extends IProcessableElementTag> T replaceAttribute(T tag, AttributeName oldAttributeName, String attributeName, String attributeValue, AttributeValueQuotes attributeValueQuotes) {
        if (tag == null) {
            return null;
        }
        if (tag instanceof IOpenElementTag) {
            return (T)this.replaceAttribute((IOpenElementTag)tag, oldAttributeName, attributeName, attributeValue, attributeValueQuotes);
        }
        if (tag instanceof IStandaloneElementTag) {
            return (T)this.replaceAttribute((IStandaloneElementTag)tag, oldAttributeName, attributeName, attributeValue, attributeValueQuotes);
        }
        throw new TemplateProcessingException("Unknown type of processable element tag: " + tag.getClass().getName());
    }

    @Override
    public <T extends IProcessableElementTag> T removeAttribute(T tag, String attributeName) {
        if (tag == null) {
            return null;
        }
        if (tag instanceof IOpenElementTag) {
            return (T)this.removeAttribute((IOpenElementTag)tag, attributeName);
        }
        if (tag instanceof IStandaloneElementTag) {
            return (T)this.removeAttribute((IStandaloneElementTag)tag, attributeName);
        }
        throw new TemplateProcessingException("Unknown type of processable element tag: " + tag.getClass().getName());
    }

    @Override
    public <T extends IProcessableElementTag> T removeAttribute(T tag, String prefix, String name) {
        if (tag == null) {
            return null;
        }
        if (tag instanceof IOpenElementTag) {
            return (T)this.removeAttribute((IOpenElementTag)tag, prefix, name);
        }
        if (tag instanceof IStandaloneElementTag) {
            return (T)this.removeAttribute((IStandaloneElementTag)tag, prefix, name);
        }
        throw new TemplateProcessingException("Unknown type of processable element tag: " + tag.getClass().getName());
    }

    @Override
    public <T extends IProcessableElementTag> T removeAttribute(T tag, AttributeName attributeName) {
        if (tag == null) {
            return null;
        }
        if (tag instanceof IOpenElementTag) {
            return (T)this.removeAttribute((IOpenElementTag)tag, attributeName);
        }
        if (tag instanceof IStandaloneElementTag) {
            return (T)this.removeAttribute((IStandaloneElementTag)tag, attributeName);
        }
        throw new TemplateProcessingException("Unknown type of processable element tag: " + tag.getClass().getName());
    }

    private IStandaloneElementTag setAttribute(IStandaloneElementTag standaloneElementTag, String attributeName, String attributeValue) {
        if (!(standaloneElementTag instanceof StandaloneElementTag)) {
            return this.setAttribute(StandaloneElementTag.asEngineStandaloneElementTag(standaloneElementTag), attributeName, attributeValue);
        }
        return ((StandaloneElementTag)standaloneElementTag).setAttribute(this.attributeDefinitions, null, attributeName, attributeValue, null);
    }

    private IStandaloneElementTag setAttribute(IStandaloneElementTag standaloneElementTag, String attributeName, String attributeValue, AttributeValueQuotes attributeValueQuotes) {
        if (!(standaloneElementTag instanceof StandaloneElementTag)) {
            return this.setAttribute(StandaloneElementTag.asEngineStandaloneElementTag(standaloneElementTag), attributeName, attributeValue, attributeValueQuotes);
        }
        return ((StandaloneElementTag)standaloneElementTag).setAttribute(this.attributeDefinitions, null, attributeName, attributeValue, attributeValueQuotes);
    }

    private IStandaloneElementTag replaceAttribute(IStandaloneElementTag standaloneElementTag, AttributeName oldAttributeName, String attributeName, String attributeValue) {
        if (!(standaloneElementTag instanceof StandaloneElementTag)) {
            return this.replaceAttribute(StandaloneElementTag.asEngineStandaloneElementTag(standaloneElementTag), oldAttributeName, attributeName, attributeValue);
        }
        return ((StandaloneElementTag)standaloneElementTag).replaceAttribute(this.attributeDefinitions, oldAttributeName, null, attributeName, attributeValue, null);
    }

    private IStandaloneElementTag replaceAttribute(IStandaloneElementTag standaloneElementTag, AttributeName oldAttributeName, String attributeName, String attributeValue, AttributeValueQuotes attributeValueQuotes) {
        if (!(standaloneElementTag instanceof StandaloneElementTag)) {
            return this.replaceAttribute(StandaloneElementTag.asEngineStandaloneElementTag(standaloneElementTag), oldAttributeName, attributeName, attributeValue, attributeValueQuotes);
        }
        return ((StandaloneElementTag)standaloneElementTag).replaceAttribute(this.attributeDefinitions, oldAttributeName, null, attributeName, attributeValue, attributeValueQuotes);
    }

    private IStandaloneElementTag removeAttribute(IStandaloneElementTag standaloneElementTag, String attributeName) {
        if (!(standaloneElementTag instanceof StandaloneElementTag)) {
            return this.removeAttribute((IStandaloneElementTag)StandaloneElementTag.asEngineStandaloneElementTag(standaloneElementTag), attributeName);
        }
        return ((StandaloneElementTag)standaloneElementTag).removeAttribute(attributeName);
    }

    private IStandaloneElementTag removeAttribute(IStandaloneElementTag standaloneElementTag, String prefix, String name) {
        if (!(standaloneElementTag instanceof StandaloneElementTag)) {
            return this.removeAttribute(StandaloneElementTag.asEngineStandaloneElementTag(standaloneElementTag), prefix, name);
        }
        return ((StandaloneElementTag)standaloneElementTag).removeAttribute(prefix, name);
    }

    private IStandaloneElementTag removeAttribute(IStandaloneElementTag standaloneElementTag, AttributeName attributeName) {
        if (!(standaloneElementTag instanceof StandaloneElementTag)) {
            return this.removeAttribute((IStandaloneElementTag)StandaloneElementTag.asEngineStandaloneElementTag(standaloneElementTag), attributeName);
        }
        return ((StandaloneElementTag)standaloneElementTag).removeAttribute(attributeName);
    }

    private IOpenElementTag setAttribute(IOpenElementTag openElementTag, String attributeName, String attributeValue) {
        if (!(openElementTag instanceof OpenElementTag)) {
            return this.setAttribute(OpenElementTag.asEngineOpenElementTag(openElementTag), attributeName, attributeValue);
        }
        return ((OpenElementTag)openElementTag).setAttribute(this.attributeDefinitions, null, attributeName, attributeValue, null);
    }

    private IOpenElementTag setAttribute(IOpenElementTag openElementTag, String attributeName, String attributeValue, AttributeValueQuotes attributeValueQuotes) {
        if (!(openElementTag instanceof OpenElementTag)) {
            return this.setAttribute(OpenElementTag.asEngineOpenElementTag(openElementTag), attributeName, attributeValue, attributeValueQuotes);
        }
        return ((OpenElementTag)openElementTag).setAttribute(this.attributeDefinitions, null, attributeName, attributeValue, attributeValueQuotes);
    }

    private IOpenElementTag replaceAttribute(IOpenElementTag openElementTag, AttributeName oldAttributeName, String attributeName, String attributeValue) {
        if (!(openElementTag instanceof OpenElementTag)) {
            return this.replaceAttribute(OpenElementTag.asEngineOpenElementTag(openElementTag), oldAttributeName, attributeName, attributeValue);
        }
        return ((OpenElementTag)openElementTag).replaceAttribute(this.attributeDefinitions, oldAttributeName, null, attributeName, attributeValue, null);
    }

    private IOpenElementTag replaceAttribute(IOpenElementTag openElementTag, AttributeName oldAttributeName, String attributeName, String attributeValue, AttributeValueQuotes attributeValueQuotes) {
        if (!(openElementTag instanceof OpenElementTag)) {
            return this.replaceAttribute(OpenElementTag.asEngineOpenElementTag(openElementTag), oldAttributeName, attributeName, attributeValue, attributeValueQuotes);
        }
        return ((OpenElementTag)openElementTag).replaceAttribute(this.attributeDefinitions, oldAttributeName, null, attributeName, attributeValue, attributeValueQuotes);
    }

    private IOpenElementTag removeAttribute(IOpenElementTag openElementTag, String attributeName) {
        if (!(openElementTag instanceof OpenElementTag)) {
            return this.removeAttribute((IOpenElementTag)OpenElementTag.asEngineOpenElementTag(openElementTag), attributeName);
        }
        return ((OpenElementTag)openElementTag).removeAttribute(attributeName);
    }

    private IOpenElementTag removeAttribute(IOpenElementTag openElementTag, String prefix, String name) {
        if (!(openElementTag instanceof OpenElementTag)) {
            return this.removeAttribute(OpenElementTag.asEngineOpenElementTag(openElementTag), prefix, name);
        }
        return ((OpenElementTag)openElementTag).removeAttribute(prefix, name);
    }

    private IOpenElementTag removeAttribute(IOpenElementTag openElementTag, AttributeName attributeName) {
        if (!(openElementTag instanceof OpenElementTag)) {
            return this.removeAttribute((IOpenElementTag)OpenElementTag.asEngineOpenElementTag(openElementTag), attributeName);
        }
        return ((OpenElementTag)openElementTag).removeAttribute(attributeName);
    }

    @Override
    public ICloseElementTag createCloseElementTag(String elementName) {
        return this.createCloseElementTag(elementName, false, false);
    }

    @Override
    public ICloseElementTag createCloseElementTag(String elementName, boolean synthetic, boolean unmatched) {
        ElementDefinition elementDefinition = this.elementDefinitions.forName(this.templateMode, elementName);
        return new CloseElementTag(this.templateMode, elementDefinition, elementName, null, synthetic, unmatched);
    }

    private Attribute buildAttribute(String name, String value, AttributeValueQuotes quotes) {
        AttributeDefinition attributeDefinition = this.attributeDefinitions.forName(this.templateMode, name);
        return new Attribute(attributeDefinition, name, "=", value, quotes, null, -1, -1);
    }

    private Attribute[] buildAttributeArray(Map<String, String> attributes, AttributeValueQuotes quotes) {
        if (attributes == null || attributes.size() == 0) {
            return Attributes.EMPTY_ATTRIBUTE_ARRAY;
        }
        int i = 0;
        Attribute[] newAttributes = new Attribute[attributes.size()];
        for (Map.Entry<String, String> attributesEntry : attributes.entrySet()) {
            newAttributes[i++] = this.buildAttribute(attributesEntry.getKey(), attributesEntry.getValue(), quotes);
        }
        return newAttributes;
    }

    private Attributes buildAttributes(Attribute[] attributeArray) {
        Object[] innerWhiteSpaces;
        if (attributeArray == null || attributeArray.length == 0) {
            return Attributes.EMPTY_ATTRIBUTES;
        }
        if (attributeArray.length < SYNTHETIC_INNER_WHITESPACES.length) {
            innerWhiteSpaces = SYNTHETIC_INNER_WHITESPACES[attributeArray.length];
        } else {
            innerWhiteSpaces = new String[attributeArray.length];
            Arrays.fill(innerWhiteSpaces, " ");
        }
        return new Attributes(attributeArray, (String[])innerWhiteSpaces);
    }
}

