/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.common.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.linkis.datasourcemanager.common.exception.JsonErrorException;
import org.apache.linkis.datasourcemanager.common.util.json.Json;

public class PatternInjectUtils {
    private static final String PARAMETER_PREFIX = "[#|$]";
    private static final String ASSIGN_SYMBOL = "=";
    private static final Pattern REGEX = Pattern.compile("(=?)([#|$])\\{([\\w-]+)[|]?([^}]*)}?");

    private PatternInjectUtils() {
    }

    public static String inject(String template, Object[] params, boolean useDefault, boolean escape, boolean placeholder) throws JsonErrorException {
        Matcher matcher = REGEX.matcher(template);
        StringBuffer sb = new StringBuffer();
        int offset = 0;
        while (matcher.find()) {
            String value = "";
            String extra = "";
            if (offset < params.length && null != params[offset]) {
                Object paramsV = params[offset];
                if (paramsV instanceof String || paramsV instanceof Enum || paramsV.getClass().isPrimitive() || PatternInjectUtils.isWrapClass(paramsV.getClass())) {
                    value = escape ? StringEscapeUtils.escapeJava((String)String.valueOf(paramsV)) : String.valueOf(paramsV);
                } else {
                    value = Json.toJson(paramsV, null);
                    String string = value = escape ? StringEscapeUtils.escapeJava((String)value) : value;
                }
                if (null != matcher.group(1) && !"".equals(matcher.group(1))) {
                    extra = matcher.group(1);
                }
                ++offset;
            } else if (null != matcher.group(4) && useDefault) {
                String string = value = escape ? StringEscapeUtils.escapeJava((String)String.valueOf(matcher.group(4))) : matcher.group(4);
            }
            if (StringUtils.isBlank((CharSequence)value) && !useDefault) {
                value = "\"" + (escape ? StringEscapeUtils.escapeJava((String)matcher.group(3)) : matcher.group(3));
            } else if (!"$".equals(matcher.group(2)) && placeholder) {
                value = "\"" + StringEscapeUtils.escapeJava((String)value) + "\"";
            }
            String result = (extra + value).replace("$", "\\$");
            matcher.appendReplacement(sb, result);
        }
        matcher.appendTail(sb);
        return sb.toString().replace("\\$", "$");
    }

    public static String inject(String pattern, Object[] params) throws JsonErrorException {
        return PatternInjectUtils.inject(pattern, params, true, true, true);
    }

    public static String inject(String template, Map<String, Object> params, boolean useDefault, boolean escape, boolean placeholder) throws JsonErrorException {
        Matcher matcher = REGEX.matcher(template);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String injected = matcher.group(3);
            if (null == injected || "".equals(injected)) continue;
            boolean flag = false;
            String value = "";
            String extra = "";
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (!injected.equals(entry.getKey()) || null == entry.getValue()) continue;
                Object entryV = entry.getValue();
                if (entryV instanceof String || entryV instanceof Enum || entryV.getClass().isPrimitive() || PatternInjectUtils.isWrapClass(entryV.getClass())) {
                    value = escape ? StringEscapeUtils.escapeJava((String)String.valueOf(entryV)) : String.valueOf(entryV);
                } else {
                    value = Json.toJson(entryV, null);
                    String string = value = escape ? StringEscapeUtils.escapeJava((String)value) : value;
                }
                if (null != matcher.group(1) || !"".equals(matcher.group(1))) {
                    extra = matcher.group(1);
                }
                flag = true;
                break;
            }
            if (!flag && null != matcher.group(4) && useDefault) {
                String string = value = escape ? StringEscapeUtils.escapeJava((String)String.valueOf(matcher.group(4))) : matcher.group(4);
            }
            if (StringUtils.isBlank((CharSequence)value) && !useDefault) {
                value = "\"*#{" + (escape ? StringEscapeUtils.escapeJava((String)matcher.group(3)) : matcher.group(3)) + "}*\"";
            } else if (!"$".equals(matcher.group(2)) && placeholder) {
                value = "\"" + StringEscapeUtils.escapeJava((String)value) + "\"";
            }
            String result = (extra + value).replace("$", "\\$");
            matcher.appendReplacement(sb, result);
        }
        matcher.appendTail(sb);
        String print = sb.toString();
        return print.replace("\\$", "$").replace("", "");
    }

    public static String injectPattern(String template, String valuePattern) {
        Matcher matcher = REGEX.matcher(template);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String extra = matcher.group(1);
            String value = StringEscapeUtils.escapeJava((String)matcher.group(3));
            value = (extra + value.replaceAll("[\\s\\S]+", valuePattern)).replace("$", "\\$");
            matcher.appendReplacement(sb, value);
        }
        matcher.appendTail(sb);
        return sb.toString().replace("\\$", "$");
    }

    public static String inject(String template, Map<String, Object> params) throws JsonErrorException {
        return PatternInjectUtils.inject(template, params, true, true, true);
    }

    private static boolean isWrapClass(Class clz) {
        try {
            return ((Class)clz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception e) {
            return false;
        }
    }
}

