/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.server.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.linkis.cs.ContextSearch;
import org.apache.linkis.cs.DefaultContextSearch;
import org.apache.linkis.cs.common.entity.enumeration.ContextType;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.common.entity.source.ContextKeyValue;
import org.apache.linkis.cs.common.entity.source.ContextValue;
import org.apache.linkis.cs.common.entity.source.HAContextID;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.contextcache.ContextCacheService;
import org.apache.linkis.cs.errorcode.LinkisCsServerErrorCodeSummary;
import org.apache.linkis.cs.exception.ContextSearchFailedException;
import org.apache.linkis.cs.highavailable.ha.ContextHAChecker;
import org.apache.linkis.cs.persistence.ContextPersistenceManager;
import org.apache.linkis.cs.persistence.entity.PersistenceContextID;
import org.apache.linkis.cs.persistence.entity.PersistenceContextKeyValue;
import org.apache.linkis.cs.persistence.persistence.ContextIDPersistence;
import org.apache.linkis.cs.persistence.persistence.ContextMapPersistence;
import org.apache.linkis.cs.server.enumeration.ServiceType;
import org.apache.linkis.cs.server.parser.KeywordParser;
import org.apache.linkis.cs.server.service.ContextService;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContextServiceImpl
extends ContextService {
    private ContextSearch contextSearch = new DefaultContextSearch();
    @Autowired
    private ContextCacheService contextCacheService;
    @Autowired
    private ContextPersistenceManager persistenceManager;
    @Autowired
    private KeywordParser keywordParser;
    @Autowired
    private ContextHAChecker contextHAChecker;
    private ObjectMapper jackson = BDPJettyServerHelper.jacksonJson();

    private ContextMapPersistence getPersistence() throws CSErrorException {
        return this.persistenceManager.getContextMapPersistence();
    }

    private ContextIDPersistence getIDPersistence() throws CSErrorException {
        return this.persistenceManager.getContextIDPersistence();
    }

    @Override
    public String getName() {
        return ServiceType.CONTEXT.name();
    }

    @Override
    public ContextValue getContextValue(ContextID contextID, ContextKey contextKey) {
        ContextKeyValue keyValue = this.contextCacheService.get(contextID, contextKey);
        if (keyValue == null) {
            this.logger.info("getContextValue is null contextId: {}, key: {}", (Object)contextID.getContextId(), (Object)contextKey.getKey());
            return null;
        }
        this.logger.info("getContextValue,csId:{},key:{},csType:{},csScope:{}", new Object[]{contextID.getContextId(), contextKey.getKey(), contextKey.getContextType(), contextKey.getContextScope()});
        return keyValue.getContextValue();
    }

    @Override
    public List<ContextKeyValue> searchContextValue(ContextID contextID, Map<Object, Object> conditionMap) throws ContextSearchFailedException {
        this.logger.info("searchContextValue,csId:{}", (Object)contextID.getContextId());
        return this.contextSearch.search(this.contextCacheService, contextID, conditionMap);
    }

    @Override
    public void setValueByKey(ContextID contextID, ContextKey contextKey, ContextValue contextValue) throws CSErrorException, JsonProcessingException {
        Object value = contextValue.getValue();
        Set<String> keys = this.keywordParser.parse(value);
        keys.add(contextKey.getKey());
        contextValue.setKeywords(this.jackson.writeValueAsString(keys));
        ContextKeyValue keyValue = this.contextCacheService.get(contextID, contextKey);
        if (keyValue == null) {
            if (contextKey.getContextScope() == null || contextKey.getContextType() == null) {
                throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), "try to create context ,type or scope cannot be empty");
            }
            this.logger.info("Create cs key value setValueByKey, csId:{}},key:{}", (Object)contextID.getContextId(), (Object)contextKey.getKey());
            keyValue = new PersistenceContextKeyValue();
            keyValue.setContextKey(contextKey);
            keyValue.setContextValue(contextValue);
            this.getPersistence().create(contextID, keyValue);
        } else {
            if (contextKey.getContextScope() == null) {
                contextKey.setContextScope(keyValue.getContextKey().getContextScope());
            }
            if (contextKey.getContextType() == null) {
                contextKey.setContextType(keyValue.getContextKey().getContextType());
            }
            keyValue.setContextKey(contextKey);
            keyValue.setContextValue(contextValue);
            this.getPersistence().update(contextID, keyValue);
        }
        this.contextCacheService.put(contextID, keyValue);
        this.logger.info("setValueByKey, csId:{},key: {},keywords:{}", new Object[]{contextID.getContextId(), contextKey.getKey(), contextValue.getKeywords()});
    }

    @Override
    public void setValue(ContextID contextID, ContextKeyValue contextKeyValue) throws CSErrorException, ClassNotFoundException, JsonProcessingException {
        Object value = contextKeyValue.getContextValue().getValue();
        Set<String> keys = this.keywordParser.parse(value);
        keys.add(contextKeyValue.getContextKey().getKey());
        contextKeyValue.getContextValue().setKeywords(this.jackson.writeValueAsString(keys));
        ContextKeyValue keyValue = this.contextCacheService.get(contextID, contextKeyValue.getContextKey());
        if (keyValue == null) {
            this.logger.warn("cache can not find contextId:{},key:{},now try to load from MySQL", (Object)contextID.getContextId(), (Object)contextKeyValue.getContextKey().getKey());
            keyValue = this.getPersistence().get(contextID, contextKeyValue.getContextKey());
            if (keyValue != null) {
                this.logger.warn("MySQL find the key,now reset the cache and get it");
                this.contextCacheService.rest(contextID, contextKeyValue.getContextKey());
                keyValue = this.contextCacheService.get(contextID, contextKeyValue.getContextKey());
            }
        }
        if (keyValue == null) {
            if (contextKeyValue.getContextKey().getContextScope() == null || contextKeyValue.getContextKey().getContextType() == null) {
                throw new CSErrorException(97000, "try to create context ,type or scope cannot be empty");
            }
            this.getPersistence().create(contextID, contextKeyValue);
        } else {
            if (contextKeyValue.getContextKey().getContextScope() == null) {
                contextKeyValue.getContextKey().setContextScope(keyValue.getContextKey().getContextScope());
            }
            if (contextKeyValue.getContextKey().getContextType() == null) {
                contextKeyValue.getContextKey().setContextType(keyValue.getContextKey().getContextType());
            }
            this.getPersistence().update(contextID, contextKeyValue);
        }
        this.contextCacheService.put(contextID, contextKeyValue);
        this.logger.info("From db and cache  to setValue, csId:{},key:{}", (Object)contextID.getContextId(), (Object)contextKeyValue.getContextKey().getKey());
    }

    @Override
    public void resetValue(ContextID contextID, ContextKey contextKey) throws CSErrorException {
        this.getPersistence().reset(contextID, contextKey);
        this.contextCacheService.rest(contextID, contextKey);
        this.logger.info("From db and cache  resetValue, csId:{},key:{}", (Object)contextID.getContextId(), (Object)contextKey.getKey());
    }

    @Override
    public void removeValue(ContextID contextID, ContextKey contextKey) throws CSErrorException {
        ContextKeyValue contextKeyValue = this.contextCacheService.get(contextID, contextKey);
        if (contextKeyValue == null) {
            return;
        }
        if (contextKey.getContextScope() == null) {
            contextKey.setContextScope(contextKeyValue.getContextKey().getContextScope());
        }
        if (contextKey.getContextType() == null) {
            contextKey.setContextType(contextKeyValue.getContextKey().getContextType());
        }
        this.getPersistence().remove(contextID, contextKey);
        this.contextCacheService.remove(contextID, contextKey);
        this.logger.info("From db and cache removeValue, csId:{},key:{}", (Object)contextID.getContextId(), (Object)contextKey.getKey());
    }

    @Override
    public void removeAllValue(ContextID contextID) throws CSErrorException {
        this.getPersistence().removeAll(contextID);
        this.contextCacheService.removeAll(contextID);
        this.logger.info("From db and cache removeAllValue, csId:{}", (Object)contextID.getContextId());
    }

    @Override
    public void removeAllValueByKeyPrefixAndContextType(ContextID contextID, ContextType contextType, String keyPrefix) throws CSErrorException {
        this.contextCacheService.removeByKeyPrefix(contextID, keyPrefix, contextType);
        this.getPersistence().removeByKeyPrefix(contextID, contextType, keyPrefix);
        this.logger.info("From db and cache  removeAllValueByKeyPrefixAndContextType, csId:{},csType:{},keyPrefix:{}", new Object[]{contextID.getContextId(), contextType, keyPrefix});
    }

    @Override
    public void removeValueByKeyAndContextType(ContextID contextID, ContextType contextType, String keyStr) throws CSErrorException {
        this.contextCacheService.removeByKey(contextID, keyStr, contextType);
        this.getPersistence().removeByKey(contextID, contextType, keyStr);
        this.logger.info("From db and cache  removeAllValueByKeyAndContextType, csId:{},csType:{},keyStr:{}", new Object[]{contextID.getContextId(), contextType, keyStr});
    }

    @Override
    public void removeAllValueByKeyPrefix(ContextID contextID, String keyPrefix) throws CSErrorException {
        this.contextCacheService.removeByKeyPrefix(contextID, keyPrefix);
        this.getPersistence().removeByKeyPrefix(contextID, keyPrefix);
        this.logger.info("From db and cache  removeAllValueByKeyPrefix, csId:{},keyPrefix:{}", (Object)contextID.getContextId(), (Object)keyPrefix);
    }

    @Override
    public int clearAllContextByID(List<String> idList) throws CSErrorException {
        int num = 0;
        for (String haid : idList) {
            try {
                HAContextID contextID = this.contextHAChecker.parseHAIDFromKey(haid);
                String csid = contextID.getContextId();
                contextID.setContextId(haid);
                this.getPersistence().removeAll((ContextID)contextID);
                this.getIDPersistence().deleteContextID(csid);
                ++num;
            }
            catch (Exception e) {
                this.logger.warn("clear all for haid : {}", (Object)haid, (Object)e);
            }
        }
        return num;
    }

    @Override
    public int clearAllContextByTime(Date createTimeStart, Date createTimeEnd, Date updateTimeStart, Date updateTimeEnd, Date accessTimeStart, Date accessTimeEnd) throws CSErrorException {
        int num = 0;
        List<PersistenceContextID> idList = this.getIDPersistence().searchCSIDByTime(createTimeStart, createTimeEnd, updateTimeStart, updateTimeEnd, accessTimeStart, accessTimeEnd);
        for (PersistenceContextID id : idList) {
            try {
                String csid = id.getContextId();
                this.logger.info("will clear context for csid : {}", (Object)csid);
                id.setContextId(this.contextHAChecker.convertHAIDToHAKey(id));
                this.getPersistence().removeAll((ContextID)id);
                this.getIDPersistence().deleteContextID(csid);
                ++num;
            }
            catch (Exception e) {
                this.logger.error("Clear context of id {} failed, {}", (Object)id.getContextId(), (Object)e.getMessage());
            }
        }
        return num;
    }
}

