/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.common.entity.resource;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.linkis.manager.common.entity.resource.Resource;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CPUResource
extends Resource {
    private int cores;

    public CPUResource() {
        this(Integer.MAX_VALUE);
    }

    public CPUResource(int cores) {
        this.cores = cores;
    }

    public int getCores() {
        return this.cores;
    }

    public void setCores(int cores) {
        this.cores = cores;
    }

    private CPUResource toCPUResource(Resource r) {
        CPUResource cpuResource = new CPUResource(Integer.MAX_VALUE);
        if (r instanceof CPUResource) {
            cpuResource = (CPUResource)r;
        }
        return cpuResource;
    }

    protected Resource toResource(int cores) {
        return new CPUResource(cores);
    }

    @Override
    public Resource add(Resource r) {
        CPUResource cpuResource = this.toCPUResource(r);
        return new CPUResource(this.getCores() + cpuResource.getCores());
    }

    @Override
    public Resource minus(Resource r) {
        CPUResource cpuResource = this.toCPUResource(r);
        return new CPUResource(this.getCores() - cpuResource.getCores());
    }

    @Override
    public Resource multiplied(Resource r) {
        CPUResource cpuResource = this.toCPUResource(r);
        return new CPUResource(this.getCores() * cpuResource.getCores());
    }

    @Override
    public Resource multiplied(float rate) {
        float cores = (float)this.getCores() * rate;
        return new CPUResource((int)cores);
    }

    @Override
    public Resource divide(Resource r) {
        CPUResource cpuResource = this.toCPUResource(r);
        return new CPUResource(this.getCores() / cpuResource.getCores());
    }

    @Override
    public Resource divide(int rate) {
        return new CPUResource(this.getCores() / rate);
    }

    @Override
    public boolean moreThan(Resource r) {
        CPUResource cpuResource = this.toCPUResource(r);
        return this.getCores() > cpuResource.getCores();
    }

    @Override
    public boolean caseMore(Resource r) {
        return this.moreThan(r);
    }

    @Override
    public boolean equalsTo(Resource r) {
        CPUResource cpuResource = this.toCPUResource(r);
        return this.cores == cpuResource.getCores();
    }

    @Override
    public boolean notLess(Resource r) {
        CPUResource cpuResource = this.toCPUResource(r);
        return this.getCores() >= cpuResource.getCores();
    }

    @Override
    public boolean less(Resource r) {
        return !this.notLess(r);
    }

    @Override
    public int compare(Resource r) {
        CPUResource cpuResource = this.toCPUResource(r);
        return Integer.compare(this.getCores(), cpuResource.getCores());
    }

    @Override
    public String toJson() {
        return String.format("{\"cpu\":%s}", this.cores);
    }

    public String toString() {
        return this.toJson();
    }
}

