/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.client.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.cs.client.ContextClient;
import org.apache.linkis.cs.client.builder.ContextClientFactory;
import org.apache.linkis.cs.client.service.CSResultDataService;
import org.apache.linkis.cs.client.service.DefaultSearchService;
import org.apache.linkis.cs.client.service.SearchService;
import org.apache.linkis.cs.client.utils.SerializeHelper;
import org.apache.linkis.cs.common.entity.data.CSResultData;
import org.apache.linkis.cs.common.entity.source.CommonContextValue;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.common.entity.source.ContextValue;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSResultDataServiceImpl
implements CSResultDataService {
    private static final Logger logger = LoggerFactory.getLogger(CSResultDataServiceImpl.class);
    private SearchService searchService = DefaultSearchService.getInstance();
    private static CSResultDataService csResultDataService;

    private CSResultDataServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CSResultDataService getInstance() {
        if (null != csResultDataService) return csResultDataService;
        Class<CSResultDataServiceImpl> clazz = CSResultDataServiceImpl.class;
        synchronized (CSResultDataServiceImpl.class) {
            if (null != csResultDataService) return csResultDataService;
            csResultDataService = new CSResultDataServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return csResultDataService;
        }
    }

    @Override
    public CSResultData getCSResultData(String contextIDStr, String contextKeyStr) throws CSErrorException {
        if (StringUtils.isBlank((CharSequence)contextIDStr) || StringUtils.isBlank((CharSequence)contextKeyStr)) {
            logger.warn("contextIDStr or nodeName cannot null");
            return null;
        }
        try {
            ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
            ContextKey contextKey = SerializeHelper.deserializeContextKey(contextKeyStr);
            return this.searchService.getContextValue(contextID, contextKey, CSResultData.class);
        }
        catch (ErrorException e) {
            logger.error("Deserialize failed, invalid contextId : " + contextIDStr + ", or contextKey : " + contextKeyStr + ", e : " + e.getMessage());
            logger.error("exception ", (Throwable)e);
            throw new CSErrorException(70112, "Deserialize failed, invalid contextId : " + contextIDStr + ", or contextKey : " + contextKeyStr + ", e : " + e.getMessage());
        }
    }

    @Override
    public void putCSResultData(String contextIDStr, String contextKeyStr, CSResultData csResultData) throws CSErrorException {
        ContextClient contextClient = ContextClientFactory.getOrCreateContextClient();
        try {
            ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
            ContextKey contextKey = SerializeHelper.deserializeContextKey(contextKeyStr);
            CommonContextValue contextValue = new CommonContextValue();
            contextValue.setValue((Object)csResultData);
            contextClient.update(contextID, contextKey, (ContextValue)contextValue);
            logger.info("succeed to update cs result data,contextIDStr: {}, contextKeyStr: {}", (Object)contextKey, (Object)contextKeyStr);
        }
        catch (ErrorException e) {
            logger.error("Deserialize error. e ", (Throwable)e);
            throw new CSErrorException(70112, "Deserialize error. e : " + e.getDesc());
        }
    }

    @Override
    public List<CSResultData> getUpstreamCSResultData(String contextIDStr, String nodeName) throws CSErrorException {
        List<CSResultData> rsList = new ArrayList<CSResultData>();
        if (StringUtils.isBlank((CharSequence)contextIDStr) || StringUtils.isBlank((CharSequence)nodeName)) {
            logger.warn("contextIDStr or nodeName cannot null");
            return rsList;
        }
        try {
            ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
            if (null != contextID) {
                rsList = this.searchService.searchUpstreamContext(contextID, nodeName, Integer.MAX_VALUE, CSResultData.class);
            }
            return rsList;
        }
        catch (ErrorException e) {
            logger.error("Deserialize contextID error. contextIDStr : " + contextIDStr, (Throwable)e);
            throw new CSErrorException(70112, "Deserialize contextID error. contextIDStr : " + contextIDStr + "e : " + e.getDesc());
        }
    }
}

