/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.scheduler;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.entrance.conf.EntranceConfiguration;
import org.apache.linkis.entrance.utils.EntranceUtils;
import org.apache.linkis.governance.common.protocol.conf.RequestQueryEngineConfig;
import org.apache.linkis.governance.common.protocol.conf.ResponseQueryConfig;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.rpc.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class CreatorECTypeDefaultConf {
    private static final Logger logger = LoggerFactory.getLogger(CreatorECTypeDefaultConf.class);
    public static Sender confSender = Sender.getSender((String)((String)Configuration.CLOUD_CONSOLE_CONFIGURATION_SPRING_APPLICATION_NAME().getValue()));
    private static LoadingCache<String, Integer> confCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(((Long)EntranceConfiguration.ENTRANCE_CREATOR_JOB_LIMIT_CONF_CACHE().getValue()).longValue(), TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Integer>(){

        public Integer load(String key) throws Exception {
            Tuple2<UserCreatorLabel, EngineTypeLabel> tuple2 = EntranceUtils.fromKeyGetLabels(key);
            RequestQueryEngineConfig requestQueryEngineConfig = new RequestQueryEngineConfig((UserCreatorLabel)tuple2._1, (EngineTypeLabel)tuple2._2(), null);
            int jobLimit = (Integer)EntranceConfiguration.ENTRANCE_CREATOR_JOB_LIMIT().getValue();
            try {
                Object response = confSender.ask((Object)requestQueryEngineConfig);
                if (response instanceof ResponseQueryConfig) {
                    jobLimit = (Integer)EntranceConfiguration.ENTRANCE_CREATOR_JOB_LIMIT().getValue(((ResponseQueryConfig)response).getKeyAndValue());
                }
            }
            catch (Exception e) {
                logger.warn("Failed to get key {} from conf", (Object)key, (Object)e);
            }
            return jobLimit;
        }
    });

    public static int getCreatorECTypeMaxRunningJobs(String creator, String ecType) {
        int jobLimit = (Integer)EntranceConfiguration.ENTRANCE_CREATOR_JOB_LIMIT().getValue();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{creator, ecType})) {
            try {
                String key = EntranceUtils.getDefaultCreatorECTypeKey(creator, ecType);
                jobLimit = (Integer)confCache.get((Object)key);
            }
            catch (Exception e) {
                logger.warn("Failed to get key creator {} ecType {} from cache", new Object[]{creator, ecType, e});
            }
        }
        int entranceNumber = EntranceUtils.getRunningEntranceNumber();
        return jobLimit / entranceNumber;
    }
}

