/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.parser;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.entrance.conf.EntranceConfiguration$;
import org.apache.linkis.entrance.utils.CommonLogPathUtils;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.apache.linkis.manager.label.utils.LabelUtil;
import org.apache.linkis.storage.utils.StorageUtils;

public final class ParserUtils {
    private static final Map<String, String> types = new HashMap<String, String>();

    public static void generateLogPath(JobRequest jobRequest, Map<String, String> params) {
        String logPath = null;
        String logPathPrefix = null;
        String logMid = "log";
        if (StringUtils.isEmpty(logPathPrefix)) {
            logPathPrefix = (String)EntranceConfiguration$.MODULE$.DEFAULT_LOGPATH_PREFIX().getValue();
        }
        if (logPathPrefix.endsWith("/")) {
            logPathPrefix = logPathPrefix.substring(0, logPathPrefix.length() - 1);
        }
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = dateFormat.format(date);
        String creator = (String)LabelUtil.getUserCreator((List)jobRequest.getLabels())._2;
        String umUser = jobRequest.getExecuteUser();
        FsPath lopPrefixPath = new FsPath(logPathPrefix);
        if (StorageUtils.HDFS().equals(lopPrefixPath.getFsType())) {
            String commonLogPath = logPathPrefix + "/" + "log" + "/" + dateString + "/" + creator;
            logPath = commonLogPath + "/" + umUser + "/" + jobRequest.getId() + ".log";
            CommonLogPathUtils.buildCommonPath(commonLogPath);
        } else {
            logPath = logPathPrefix + "/" + umUser + "/" + "log" + "/" + creator + "/" + dateString + "/" + jobRequest.getId() + ".log";
        }
        jobRequest.setLogPath(logPath);
    }

    public static String getCorrespondingType(String runType) {
        return types.get(runType.toLowerCase());
    }

    static {
        types.put("py", "python");
        types.put("python", "python");
        types.put("sql", "sql");
        types.put("pyspark", "python");
        types.put("scala", "scala");
        types.put("rspark", "r");
        types.put("r", "r");
        types.put("java", "java");
        types.put("hql", "hql");
        types.put("sparksql", "sql");
    }
}

