/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.interceptor.impl;

import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.log.LogUtils$;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.entrance.exception.EntranceErrorCode;
import org.apache.linkis.entrance.exception.EntranceIllegalParamException;
import org.apache.linkis.entrance.interceptor.impl.Explain;
import org.apache.linkis.entrance.interceptor.impl.SQLCommentHelper$;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;
import scala.util.matching.UnanchoredRegex;

public final class SQLExplain$
extends Explain {
    public static SQLExplain$ MODULE$;
    private final String SQL_DEFAULT_SEPERATOR;
    private final String NO_LIMIT_STRING;
    private final CommonVars<Object> SQL_DEFAULT_LIMIT;
    private final String SQL_APPEND_LIMIT;
    private final String DROP_TABLE_SQL;
    private final String CREATE_DATABASE_SQL;
    private final UnanchoredRegex IDE_ALLOW_NO_LIMIT_REGEX;
    private final String LINE_BREAK;
    private final String COMMENT_FLAG;
    private final String SET_OWN_USER;
    private final String LIMIT;
    private final String LIMIT_UPPERCASE;
    private final String IDE_ALLOW_NO_LIMIT;
    private final Logger LOG;

    static {
        new SQLExplain$();
    }

    public String SQL_DEFAULT_SEPERATOR() {
        return this.SQL_DEFAULT_SEPERATOR;
    }

    public String NO_LIMIT_STRING() {
        return this.NO_LIMIT_STRING;
    }

    public CommonVars<Object> SQL_DEFAULT_LIMIT() {
        return this.SQL_DEFAULT_LIMIT;
    }

    public String SQL_APPEND_LIMIT() {
        return this.SQL_APPEND_LIMIT;
    }

    public String DROP_TABLE_SQL() {
        return this.DROP_TABLE_SQL;
    }

    public String CREATE_DATABASE_SQL() {
        return this.CREATE_DATABASE_SQL;
    }

    private UnanchoredRegex IDE_ALLOW_NO_LIMIT_REGEX() {
        return this.IDE_ALLOW_NO_LIMIT_REGEX;
    }

    private String LINE_BREAK() {
        return this.LINE_BREAK;
    }

    private String COMMENT_FLAG() {
        return this.COMMENT_FLAG;
    }

    public String SET_OWN_USER() {
        return this.SET_OWN_USER;
    }

    private String LIMIT() {
        return this.LIMIT;
    }

    private String LIMIT_UPPERCASE() {
        return this.LIMIT_UPPERCASE;
    }

    private String IDE_ALLOW_NO_LIMIT() {
        return this.IDE_ALLOW_NO_LIMIT;
    }

    private Logger LOG() {
        return this.LOG;
    }

    @Override
    public boolean authPass(String code, scala.collection.mutable.StringBuilder error) {
        return true;
    }

    public void dealSQLLimit(String executionCode, JobRequest requestPersistTask, StringBuilder logAppender) {
        ArrayBuffer fixedCode = new ArrayBuffer();
        String tempCode1 = SQLCommentHelper$.MODULE$.dealComment(executionCode);
        String tempCode = SQLCommentHelper$.MODULE$.replaceComment(tempCode1);
        boolean isNoLimitAllowed = BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Regex)MODULE$.IDE_ALLOW_NO_LIMIT_REGEX()).findFirstIn((CharSequence)executionCode).isDefined(), (Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SQLExplain$.$anonfun$dealSQLLimit$2(executionCode, x0$1))));
        Object object = isNoLimitAllowed ? logAppender.append(LogUtils$.MODULE$.generateWarn("please pay attention ,SQL full export mode opened(\u8bf7\u6ce8\u610f,SQL\u5168\u91cf\u5bfc\u51fa\u6a21\u5f0f\u6253\u5f00)\n")) : BoxedUnit.UNIT;
        BooleanRef isFirstTimePrintingLimit = BooleanRef.create((boolean)true);
        BooleanRef isFirstTimePrintingOverLimit = BooleanRef.create((boolean)true);
        if (tempCode.contains("\\;")) {
            int[] semicolonIndexes = this.findRealSemicolonIndex(tempCode);
            IntRef oldIndex = IntRef.create((int)0);
            new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(semicolonIndexes)).foreach((Function1 & Serializable & scala.Serializable)index -> SQLExplain$.$anonfun$dealSQLLimit$3(tempCode, oldIndex, isNoLimitAllowed, isFirstTimePrintingLimit, logAppender, fixedCode, isFirstTimePrintingOverLimit, BoxesRunTime.unboxToInt((Object)index)));
        } else {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tempCode.split(";"))).foreach((Function1 & Serializable & scala.Serializable)singleCode -> {
                if (MODULE$.isSelectCmd((String)singleCode)) {
                    String trimCode = singleCode.trim();
                    if (MODULE$.isSelectCmdNoLimit(trimCode) && !isNoLimitAllowed) {
                        if (isFirstTimePrintingLimit$1.elem) {
                            logAppender.append(new StringBuilder(1).append(LogUtils$.MODULE$.generateWarn("You submitted a sql without limit, DSS will add limit 5000 to your sql")).append("\n").toString());
                            isFirstTimePrintingLimit$1.elem = false;
                        }
                        String realCode = MODULE$.cleanComment(trimCode);
                        return fixedCode.$plus$eq((Object)new StringBuilder(0).append(realCode).append(MODULE$.SQL_APPEND_LIMIT()).toString());
                    }
                    if (MODULE$.isSelectOverLimit((String)singleCode) && !isNoLimitAllowed) {
                        String trimCode2 = singleCode.trim();
                        if (isFirstTimePrintingOverLimit$1.elem) {
                            logAppender.append(new StringBuilder(1).append(LogUtils$.MODULE$.generateWarn("You submitted a sql with limit exceeding 5000, it is not allowed. DSS will change your limit to 5000")).append("\n").toString());
                            isFirstTimePrintingOverLimit$1.elem = false;
                        }
                        return fixedCode.$plus$eq((Object)MODULE$.repairSelectOverLimit(trimCode2));
                    }
                    return fixedCode.$plus$eq((Object)singleCode.trim());
                }
                return fixedCode.$plus$eq((Object)singleCode.trim());
            });
        }
        logAppender.append(LogUtils$.MODULE$.generateInfo("SQL code check has passed\n"));
        requestPersistTask.setExecutionCode(fixedCode.mkString(";\n"));
        if (StringUtils.isEmpty((CharSequence)requestPersistTask.getExecutionCode())) {
            throw new EntranceIllegalParamException(EntranceErrorCode.EXECUTION_CODE_ISNULL.getErrCode(), EntranceErrorCode.EXECUTION_CODE_ISNULL.getDesc());
        }
        this.logger().debug(new StringBuilder(24).append("after sql limit code is ").append(requestPersistTask.getExecutionCode()).toString());
    }

    private int[] findRealSemicolonIndex(String tempCode) {
        String realTempCode = !tempCode.endsWith(";") ? new StringBuilder(1).append(tempCode).append(";").toString() : tempCode;
        ArrayBuffer array = new ArrayBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), realTempCode.length() - 1).foreach((Function1 & Serializable & scala.Serializable)i -> SQLExplain$.$anonfun$findRealSemicolonIndex$1(realTempCode, array, BoxesRunTime.unboxToInt((Object)i)));
        return (int[])array.toArray(ClassTag$.MODULE$.Int());
    }

    private String addNoLimit(String code) {
        return new StringBuilder(0).append(code).append(this.NO_LIMIT_STRING()).toString();
    }

    public boolean needNoLimit(String code) {
        return code.endsWith(this.NO_LIMIT_STRING());
    }

    public boolean isSelectCmd(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return false;
        }
        String realCode = this.cleanComment(code);
        return realCode.trim().split("\\s+")[0].toLowerCase(Locale.getDefault()).contains("select");
    }

    public boolean isSelectCmdNoLimit(String cmd) {
        if (StringUtils.isEmpty((CharSequence)cmd)) {
            return false;
        }
        String realCode = cmd.trim();
        String[] arr = realCode.split("\\s+");
        ArrayBuffer words = new ArrayBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr)).foreach((Function1 & Serializable & scala.Serializable)w -> {
            SQLExplain$.$anonfun$isSelectCmdNoLimit$1(words, w);
            return BoxedUnit.UNIT;
        });
        String[] a = (String[])words.toArray(ClassTag$.MODULE$.apply(String.class));
        int length = a.length;
        if (a.length > 1) {
            String second_last = a[length - 2].toLowerCase(Locale.getDefault());
            boolean result = !"limit".equals(second_last) && !second_last.contains(")limit");
            return result;
        }
        return false;
    }

    private String cleanComment(String sql) {
        scala.collection.mutable.StringBuilder cleanSql = new scala.collection.mutable.StringBuilder();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sql.trim().split(this.LINE_BREAK()))).foreach((Function1 & Serializable & scala.Serializable)singleSql -> {
            if (!singleSql.trim().startsWith(MODULE$.COMMENT_FLAG())) {
                return cleanSql.append(singleSql).append(MODULE$.LINE_BREAK());
            }
            return BoxedUnit.UNIT;
        });
        return cleanSql.toString().trim();
    }

    public boolean isSelectOverLimit(String cmd) {
        boolean overLimit;
        block2: {
            int limitNum;
            boolean hasLimit;
            if (StringUtils.isEmpty((CharSequence)cmd)) {
                return false;
            }
            overLimit = false;
            String code = cmd.trim();
            if (code.toLowerCase(Locale.getDefault()).contains(this.LIMIT())) {
                code = code.substring(code.toLowerCase(Locale.getDefault()).lastIndexOf(this.LIMIT())).trim();
            }
            if (!(hasLimit = code.toLowerCase().matches("limit\\s+\\d+\\s*;?")) || (limitNum = new StringOps(Predef$.MODULE$.augmentString(code = code.indexOf(";") > 0 ? code.substring(5, code.length() - 1).trim() : code.substring(5).trim())).toInt()) <= BoxesRunTime.unboxToInt((Object)this.SQL_DEFAULT_LIMIT().getValue())) break block2;
            overLimit = true;
        }
        return overLimit;
    }

    public String repairSelectOverLimit(String cmd) {
        String code = cmd.trim();
        String preCode = "";
        String tailCode = "";
        int limitNum = BoxesRunTime.unboxToInt((Object)this.SQL_DEFAULT_LIMIT().getValue());
        String lowerCaseCode = code.toLowerCase(Locale.getDefault());
        if (lowerCaseCode.contains(this.LIMIT())) {
            preCode = code.substring(0, lowerCaseCode.lastIndexOf(this.LIMIT())).trim();
            tailCode = code.substring(lowerCaseCode.lastIndexOf(this.LIMIT())).trim();
        }
        if (this.isUpperSelect(cmd)) {
            return new StringBuilder(7).append(preCode).append(" LIMIT ").append(limitNum).toString();
        }
        return new StringBuilder(7).append(preCode).append(" limit ").append(limitNum).toString();
    }

    private boolean isUpperSelect(String selectSql) {
        return selectSql.trim().startsWith("SELECT");
    }

    public static final /* synthetic */ boolean $anonfun$dealSQLLimit$2(String executionCode$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            MODULE$.logger().warn("sql limit check error happens");
            return executionCode$1.contains(MODULE$.IDE_ALLOW_NO_LIMIT());
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$dealSQLLimit$3(String tempCode$1, IntRef oldIndex$1, boolean isNoLimitAllowed$1, BooleanRef isFirstTimePrintingLimit$1, StringBuilder logAppender$1, ArrayBuffer fixedCode$1, BooleanRef isFirstTimePrintingOverLimit$1, int index) {
        String singleCode = tempCode$1.substring(oldIndex$1.elem, index);
        oldIndex$1.elem = index + 1;
        if (MODULE$.isSelectCmd(singleCode)) {
            String trimCode = singleCode.trim();
            if (MODULE$.isSelectCmdNoLimit(trimCode) && !isNoLimitAllowed$1) {
                if (isFirstTimePrintingLimit$1.elem) {
                    logAppender$1.append(new StringBuilder(1).append(LogUtils$.MODULE$.generateWarn("You submitted a sql without limit, DSS will add limit 5000 to your sql")).append("\n").toString());
                    isFirstTimePrintingLimit$1.elem = false;
                }
                String realCode = MODULE$.cleanComment(trimCode);
                return fixedCode$1.$plus$eq((Object)new StringBuilder(0).append(realCode).append(MODULE$.SQL_APPEND_LIMIT()).toString());
            }
            if (MODULE$.isSelectOverLimit(singleCode) && !isNoLimitAllowed$1) {
                String trimCode2 = singleCode.trim();
                if (isFirstTimePrintingOverLimit$1.elem) {
                    logAppender$1.append(new StringBuilder(1).append(LogUtils$.MODULE$.generateWarn("You submitted a sql with limit exceeding 5000, it is not allowed. DSS will change your limit to 5000")).append("\n").toString());
                    isFirstTimePrintingOverLimit$1.elem = false;
                }
                return fixedCode$1.$plus$eq((Object)MODULE$.repairSelectOverLimit(trimCode2));
            }
            return fixedCode$1.$plus$eq((Object)singleCode.trim());
        }
        return fixedCode$1.$plus$eq((Object)singleCode.trim());
    }

    public static final /* synthetic */ Object $anonfun$findRealSemicolonIndex$1(String realTempCode$1, ArrayBuffer array$1, int i) {
        if ('\\' != realTempCode$1.charAt(i) && ';' == realTempCode$1.charAt(i + 1)) {
            return array$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(i + 1)));
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$isSelectCmdNoLimit$1(ArrayBuffer words$1, String w) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])w.split("\n"))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> words$1.$plus$eq(x$1));
    }

    private SQLExplain$() {
        MODULE$ = this;
        this.SQL_DEFAULT_SEPERATOR = ";";
        this.NO_LIMIT_STRING = "\n!with no limit!";
        this.SQL_DEFAULT_LIMIT = CommonVars$.MODULE$.apply("wds.linkis.sql.default.limit", (Object)BoxesRunTime.boxToInteger((int)5000));
        this.SQL_APPEND_LIMIT = new StringBuilder(7).append(" limit ").append(this.SQL_DEFAULT_LIMIT().getValue()).toString();
        this.DROP_TABLE_SQL = "\\s*drop\\s+table\\s+\\w+\\s*";
        this.CREATE_DATABASE_SQL = "\\s*create\\s+database\\s+\\w+\\s*";
        this.IDE_ALLOW_NO_LIMIT_REGEX = new StringOps(Predef$.MODULE$.augmentString("--set\\s*ide.engine.no.limit.allow\\s*=\\s*true")).r().unanchored();
        this.LINE_BREAK = "\n";
        this.COMMENT_FLAG = "--";
        this.SET_OWN_USER = "set owner user";
        this.LIMIT = "limit";
        this.LIMIT_UPPERCASE = "LIMIT";
        this.IDE_ALLOW_NO_LIMIT = "--set wds.linkis.engine.no.limit.allow=true";
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }
}

