/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.annotation;

import feign.MethodMetadata;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import org.springframework.cloud.openfeign.AnnotatedParameterProcessor;
import org.springframework.web.bind.annotation.CookieValue;

public class CookieValueParameterProcessor
implements AnnotatedParameterProcessor {
    private static final Class<CookieValue> ANNOTATION = CookieValue.class;

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return ANNOTATION;
    }

    @Override
    public boolean processArgument(AnnotatedParameterProcessor.AnnotatedParameterContext context, Annotation annotation, Method method) {
        int parameterIndex = context.getParameterIndex();
        MethodMetadata data = context.getMethodMetadata();
        CookieValue cookie = ANNOTATION.cast(annotation);
        String name = cookie.value().trim();
        Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"Cookie.name() was empty on parameter %s", (Object[])new Object[]{parameterIndex});
        context.setParameterName(name);
        String cookieExpression = ((Collection)data.template().headers().getOrDefault("Cookie", Collections.singletonList(""))).stream().findFirst().orElse("");
        cookieExpression = cookieExpression.length() == 0 ? String.format("%s={%s}", name, name) : cookieExpression + String.format("; %s={%s}", name, name);
        data.template().removeHeader("Cookie");
        data.template().header("Cookie", new String[]{cookieExpression});
        return true;
    }
}

