/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.rm.external.service.impl;

import com.fasterxml.jackson.core.JsonParseException;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.ConnectException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.manager.common.conf.RMConfiguration;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.entity.resource.ResourceType;
import org.apache.linkis.manager.common.errorcode.ManagerCommonErrorCodeSummary;
import org.apache.linkis.manager.common.exception.RMErrorException;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.cluster.ClusterLabel;
import org.apache.linkis.manager.rm.domain.RMLabelContainer;
import org.apache.linkis.manager.rm.external.dao.ExternalResourceProviderDao;
import org.apache.linkis.manager.rm.external.domain.ExternalAppInfo;
import org.apache.linkis.manager.rm.external.domain.ExternalResourceIdentifier;
import org.apache.linkis.manager.rm.external.domain.ExternalResourceProvider;
import org.apache.linkis.manager.rm.external.parser.ExternalResourceIdentifierParser;
import org.apache.linkis.manager.rm.external.parser.YarnResourceIdentifierParser;
import org.apache.linkis.manager.rm.external.request.ExternalResourceRequester;
import org.apache.linkis.manager.rm.external.service.ExternalResourceService;
import org.apache.linkis.manager.rm.external.yarn.YarnResourceRequester;
import org.apache.linkis.manager.rm.utils.RMUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExternalResourceServiceImpl
implements ExternalResourceService,
InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ExternalResourceProviderDao providerDao;
    ExternalResourceIdentifierParser[] identifierParsers;
    ExternalResourceRequester[] resourceRequesters;
    private LoadingCache<String, List<ExternalResourceProvider>> providerCache = CacheBuilder.newBuilder().maximumSize(20L).expireAfterAccess(1L, TimeUnit.HOURS).refreshAfterWrite(((TimeType)RMUtils.EXTERNAL_RESOURCE_REFRESH_TIME().getValue()).toLong(), TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List<ExternalResourceProvider>>(){

        public List<ExternalResourceProvider> load(String resourceType) {
            return ExternalResourceServiceImpl.this.providerDao.selectByResourceType(resourceType);
        }
    });

    public void afterPropertiesSet() throws Exception {
        this.resourceRequesters = new ExternalResourceRequester[]{new YarnResourceRequester()};
        this.identifierParsers = new ExternalResourceIdentifierParser[]{new YarnResourceIdentifierParser()};
    }

    @Override
    public NodeResource getResource(ResourceType resourceType, RMLabelContainer labelContainer, Map<String, Object> identifierMap) throws RMErrorException {
        ExternalResourceIdentifier identifier = this.getIdentifierParser(resourceType).parse(identifierMap);
        return this.getResource(resourceType, labelContainer, identifier);
    }

    @Override
    public NodeResource getResource(ResourceType resourceType, RMLabelContainer labelContainer, ExternalResourceIdentifier identifier) throws RMErrorException {
        ExternalResourceProvider provider = this.chooseProvider(resourceType, labelContainer);
        ExternalResourceRequester externalResourceRequester = this.getRequester(resourceType);
        NodeResource resource = (NodeResource)this.retry((Integer)RMConfiguration.EXTERNAL_RETRY_NUM.getValue(), i -> externalResourceRequester.requestResourceInfo(identifier, provider), i -> externalResourceRequester.reloadExternalResourceAddress(provider));
        return resource;
    }

    @Override
    public List<ExternalAppInfo> getAppInfo(ResourceType resourceType, RMLabelContainer labelContainer, Map<String, Object> identifierMap) throws RMErrorException {
        ExternalResourceIdentifier identifier = this.getIdentifierParser(resourceType).parse(identifierMap);
        return this.getAppInfo(resourceType, labelContainer, identifier);
    }

    @Override
    public List<ExternalAppInfo> getAppInfo(ResourceType resourceType, RMLabelContainer labelContainer, ExternalResourceIdentifier identifier) throws RMErrorException {
        ExternalResourceProvider provider = this.chooseProvider(resourceType, labelContainer);
        ExternalResourceRequester externalResourceRequester = this.getRequester(resourceType);
        List appInfos = (List)this.retry((Integer)RMConfiguration.EXTERNAL_RETRY_NUM.getValue(), i -> externalResourceRequester.requestAppInfo(identifier, provider), i -> externalResourceRequester.reloadExternalResourceAddress(provider));
        return appInfos;
    }

    private Object retry(int retryNum, Function function, Function reloadExternalAddress) throws RMErrorException {
        String errorMsg = "Failed to request external resource";
        for (int times = 0; times < retryNum; ++times) {
            try {
                return function.apply(null);
            }
            catch (Exception e) {
                if ((JsonParseException.class.isInstance(e.getCause()) && e.getCause().getMessage().contains("This is standby RM") || ConnectException.class.isInstance(e.getCause())) && null != reloadExternalAddress) {
                    try {
                        reloadExternalAddress.apply(null);
                    }
                    catch (Exception e1) {
                        this.logger.error("ReloadExternalAddress failed. {}", (Object)e.getMessage(), (Object)e);
                    }
                }
                errorMsg = "Failed to request external resource" + ExceptionUtils.getRootCauseMessage((Throwable)e);
                this.logger.warn("failed to request external resource provider, retryNum {}", (Object)times, (Object)e);
                continue;
            }
        }
        throw new RMErrorException(ManagerCommonErrorCodeSummary.FAILED_REQUEST_RESOURCE.getErrorCode(), errorMsg);
    }

    @Override
    public ExternalResourceProvider chooseProvider(ResourceType resourceType, RMLabelContainer labelContainer) throws RMErrorException {
        Label label = labelContainer.find(ClusterLabel.class);
        ClusterLabel realClusterLabel = null;
        if (label == null) {
            realClusterLabel = (ClusterLabel)LabelBuilderFactoryContext.getLabelBuilderFactory().createLabel(ClusterLabel.class);
            realClusterLabel.setClusterName((String)RMConfiguration.DEFAULT_YARN_CLUSTER_NAME.getValue());
            realClusterLabel.setClusterType((String)RMConfiguration.DEFAULT_YARN_TYPE.getValue());
        } else {
            realClusterLabel = (ClusterLabel)label;
        }
        try {
            List providers = (List)this.providerCache.get((Object)resourceType.toString());
            for (ExternalResourceProvider provider : providers) {
                if (!provider.getName().equals(realClusterLabel.getClusterName())) continue;
                return provider;
            }
        }
        catch (ExecutionException e) {
            throw new RMErrorException(ManagerCommonErrorCodeSummary.NO_SUITABLE_CLUSTER.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.NO_SUITABLE_CLUSTER.getErrorDesc(), realClusterLabel.getClusterName()), (Throwable)e);
        }
        throw new RMErrorException(ManagerCommonErrorCodeSummary.NO_SUITABLE_CLUSTER.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.NO_SUITABLE_CLUSTER.getErrorDesc(), realClusterLabel.getClusterName()));
    }

    private ExternalResourceRequester getRequester(ResourceType resourceType) throws RMErrorException {
        for (ExternalResourceRequester externalResourceRequester : this.resourceRequesters) {
            if (!externalResourceRequester.getResourceType().equals((Object)resourceType)) continue;
            return externalResourceRequester;
        }
        throw new RMErrorException(ManagerCommonErrorCodeSummary.NO_FOUND_RESOURCE_TYPE.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.NO_FOUND_RESOURCE_TYPE.getErrorDesc(), resourceType));
    }

    private ExternalResourceIdentifierParser getIdentifierParser(ResourceType resourceType) throws RMErrorException {
        for (ExternalResourceIdentifierParser identifierParser : this.identifierParsers) {
            if (!identifierParser.getResourceType().equals((Object)resourceType)) continue;
            return identifierParser;
        }
        throw new RMErrorException(ManagerCommonErrorCodeSummary.NO_FOUND_RESOURCE_TYPE.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.NO_FOUND_RESOURCE_TYPE.getErrorDesc(), resourceType));
    }
}

