/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.jobhistory.restful.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.linkis.governance.common.entity.job.QueryException;
import org.apache.linkis.jobhistory.entity.JobStatistics;
import org.apache.linkis.jobhistory.service.JobStatisticsQueryService;
import org.apache.linkis.jobhistory.util.QueryUtils;
import org.apache.linkis.server.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"jobstatistics api"})
@RestController
@RequestMapping(path={"/jobhistory/jobstatistics"})
public class StatisticsRestfulApi {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private JobStatisticsQueryService jobStatisticsQueryService;

    @ApiOperation(value="taskCount", notes="taskCount", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="startDate", dataType="long"), @ApiImplicitParam(name="endDate", required=false, dataType="long", value="end date"), @ApiImplicitParam(name="executeApplicationName", dataType="String"), @ApiImplicitParam(name="creator", required=false, dataType="String", value="creator"), @ApiImplicitParam(name="proxyUser", required=false, dataType="String", value="proxyUser")})
    @RequestMapping(path={"/taskCount"}, method={RequestMethod.GET})
    public Message taskCount(HttpServletRequest req, @RequestParam(value="startDate", required=false) Long startDate, @RequestParam(value="endDate", required=false) Long endDate, @RequestParam(value="executeApplicationName", required=false) String executeApplicationName, @RequestParam(value="creator", required=false) String creator, @RequestParam(value="proxyUser", required=false) String proxyUser) throws IOException, QueryException {
        if (endDate == null) {
            endDate = System.currentTimeMillis();
        }
        if (startDate == null) {
            startDate = 0L;
        }
        Date sDate = new Date(startDate);
        Date eDate = new Date(endDate);
        if (startDate == 0L) {
            sDate = DateUtils.addDays((Date)eDate, (int)-1);
        }
        if (sDate.getTime() == eDate.getTime()) {
            Calendar instance = Calendar.getInstance();
            instance.setTimeInMillis(endDate);
            instance.add(5, 1);
            eDate = new Date(instance.getTime().getTime());
        }
        if (StringUtils.isEmpty((Object)proxyUser)) {
            proxyUser = null;
        } else if (!QueryUtils.checkNameValid(proxyUser)) {
            return Message.error((String)("Invalid proxyUser : " + proxyUser));
        }
        if (StringUtils.isEmpty((Object)creator)) {
            creator = null;
        } else if (!QueryUtils.checkNameValid(creator)) {
            return Message.error((String)("Invalid creator : " + creator));
        }
        if (!StringUtils.isEmpty((Object)executeApplicationName)) {
            if (!QueryUtils.checkNameValid(executeApplicationName)) {
                return Message.error((String)("Invalid applicationName : " + executeApplicationName));
            }
        } else {
            executeApplicationName = null;
        }
        JobStatistics jobStatistics = this.jobStatisticsQueryService.taskExecutionStatistics(sDate, eDate, proxyUser, creator, executeApplicationName);
        return Message.ok().data("sumCount", (Object)jobStatistics.getSumCount()).data("succeedCount", (Object)jobStatistics.getSucceedCount()).data("failedCount", (Object)jobStatistics.getFailedCount()).data("cancelledCount", (Object)jobStatistics.getCancelledCount());
    }

    @ApiOperation(value="engineCount", notes="engineCount", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="startDate", dataType="long"), @ApiImplicitParam(name="endDate", required=false, dataType="long", value="end date"), @ApiImplicitParam(name="executeApplicationName", dataType="String"), @ApiImplicitParam(name="creator", required=false, dataType="String", value="creator"), @ApiImplicitParam(name="proxyUser", required=false, dataType="String", value="proxyUser")})
    @RequestMapping(path={"/engineCount"}, method={RequestMethod.GET})
    public Message engineCount(HttpServletRequest req, @RequestParam(value="startDate", required=false) Long startDate, @RequestParam(value="endDate", required=false) Long endDate, @RequestParam(value="executeApplicationName", required=false) String executeApplicationName, @RequestParam(value="creator", required=false) String creator, @RequestParam(value="proxyUser", required=false) String proxyUser) throws IOException, QueryException {
        if (endDate == null) {
            endDate = System.currentTimeMillis();
        }
        if (startDate == null) {
            startDate = 0L;
        }
        Date sDate = new Date(startDate);
        Date eDate = new Date(endDate);
        if (startDate == 0L) {
            sDate = DateUtils.addDays((Date)eDate, (int)-1);
        }
        if (sDate.getTime() == eDate.getTime()) {
            Calendar instance = Calendar.getInstance();
            instance.setTimeInMillis(endDate);
            instance.add(5, 1);
            eDate = new Date(instance.getTime().getTime());
        }
        if (StringUtils.isEmpty((Object)proxyUser)) {
            proxyUser = null;
        } else if (!QueryUtils.checkNameValid(proxyUser)) {
            return Message.error((String)("Invalid proxyUser : " + proxyUser));
        }
        if (StringUtils.isEmpty((Object)creator)) {
            creator = null;
        } else if (!QueryUtils.checkNameValid(creator)) {
            return Message.error((String)("Invalid creator : " + creator));
        }
        if (!StringUtils.isEmpty((Object)executeApplicationName)) {
            if (!QueryUtils.checkNameValid(executeApplicationName)) {
                return Message.error((String)("Invalid applicationName : " + executeApplicationName));
            }
        } else {
            executeApplicationName = null;
        }
        JobStatistics jobStatistics = this.jobStatisticsQueryService.engineExecutionStatistics(sDate, eDate, proxyUser, creator, executeApplicationName);
        return Message.ok().data("countEngine", (Object)jobStatistics.getSumCount()).data("countEngineSucceed", (Object)jobStatistics.getSucceedCount()).data("countEngineFailed", (Object)jobStatistics.getFailedCount()).data("countEngineShutting", (Object)jobStatistics.getCancelledCount());
    }
}

