/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.common.serialize.impl.context;

import java.util.HashMap;
import java.util.Map;
import org.apache.linkis.cs.common.entity.source.CommonContextValue;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.common.serialize.AbstractSerializer;
import org.apache.linkis.cs.common.serialize.helper.ContextSerializationHelper;
import org.apache.linkis.cs.common.utils.CSCommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextValueSerializer
extends AbstractSerializer<CommonContextValue> {
    private static final Logger logger = LoggerFactory.getLogger(ContextValueSerializer.class);

    @Override
    public String getType() {
        return "contextValue";
    }

    @Override
    public String getJsonValue(CommonContextValue commonContextValue) throws CSErrorException {
        Object value = commonContextValue.getValue();
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            String keywords = commonContextValue.getKeywords();
            String json = ContextSerializationHelper.getInstance().serialize(value);
            map.put("keywords", keywords);
            map.put("value", json);
            return CSCommonUtils.gson.toJson(map);
        }
        catch (Exception e) {
            logger.error("Failed to serialize contextValue: ", (Throwable)e);
            throw new CSErrorException(97000, "Failed to serialize contextValue");
        }
    }

    @Override
    public CommonContextValue fromJson(String json) throws CSErrorException {
        try {
            Map jsonObj = (Map)CSCommonUtils.gson.fromJson(json, new HashMap().getClass());
            String value = (String)jsonObj.get("value");
            String keywords = (String)jsonObj.get("keywords");
            Object valueObj = ContextSerializationHelper.getInstance().deserialize(value);
            CommonContextValue commonContextValue = new CommonContextValue();
            commonContextValue.setKeywords(keywords);
            commonContextValue.setValue(valueObj);
            return commonContextValue;
        }
        catch (Exception e) {
            logger.error("Failed to deserialize contextValue: ", (Throwable)e);
            throw new CSErrorException(97000, "Failed to serialize contextValue");
        }
    }

    @Override
    public boolean accepts(Object obj) {
        return null != obj && obj instanceof CommonContextValue;
    }
}

