/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.utils;

import java.io.Serializable;
import java.text.NumberFormat;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkJobInfo;
import org.apache.spark.SparkStageInfo;
import org.apache.spark.SparkStatusTracker;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class JobProgressUtil$
implements Logging {
    public static JobProgressUtil$ MODULE$;
    private NumberFormat _percentFormat;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new JobProgressUtil$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        JobProgressUtil$ jobProgressUtil$ = this;
        synchronized (jobProgressUtil$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public float progress(SparkContext sc, String jobGroup) {
        int[] jobIds = sc.statusTracker().getJobIdsForGroup(jobGroup);
        SparkJobInfo[] jobs = (SparkJobInfo[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(jobIds)).flatMap((Function1 & Serializable & scala.Serializable)id -> Option$.MODULE$.option2Iterable(sc.statusTracker().getJobInfo(BoxesRunTime.unboxToInt((Object)id))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SparkJobInfo.class)));
        SparkStageInfo[] stages = (SparkStageInfo[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jobs)).flatMap((Function1 & Serializable & scala.Serializable)job -> new ArrayOps.ofRef(JobProgressUtil$.$anonfun$progress$2(sc, job)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SparkStageInfo.class)));
        int taskCount = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stages)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.numTasks()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int completedTaskCount = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stages)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.numCompletedTasks()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        if (taskCount == 0) {
            return 0.0f;
        }
        return (float)((double)completedTaskCount / (double)taskCount);
    }

    public JobProgressInfo[] getActiveJobProgressInfo(SparkContext sc, String jobGroup) {
        int[] jobIds = sc.statusTracker().getJobIdsForGroup(jobGroup);
        SparkJobInfo[] activeJobs = (SparkJobInfo[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(jobIds)).flatMap((Function1 & Serializable & scala.Serializable)id -> Option$.MODULE$.option2Iterable(sc.statusTracker().getJobInfo(BoxesRunTime.unboxToInt((Object)id))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SparkJobInfo.class))))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)JobProgressUtil$.$anonfun$getActiveJobProgressInfo$2(x$3)));
        JobProgressInfo[] progressInfos = (JobProgressInfo[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])activeJobs)).map((Function1 & Serializable & scala.Serializable)job -> {
            JobProgressInfo jobProgressInfo = MODULE$.getJobProgressInfoByStages((SparkJobInfo)job, sc, jobGroup);
            String timestamp = DateFormatUtils.format((long)System.currentTimeMillis(), (String)"yyyy-MM-dd HH:mm:ss");
            double progress = (double)jobProgressInfo.succeedTasks() * 1.0 / (double)jobProgressInfo.totalTasks();
            MODULE$.logger().info(new StringBuilder(66).append(jobProgressInfo.id()).append(" numTasks = ").append(jobProgressInfo.totalTasks()).append(", numCompletedTasks = ").append(jobProgressInfo.succeedTasks()).append(",").append(" numActiveTasks = ").append(jobProgressInfo.runningTasks()).append(" , completed:").append(MODULE$.percentageFormat(progress)).toString());
            return jobProgressInfo;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(JobProgressInfo.class)));
        return progressInfos;
    }

    public JobProgressInfo[] getCompletedJobProgressInfo(SparkContext sc, String jobGroup) {
        int[] jobIds = sc.statusTracker().getJobIdsForGroup(jobGroup);
        SparkJobInfo[] completedJobs = (SparkJobInfo[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(jobIds)).flatMap((Function1 & Serializable & scala.Serializable)id -> Option$.MODULE$.option2Iterable(sc.statusTracker().getJobInfo(BoxesRunTime.unboxToInt((Object)id))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SparkJobInfo.class))))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)JobProgressUtil$.$anonfun$getCompletedJobProgressInfo$2(x$4)));
        JobProgressInfo[] progressInfos = (JobProgressInfo[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])completedJobs)).map((Function1 & Serializable & scala.Serializable)job -> MODULE$.getJobProgressInfoByStages((SparkJobInfo)job, sc, jobGroup), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(JobProgressInfo.class)));
        return progressInfos;
    }

    private JobProgressInfo getJobProgressInfoByStages(SparkJobInfo job, SparkContext sc, String jobGroup) {
        SparkStatusTracker sparkStatusTracker = sc.statusTracker();
        SparkStageInfo[] stages = (SparkStageInfo[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(job.stageIds())).flatMap((Function1 & Serializable & scala.Serializable)stageId -> Option$.MODULE$.option2Iterable(sparkStatusTracker.getStageInfo(BoxesRunTime.unboxToInt((Object)stageId))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SparkStageInfo.class)));
        IntRef numTasks = IntRef.create((int)0);
        IntRef numActiveTasks = IntRef.create((int)0);
        IntRef numFailedTasks = IntRef.create((int)0);
        IntRef numSucceedTasks = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stages)).foreach((Function1 & Serializable & scala.Serializable)stageInfo -> {
            JobProgressUtil$.$anonfun$getJobProgressInfoByStages$2(numTasks, numActiveTasks, numFailedTasks, numSucceedTasks, stageInfo);
            return BoxedUnit.UNIT;
        });
        return new JobProgressInfo(this.getJobId(job.jobId(), jobGroup), numTasks.elem, numActiveTasks.elem, numFailedTasks.elem, numSucceedTasks.elem);
    }

    private String getJobId(int jobId, String jobGroup) {
        return new StringBuilder(8).append("jobId-").append(jobId).append("(").append(jobGroup).append(")").toString();
    }

    private NumberFormat _percentFormat() {
        return this._percentFormat;
    }

    private void _percentFormat_$eq(NumberFormat x$1) {
        this._percentFormat = x$1;
    }

    public String percentageFormat(double decimal) {
        block0: {
            if (this._percentFormat() != null) break block0;
            this._percentFormat_$eq(NumberFormat.getPercentInstance());
            this._percentFormat().setMinimumFractionDigits(2);
        }
        return this._percentFormat().format(decimal);
    }

    public static final /* synthetic */ Object[] $anonfun$progress$2(SparkContext sc$1, SparkJobInfo job) {
        SparkStatusTracker sparkStatusTracker = sc$1.statusTracker();
        return Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(job.stageIds())).flatMap((Function1 & Serializable & scala.Serializable)stageId -> Option$.MODULE$.option2Iterable(sparkStatusTracker.getStageInfo(BoxesRunTime.unboxToInt((Object)stageId))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SparkStageInfo.class))));
    }

    public static final /* synthetic */ boolean $anonfun$getActiveJobProgressInfo$2(SparkJobInfo x$3) {
        JobExecutionStatus jobExecutionStatus = x$3.status();
        JobExecutionStatus jobExecutionStatus2 = JobExecutionStatus.RUNNING;
        return !(jobExecutionStatus != null ? !jobExecutionStatus.equals(jobExecutionStatus2) : jobExecutionStatus2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getCompletedJobProgressInfo$2(SparkJobInfo x$4) {
        JobExecutionStatus jobExecutionStatus = x$4.status();
        JobExecutionStatus jobExecutionStatus2 = JobExecutionStatus.SUCCEEDED;
        return !(jobExecutionStatus != null ? !jobExecutionStatus.equals(jobExecutionStatus2) : jobExecutionStatus2 != null);
    }

    public static final /* synthetic */ void $anonfun$getJobProgressInfoByStages$2(IntRef numTasks$1, IntRef numActiveTasks$1, IntRef numFailedTasks$1, IntRef numSucceedTasks$1, SparkStageInfo stageInfo) {
        if (stageInfo.submissionTime() > 0L) {
            numTasks$1.elem += stageInfo.numTasks();
            numActiveTasks$1.elem += stageInfo.numActiveTasks();
            numFailedTasks$1.elem += stageInfo.numFailedTasks();
            numSucceedTasks$1.elem += stageInfo.numCompletedTasks();
            return;
        }
    }

    private JobProgressUtil$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

