/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.variable.restful.api;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.apache.linkis.variable.entity.VarKeyValueVO;
import org.apache.linkis.variable.exception.VariableException;
import org.apache.linkis.variable.service.VariableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"global variable"})
@RestController
@RequestMapping(path={"/variable"})
public class VariableRestfulApi {
    @Autowired
    private VariableService variableService;
    ObjectMapper mapper = new ObjectMapper();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @ApiOperation(value="listGlobalVariable", notes="list global variable", response=Message.class)
    @RequestMapping(path={"listGlobalVariable"}, method={RequestMethod.GET})
    public Message listGlobalVariable(HttpServletRequest req) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"listGlobalVariable ");
        List<VarKeyValueVO> kvs = this.variableService.listGlobalVariable(userName);
        return Message.ok().data("globalVariables", kvs);
    }

    @ApiOperation(value="saveGlobalVariable", notes="save global variable", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="globalVariables", required=true, dataType="Map"), @ApiImplicitParam(name="key", required=true, dataType="String"), @ApiImplicitParam(name="value", required=true, dataType="List"), @ApiImplicitParam(name="keyID", required=true, dataType="String", example="2"), @ApiImplicitParam(name="valueID", required=true, dataType="List", example="2")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"saveGlobalVariable"}, method={RequestMethod.POST})
    public Message saveGlobalVariable(HttpServletRequest req, @RequestBody JsonNode json) throws IOException, VariableException {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"saveGlobalVariable ");
        List<VarKeyValueVO> userVariables = this.variableService.listGlobalVariable(userName);
        List globalVariables = (List)this.mapper.treeToValue((TreeNode)json.get("globalVariables"), List.class);
        this.variableService.saveGlobalVaraibles(globalVariables, userVariables, userName);
        return Message.ok();
    }
}

