/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support.tagsprovider;

import io.micrometer.core.instrument.Tags;
import org.springframework.cloud.gateway.support.tagsprovider.GatewayTagsProvider;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;

public class GatewayHttpTagsProvider
implements GatewayTagsProvider {
    @Override
    public Tags apply(ServerWebExchange exchange) {
        String outcome = "CUSTOM";
        String status = "CUSTOM";
        String httpStatusCodeStr = "NA";
        String httpMethod = exchange.getRequest().getMethodValue();
        if (exchange.getResponse() instanceof AbstractServerHttpResponse) {
            Integer statusInt = ((AbstractServerHttpResponse)exchange.getResponse()).getRawStatusCode();
            if (statusInt != null) {
                httpStatusCodeStr = status = String.valueOf(statusInt);
                HttpStatus resolved = HttpStatus.resolve((int)statusInt);
                if (resolved != null) {
                    outcome = resolved.series().name();
                    status = resolved.name();
                }
            }
        } else {
            HttpStatus statusCode = exchange.getResponse().getStatusCode();
            if (statusCode != null) {
                httpStatusCodeStr = String.valueOf(statusCode.value());
                outcome = statusCode.series().name();
                status = statusCode.name();
            }
        }
        return Tags.of((String[])new String[]{"outcome", outcome, "status", status, "httpStatusCode", httpStatusCodeStr, "httpMethod", httpMethod});
    }
}

