/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.adapter.druid.DruidExpressions;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidSqlOperatorConverter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;

public class NaryOperatorConverter
implements DruidSqlOperatorConverter {
    private final SqlOperator operator;
    private final String druidOperatorName;

    public NaryOperatorConverter(SqlOperator operator, String druidOperatorName) {
        this.operator = (SqlOperator)Preconditions.checkNotNull((Object)operator);
        this.druidOperatorName = (String)Preconditions.checkNotNull((Object)druidOperatorName);
    }

    @Override
    public SqlOperator calciteOperator() {
        return this.operator;
    }

    @Override
    @Nullable
    public String toDruidExpression(RexNode rexNode, RelDataType rowType, DruidQuery druidQuery) {
        RexCall call = (RexCall)rexNode;
        List<String> druidExpressions = DruidExpressions.toDruidExpressions(druidQuery, rowType, call.getOperands());
        if (druidExpressions == null) {
            return null;
        }
        return DruidExpressions.nAryOperatorCall(this.druidOperatorName, druidExpressions);
    }
}

