/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.restful.api;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.linkis.metadata.ddl.ImportDDLCreator;
import org.apache.linkis.metadata.ddl.ScalaDDLCreator;
import org.apache.linkis.metadata.domain.mdq.bo.MdqTableBO;
import org.apache.linkis.metadata.domain.mdq.bo.MdqTableImportInfoBO;
import org.apache.linkis.metadata.domain.mdq.vo.MdqTableBaseInfoVO;
import org.apache.linkis.metadata.domain.mdq.vo.MdqTableFieldsInfoVO;
import org.apache.linkis.metadata.domain.mdq.vo.MdqTablePartitionStatisticInfoVO;
import org.apache.linkis.metadata.domain.mdq.vo.MdqTableStatisticInfoVO;
import org.apache.linkis.metadata.exception.MdqIllegalParamException;
import org.apache.linkis.metadata.hive.dto.MetadataQueryParam;
import org.apache.linkis.metadata.service.MdqService;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"mdq table api"})
@RestController
@RequestMapping(path={"/datasource"})
public class MdqTableRestfulApi {
    private static final Logger logger = LoggerFactory.getLogger(MdqTableRestfulApi.class);
    private static final String ASC = "asc";
    @Autowired
    private MdqService mdqService;
    ObjectMapper mapper = new ObjectMapper();

    @ApiOperation(value="getTableBaseInfo", notes="get table base info", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="database", required=false, dataType="String", value="database"), @ApiImplicitParam(name="tableName", dataType="String")})
    @RequestMapping(path={"getTableBaseInfo"}, method={RequestMethod.GET})
    public Message getTableBaseInfo(@RequestParam(value="database", required=false) String database, @RequestParam(value="tableName", required=false) String tableName, HttpServletRequest req) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("getTableBaseInfo " + tableName));
        MetadataQueryParam queryParam = MetadataQueryParam.of(userName).withDbName(database).withTableName(tableName);
        MdqTableBaseInfoVO tableBaseInfo = this.mdqService.isExistInMdq(database, tableName, userName) ? this.mdqService.getTableBaseInfoFromMdq(database, tableName, userName) : this.mdqService.getTableBaseInfoFromHive(queryParam);
        return Message.ok().data("tableBaseInfo", (Object)tableBaseInfo);
    }

    @ApiOperation(value="getTableFieldsInfo", notes="get table fields info", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="database", required=false, dataType="String", value="database"), @ApiImplicitParam(name="tableName", dataType="String")})
    @RequestMapping(path={"getTableFieldsInfo"}, method={RequestMethod.GET})
    public Message getTableFieldsInfo(@RequestParam(value="database", required=false) String database, @RequestParam(value="tableName", required=false) String tableName, HttpServletRequest req) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("getTableFieldsInfo " + tableName));
        MetadataQueryParam queryParam = MetadataQueryParam.of(userName).withDbName(database).withTableName(tableName);
        List<MdqTableFieldsInfoVO> tableFieldsInfo = this.mdqService.isExistInMdq(database, tableName, userName) ? this.mdqService.getTableFieldsInfoFromMdq(database, tableName, userName) : this.mdqService.getTableFieldsInfoFromHive(queryParam);
        return Message.ok().data("tableFieldsInfo", tableFieldsInfo);
    }

    @ApiOperation(value="getTableStatisticInfo", notes="get table statistic info", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="database", required=false, dataType="String", value="database"), @ApiImplicitParam(name="tableName", dataType="String"), @ApiImplicitParam(name="pageNow", required=true, dataType="String", value="page now"), @ApiImplicitParam(name="pageSize", required=true, dataType="String", value="page size"), @ApiImplicitParam(name="partitionSort", required=true, dataType="String")})
    @RequestMapping(path={"getTableStatisticInfo"}, method={RequestMethod.GET})
    public Message getTableStatisticInfo(@RequestParam(value="database", required=false) String database, @RequestParam(value="tableName", required=false) String tableName, @RequestParam(value="pageNow", defaultValue="1") int pageNow, @RequestParam(value="pageSize", defaultValue="1000") int pageSize, @RequestParam(value="partitionSort", defaultValue="desc") String partitionSort, HttpServletRequest req) throws IOException {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("getTableStatisticInfo " + tableName));
        MetadataQueryParam queryParam = MetadataQueryParam.of(userName).withDbName(database).withTableName(tableName);
        MdqTableStatisticInfoVO tableStatisticInfo = this.mdqService.getTableStatisticInfo(queryParam, partitionSort);
        int totalSize = 0;
        List<MdqTablePartitionStatisticInfoVO> partitions = tableStatisticInfo.getPartitions();
        if (partitions != null && !partitions.isEmpty()) {
            partitions = ASC.equals(partitionSort) ? partitions.stream().sorted(Comparator.comparing(MdqTablePartitionStatisticInfoVO::getName)).collect(Collectors.toList()) : partitions.stream().sorted(Comparator.comparing(MdqTablePartitionStatisticInfoVO::getName).reversed()).collect(Collectors.toList());
            if (pageNow <= 0 || pageSize <= 0) {
                pageNow = 1;
                pageSize = 1000;
            }
            totalSize = partitions.size();
            int start = (pageNow - 1) * pageSize;
            int end = pageNow * pageSize;
            List<MdqTablePartitionStatisticInfoVO> partitionPage = start > totalSize ? new ArrayList<MdqTablePartitionStatisticInfoVO>() : (end > totalSize ? partitions.subList(start, totalSize) : partitions.subList(start, end));
            tableStatisticInfo.setPartitions(partitionPage);
        }
        Message data = Message.ok().data("tableStatisticInfo", (Object)tableStatisticInfo).data("totalSize", (Object)totalSize).data("pageNow", (Object)pageNow).data("pageSize", (Object)pageSize);
        return data;
    }

    @ApiOperation(value="getPartitionStatisticInfo", notes="get partition statistic info", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="database", required=false, dataType="String", value="database"), @ApiImplicitParam(name="tableName", dataType="String"), @ApiImplicitParam(name="partitionSort", dataType="String")})
    @RequestMapping(path={"getPartitionStatisticInfo"}, method={RequestMethod.GET})
    public Message getPartitionStatisticInfo(@RequestParam(value="database", required=false) String database, @RequestParam(value="tableName", required=false) String tableName, @RequestParam(value="partitionPath", required=false) String partitionName, HttpServletRequest req) throws IOException, MdqIllegalParamException {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("getPartitionStatisticInfo " + tableName));
        MetadataQueryParam queryParam = MetadataQueryParam.of(userName).withDbName(database).withTableName(tableName);
        MdqTablePartitionStatisticInfoVO partition = this.mdqService.getPartitionStatisticInfo(queryParam, partitionName);
        return Message.ok().data("partitionStatisticInfo", (Object)partition);
    }

    @ApiOperation(value="active", notes="active", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="tableId", dataType="String", value="table id")})
    @RequestMapping(path={"active"}, method={RequestMethod.GET})
    public Message active(@RequestParam(value="tableId", required=false) Long tableId, HttpServletRequest req) {
        this.mdqService.activateTable(tableId);
        return Message.ok();
    }

    @ApiOperation(value="persistTable", notes="persist table", response=Message.class)
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"persistTable"}, method={RequestMethod.POST})
    public Message persistTable(HttpServletRequest req, @RequestBody JsonNode json) throws IOException {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"persistTable ");
        MdqTableBO table = (MdqTableBO)this.mapper.treeToValue((TreeNode)json.get("table"), MdqTableBO.class);
        this.mdqService.persistTable(table, userName);
        return Message.ok();
    }

    @ApiOperation(value="displaySql", notes="display sql", response=Message.class)
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"displaysql"}, method={RequestMethod.POST})
    public Message displaySql(HttpServletRequest request, @RequestBody JsonNode json) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)"displaysql ");
        logger.info("display sql for user {} ", (Object)userName);
        StringBuilder sb = new StringBuilder();
        String retSql = "";
        MdqTableBO tableBO = null;
        try {
            tableBO = (MdqTableBO)this.mapper.treeToValue((TreeNode)json.get("table"), MdqTableBO.class);
            MdqTableImportInfoBO importInfo = tableBO.getImportInfo();
            retSql = importInfo != null ? ImportDDLCreator.createDDL(tableBO, userName) : ScalaDDLCreator.createDDL(tableBO, userName);
        }
        catch (Exception e) {
            logger.error("json parse to bean failed", (Throwable)e);
            Message message = Message.error((String)"display ddl failed");
            return message;
        }
        String tableName = tableBO.getTableBaseInfo().getBase().getName();
        String dbName = tableBO.getTableBaseInfo().getBase().getDatabase();
        String retStr = "\u610f\u4e66\u540e\u53f0\u6b63\u5728\u4e3a\u60a8\u751f\u6210\u65b0\u5efa\u5e93\u8868: " + dbName + "." + tableName + "\u7684DDL\u8bed\u53e5,\u8bf7\u70b9\u51fb\u5efa\u8868\u6309\u94ae\u8fdb\u884c\u6267\u884c";
        Message message = Message.ok((String)retStr);
        message.setMethod("/api/datasource/display");
        message.data("sql", (Object)retSql);
        return message;
    }
}

