/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eventbus.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.eventbus.impl.DefaultConsumerQueueSupplier;
import com.netflix.eventbus.impl.EventBusStats;
import com.netflix.eventbus.impl.EventConsumer;
import com.netflix.eventbus.impl.SubscriberValidator;
import com.netflix.eventbus.spi.CatchAllSubscriber;
import com.netflix.eventbus.spi.EventBus;
import com.netflix.eventbus.spi.EventCreator;
import com.netflix.eventbus.spi.EventFilter;
import com.netflix.eventbus.spi.InvalidSubscriberException;
import com.netflix.eventbus.spi.Subscribe;
import com.netflix.eventbus.spi.SubscriberConfigProvider;
import com.netflix.eventbus.spi.SubscriberInfo;
import com.netflix.eventbus.utils.EventBusUtils;
import com.netflix.servo.monitor.Stopwatch;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBusImpl
implements EventBus {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventBusImpl.class);
    static final DynamicIntProperty STATS_COLLECTION_DURATION_MILLIS = DynamicPropertyFactory.getInstance().getIntProperty("eventbus.stats.collection.duration.millis", 60000);
    private final SetMultimap<Class<?>, EventConsumer> consumersByEventType = Multimaps.newSetMultimap(new ConcurrentHashMap(), (Supplier)new Supplier<Set<EventConsumer>>(){

        public Set<EventConsumer> get() {
            return new CopyOnWriteArraySet<EventConsumer>();
        }
    });
    private final ConcurrentHashMap<Class<?>, CopyOnWriteArrayList<EventConsumer>> consumersBySubscriberClass = new ConcurrentHashMap();
    private final SetMultimap<Class<?>, EventFilter> eventTypeVsFilters = Multimaps.newSetMultimap(new ConcurrentHashMap(), (Supplier)new Supplier<Set<EventFilter>>(){

        public Set<EventFilter> get() {
            return new CopyOnWriteArraySet<EventFilter>();
        }
    });
    private static LoadingCache<Class<?>, Set<Class<?>>> eventHierarchyCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, Set<Class<?>>>(){

        public Set<Class<?>> load(Class<?> concreteClass) throws Exception {
            LinkedList parents = Lists.newLinkedList();
            HashSet classes = Sets.newHashSet();
            parents.add(concreteClass);
            while (!parents.isEmpty()) {
                Class clazz = (Class)parents.remove(0);
                classes.add(clazz);
                Class parent = clazz.getSuperclass();
                if (parent != null && !parent.equals(Object.class)) {
                    parents.add(parent);
                }
                Collections.addAll(parents, clazz.getInterfaces());
            }
            return classes;
        }
    });
    private ConsumerQueueSupplier consumerQueueSupplier = new DefaultConsumerQueueSupplier();
    private EventBusStats stats = new EventBusStats(STATS_COLLECTION_DURATION_MILLIS.get());
    private EventConsumer catchAllSubscriber;
    private volatile CatchAllSubscriber catchAllSubInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(Object event) {
        Stopwatch start = this.stats.publishStats.start();
        try {
            if (!this.applyEventLevelFilters(event)) {
                return;
            }
            Set<Class<?>> allTypesForAnEvent = EventBusImpl.getAllTypesForAnEvent(event);
            for (Class<?> eventType : allTypesForAnEvent) {
                Set eventConsumers = this.consumersByEventType.get(eventType);
                for (EventConsumer eventConsumer : eventConsumers) {
                    eventConsumer.enqueue(event);
                }
            }
            if (null != this.catchAllSubInstance && this.catchAllSubInstance.isEnabled()) {
                this.catchAllSubscriber.enqueue(event);
            }
        }
        catch (Throwable th) {
            LOGGER.error("Error occured while publishing event. Swallowing the error to avoid publisher from failing.", th);
            this.stats.publishErrors.increment();
        }
        finally {
            start.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publishIffNotDead(EventCreator creator, Class<?> ... eventTypes) {
        Stopwatch start = this.stats.conditionalPublishStats.start();
        try {
            HashMap interestedConsumersByType = new HashMap();
            for (Class<?> eventType : eventTypes) {
                for (Class<?> anEventSubType : EventBusImpl.getAllTypesForAnEventType(eventType)) {
                    Set eventConsumers = this.consumersByEventType.get(anEventSubType);
                    if (eventConsumers.isEmpty()) continue;
                    interestedConsumersByType.put(eventType, eventConsumers);
                }
            }
            if (interestedConsumersByType.isEmpty()) {
                LOGGER.debug(String.format("Skipping publishing of events types %s as there are no interested listeners.", Arrays.toString(eventTypes)));
                return;
            }
            List<?> events = creator.createEvent(interestedConsumersByType.keySet());
            if (null == events) {
                LOGGER.debug(String.format("No events created by event creator for event types %s", interestedConsumersByType.keySet()));
                return;
            }
            for (Object event : events) {
                if (!this.applyEventLevelFilters(event)) continue;
                Set eventConsumers = (Set)interestedConsumersByType.get(event.getClass());
                for (EventConsumer eventConsumer : eventConsumers) {
                    eventConsumer.enqueue(event);
                }
            }
        }
        catch (Throwable th) {
            LOGGER.error("Error occured while publishing event. Swallowing the error to avoid publisher from failing.", th);
            this.stats.conditionalPublishErrors.increment();
        }
        finally {
            start.stop();
        }
    }

    @Override
    public void registerSubscriber(@Nullable EventFilter filter, Object subscriber) throws InvalidSubscriberException {
        ArrayList<EventConsumer> allConsumersForThisSubscriber = new ArrayList<EventConsumer>();
        List<Method> subscriberMethods = this.findSubscriberMethods(subscriber);
        for (Method subscriberMethod : subscriberMethods) {
            Class<?> targetEventType = EventBusUtils.getInterestedEventType(subscriber, subscriberMethod);
            EventConsumer consumer = new EventConsumer(subscriberMethod, subscriber, filter, targetEventType, this.consumerQueueSupplier);
            allConsumersForThisSubscriber.add(consumer);
            this.consumersByEventType.put(targetEventType, (Object)consumer);
        }
        CopyOnWriteArrayList existingConsumers = this.consumersBySubscriberClass.putIfAbsent(subscriber.getClass(), new CopyOnWriteArrayList(allConsumersForThisSubscriber));
        if (null != existingConsumers) {
            existingConsumers.addAll(allConsumersForThisSubscriber);
        } else {
            LOGGER.info(String.format("Registered a new subscriber: %s with filter: %s", subscriber, filter));
        }
    }

    @Override
    public void registerSubscriber(Object subscriber) throws InvalidSubscriberException {
        this.registerSubscriber(null, subscriber);
    }

    public synchronized boolean enableCatchAllSubscriber(BlockingQueue catchAllSink) {
        if (null == this.catchAllSubscriber) {
            this.catchAllSubInstance = new CatchAllSubscriber();
            try {
                List<Method> subscriberMethods = this.findSubscriberMethods(this.catchAllSubInstance);
                if (!subscriberMethods.isEmpty()) {
                    Method method = subscriberMethods.get(0);
                    this.catchAllSubscriber = new EventConsumer(method, this.catchAllSubInstance, null, Object.class, this.consumerQueueSupplier);
                }
            }
            catch (InvalidSubscriberException e) {
                LOGGER.error("Catch all subscriber invalid!", (Throwable)e);
                return false;
            }
        }
        return this.catchAllSubInstance.enable(catchAllSink);
    }

    @Override
    public synchronized void disableCatchAllSubscriber() {
        if (null != this.catchAllSubInstance) {
            this.catchAllSubInstance.disable();
        } else {
            LOGGER.info("Catch all subscriber is not enabled, disable call ignored.");
        }
    }

    @Override
    public Set<Object> unregisterSubscriber(Class<?> subscriberClass) {
        LOGGER.info("Unregistring subscriber class: " + subscriberClass);
        HashSet<Object> toReturn = new HashSet<Object>();
        CopyOnWriteArrayList<EventConsumer> eventConsumers = this.consumersBySubscriberClass.remove(subscriberClass);
        if (null != eventConsumers) {
            for (EventConsumer eventConsumer : eventConsumers) {
                eventConsumer.shutdown();
                Class<?> targetEventClass = eventConsumer.getTargetEventClass();
                this.consumersByEventType.remove(targetEventClass, (Object)eventConsumer);
                toReturn.add(eventConsumer.getContainerInstance());
            }
            LOGGER.info(String.format("Subscriber: %s successfully unregistered", subscriberClass));
        } else {
            LOGGER.info(String.format("Subscriber: %s is not registered (or already removed). Ignoring unregister.", subscriberClass));
        }
        return toReturn;
    }

    @Override
    public boolean unregisterSubscriber(Object subscriber) {
        LOGGER.info("Unregistring subscriber instance: " + subscriber);
        Class<?> subscriberClass = subscriber.getClass();
        CopyOnWriteArrayList<EventConsumer> eventConsumers = this.consumersBySubscriberClass.get(subscriberClass);
        boolean unregistered = false;
        EventConsumer toRemove = null;
        if (null != eventConsumers) {
            for (EventConsumer eventConsumer : eventConsumers) {
                if (eventConsumer.getContainerInstance() != subscriber) continue;
                toRemove = eventConsumer;
            }
            if (null != toRemove && eventConsumers.remove(toRemove)) {
                toRemove.shutdown();
                Class<?> targetEventClass = toRemove.getTargetEventClass();
                this.consumersByEventType.remove(targetEventClass, (Object)toRemove);
                unregistered = true;
            }
        }
        if (unregistered) {
            LOGGER.info(String.format("Subscriber instance: %s successfully unregistered", subscriber));
        } else {
            LOGGER.info(String.format("Subscriber instance: %s is not registered (or already removed). Ignoring unregister.", subscriber));
        }
        return unregistered;
    }

    @Override
    public void addFilterForSubscriber(EventFilter filter, SubscriberInfo subscriberInfo) {
        String callDescription = "add filter";
        EventConsumer consumerInAction = this.findEventConsumerForSubscriberMethod(subscriberInfo, callDescription);
        if (null != consumerInAction) {
            consumerInAction.addFilters(filter);
            LOGGER.info(String.format("Added a new filter %s for subscriber method %s", filter, subscriberInfo.getSubscriberMethod().toGenericString()));
        }
    }

    @Override
    public void removeFiltersForSubscriber(SubscriberInfo subscriberInfo, EventFilter ... filters) {
        String callDescription = "remove filter";
        EventConsumer consumerInAction = this.findEventConsumerForSubscriberMethod(subscriberInfo, callDescription);
        if (null != consumerInAction) {
            consumerInAction.removeFilters(filters);
            LOGGER.info(String.format("Removed filters %s for subscriber method %s", Arrays.toString(filters), subscriberInfo.getSubscriberMethod().toGenericString()));
        }
    }

    @Override
    public void clearFiltersForSubscriber(SubscriberInfo subscriberInfo) {
        String callDescription = "add filter";
        EventConsumer consumerInAction = this.findEventConsumerForSubscriberMethod(subscriberInfo, callDescription);
        if (null != consumerInAction) {
            consumerInAction.clearFilters();
            LOGGER.info(String.format("Removed ALL filters for subscriber method %s", subscriberInfo.getSubscriberMethod().toGenericString()));
        }
    }

    @Override
    public void addFilterForEvent(EventFilter filter, Class<?> eventClass) {
        boolean modified = this.eventTypeVsFilters.put(eventClass, (Object)filter);
        if (modified) {
            LOGGER.info(String.format("Added a new filter %s for the event type: %s", filter, eventClass));
        } else {
            LOGGER.info(String.format("Filter %s already exists for the event type: %s", filter, eventClass));
        }
    }

    @Override
    public void removeFiltersForEvent(Class<?> eventClass, EventFilter ... filters) {
        if (null == filters || filters.length == 0) {
            return;
        }
        Set eventFilters = this.eventTypeVsFilters.get(eventClass);
        boolean modified = eventFilters.removeAll(Arrays.asList(filters));
        if (modified) {
            LOGGER.info(String.format("Removed filters %s for event type %s", Arrays.toString(filters), eventClass));
        } else {
            LOGGER.info(String.format("None of the filters %s exists for event type %s. Ignoring remove.", Arrays.toString(filters), eventClass));
        }
    }

    @Override
    public void clearFiltersForEvent(Class<?> eventClass) {
        this.eventTypeVsFilters.removeAll(eventClass);
        LOGGER.info(String.format("Removed ALL filters for event type %s", eventClass));
    }

    @Override
    public Set<SubscriberInfo> getAllSubscribers() {
        HashSet<SubscriberInfo> toReturn = new HashSet<SubscriberInfo>();
        for (CopyOnWriteArrayList<EventConsumer> eventConsumers : this.consumersBySubscriberClass.values()) {
            for (EventConsumer eventConsumer : eventConsumers) {
                toReturn.add(new SubscriberInfo(eventConsumer.getDelegateSubscriber(), eventConsumer.getContainerInstance()));
            }
        }
        return Collections.unmodifiableSet(toReturn);
    }

    @Override
    public Set<SubscriberInfo> getAllSubscribersForAnEvent(Class<?> eventType) {
        Set eventConsumers = this.consumersByEventType.get(eventType);
        if (null == eventConsumers || eventConsumers.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<SubscriberInfo> toReturn = new HashSet<SubscriberInfo>(eventConsumers.size());
        for (EventConsumer eventConsumer : eventConsumers) {
            toReturn.add(new SubscriberInfo(eventConsumer.getDelegateSubscriber(), eventConsumer.getContainerInstance()));
        }
        return Collections.unmodifiableSet(toReturn);
    }

    @Override
    public Set<EventFilter> getFilterForASubscriber(SubscriberInfo subscriberInfo) {
        String callDescription = "get filter";
        EventConsumer consumerInAction = this.findEventConsumerForSubscriberMethod(subscriberInfo, callDescription);
        if (null == consumerInAction) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(consumerInAction.getAttachedFilters());
    }

    @Override
    public Set<EventFilter> getFiltersForAnEvent(Class<?> eventType) {
        Set eventFilters = this.eventTypeVsFilters.get(eventType);
        return Collections.unmodifiableSet(eventFilters);
    }

    @Override
    public Set<Class<?>> getAllRegisteredEventTypes() {
        Set eventTypesWithConsumers = this.consumersByEventType.keySet();
        Set eventTypesWithFilters = this.eventTypeVsFilters.keySet();
        return Sets.union((Set)eventTypesWithConsumers, (Set)eventTypesWithFilters);
    }

    public synchronized void shutdown() {
        Collection consumers = this.consumersByEventType.values();
        for (EventConsumer consumer : consumers) {
            consumer.shutdown();
        }
        this.consumersByEventType.clear();
        this.consumersBySubscriberClass.clear();
        this.eventTypeVsFilters.clear();
    }

    @VisibleForTesting
    void setConsumerQueueSupplier(ConsumerQueueSupplier consumerQueueSupplier) {
        this.consumerQueueSupplier = consumerQueueSupplier;
    }

    @VisibleForTesting
    Set<EventConsumer> getEventConsumer(Class eventClass) {
        return this.consumersByEventType.get((Object)eventClass);
    }

    private boolean applyEventLevelFilters(Object event) {
        return EventBusUtils.applyFilters(event, this.eventTypeVsFilters.get(event.getClass()), this.stats.filterStats, " publisher ", LOGGER);
    }

    private List<Method> findSubscriberMethods(Object subscriber) throws InvalidSubscriberException {
        ArrayList<Method> subscriberMethods = new ArrayList<Method>();
        HashSet<Method> allMethods = new HashSet<Method>();
        Method[] methods = subscriber.getClass().getMethods();
        allMethods.addAll(Arrays.asList(methods));
        Method[] allDeclaredMethods = subscriber.getClass().getDeclaredMethods();
        allMethods.addAll(Arrays.asList(allDeclaredMethods));
        for (Method method : allMethods) {
            if (!method.isAnnotationPresent(Subscribe.class)) continue;
            try {
                method.setAccessible(true);
                subscriberMethods.add(method);
            }
            catch (SecurityException e) {
                LOGGER.error("A subscriber method: " + method.toGenericString() + " is not a public method and the security settings does not allow accessing non-public" + " methods via reflection. This subscriber method will not be registered.", (Throwable)e);
            }
        }
        Map<Method, String> errors = SubscriberValidator.validate(subscriber, subscriberMethods);
        if (!errors.isEmpty()) {
            throw new InvalidSubscriberException(subscriber.getClass(), errors);
        }
        return subscriberMethods;
    }

    private EventConsumer findEventConsumerForSubscriberMethod(SubscriberInfo subscriberInfo, String callDescription) {
        Method subscriberMethod = subscriberInfo.getSubscriberMethod();
        Subscribe subscribeAnnotation = subscriberMethod.getAnnotation(Subscribe.class);
        if (null == subscribeAnnotation) {
            LOGGER.error(String.format("The subscriber method: %s is not annotated with @Subscribe. Ignoring %s call.", subscriberMethod, callDescription));
            return null;
        }
        CopyOnWriteArrayList<EventConsumer> eventConsumers = this.consumersBySubscriberClass.get(subscriberMethod.getDeclaringClass());
        if (null != eventConsumers) {
            for (EventConsumer eventConsumer : eventConsumers) {
                if (!this.isTheSameSubscriber(subscriberInfo, eventConsumer)) continue;
                return eventConsumer;
            }
        }
        LOGGER.info(String.format("Subscriber: %s is not registered (or already removed). Ignoring %s call.", subscriberMethod, callDescription));
        return null;
    }

    private static Set<Class<?>> getAllTypesForAnEvent(Object event) {
        try {
            return (Set)eventHierarchyCache.get(event.getClass());
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    private static Set<Class<?>> getAllTypesForAnEventType(Class eventType) {
        try {
            return (Set)eventHierarchyCache.get((Object)eventType);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    private boolean isTheSameSubscriber(SubscriberInfo subscriberInfo, EventConsumer eventConsumer) {
        return eventConsumer.getDelegateSubscriber().equals(subscriberInfo.getSubscriberMethod()) && eventConsumer.getContainerInstance() == subscriberInfo.getSubscriberInstance();
    }

    @VisibleForTesting
    static interface ConsumerQueueSupplier {
        public ConsumerQueue get(Method var1, SubscriberConfigProvider.SubscriberConfig var2, AtomicLong var3);

        public static interface ConsumerQueue {
            public boolean offer(Object var1);

            public Object nonBlockingTake();

            public Object blockingTake() throws InterruptedException;

            public void clear();
        }
    }
}

