/*
 * Decompiled with CFR 0.152.
 */
package com.stoyanr.evictor.scheduler;

import com.stoyanr.evictor.EvictionQueue;
import com.stoyanr.evictor.map.EvictibleEntry;
import com.stoyanr.evictor.scheduler.AbstractQueueEvictionScheduler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RegularTaskEvictionScheduler<K, V>
extends AbstractQueueEvictionScheduler<K, V> {
    public static final int DEFAULT_THREAD_POOL_SIZE = 1;
    public static final long DEFAULT_DELAY = 1L;
    public static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLISECONDS;
    private final ScheduledExecutorService executorService;
    private final long delay;
    private final TimeUnit timeUnit;
    private volatile ScheduledFuture<?> future = null;
    private volatile boolean active = false;

    public RegularTaskEvictionScheduler() {
        this(new ScheduledThreadPoolExecutor(1), 1L, DEFAULT_TIME_UNIT);
    }

    public RegularTaskEvictionScheduler(long delay, TimeUnit timeUnit) {
        this(new ScheduledThreadPoolExecutor(1), delay, timeUnit);
    }

    public RegularTaskEvictionScheduler(ScheduledExecutorService executorService, long delay, TimeUnit timeUnit) {
        if (executorService == null) {
            throw new NullPointerException("ScheduledExecutorService instance cannot be null");
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException("Delay cannot be less than or equal to zero");
        }
        this.executorService = executorService;
        this.delay = delay;
        this.timeUnit = timeUnit;
    }

    public RegularTaskEvictionScheduler(EvictionQueue<K, V> queue) {
        this(queue, new ScheduledThreadPoolExecutor(1), 1L, DEFAULT_TIME_UNIT);
    }

    public RegularTaskEvictionScheduler(EvictionQueue<K, V> queue, ScheduledExecutorService ses, long delay, TimeUnit timeUnit) {
        super(queue);
        if (ses == null) {
            throw new NullPointerException("ScheduledExecutorService instance cannot be null");
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException("Delay cannot be less than or equal to zero");
        }
        this.executorService = ses;
        this.delay = delay;
        this.timeUnit = timeUnit;
    }

    @Override
    public void shutdown() {
        this.executorService.shutdownNow();
    }

    @Override
    protected void onScheduleEviction(EvictibleEntry<K, V> e) {
        if (this.hasScheduledEvictions() && !this.active) {
            this.schedule();
        }
    }

    @Override
    protected void onCancelEviction(EvictibleEntry<K, V> e) {
        if (!this.hasScheduledEvictions() && this.active) {
            this.cancel();
        }
    }

    @Override
    protected void onEvictEntries() {
        if (!this.hasScheduledEvictions() && this.active) {
            this.cancel();
        }
    }

    private synchronized void schedule() {
        this.active = this.hasScheduledEvictions();
        if (this.future == null && this.active) {
            this.future = this.executorService.scheduleWithFixedDelay(new AbstractQueueEvictionScheduler.EvictionRunnable(), this.delay, this.delay, this.timeUnit);
        }
    }

    private synchronized void cancel() {
        this.active = this.hasScheduledEvictions();
        if (this.future != null && !this.active) {
            this.future.cancel(false);
            this.future = null;
        }
    }
}

