/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.service.impl;

import com.google.gson.Gson;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.hadoop.common.conf.HadoopConf;
import org.apache.linkis.hadoop.common.utils.HDFSUtils;
import org.apache.linkis.metadata.dao.MdqDao;
import org.apache.linkis.metadata.domain.mdq.DomainCoversionUtils;
import org.apache.linkis.metadata.domain.mdq.Tunple;
import org.apache.linkis.metadata.domain.mdq.bo.MdqTableBO;
import org.apache.linkis.metadata.domain.mdq.bo.MdqTableBaseInfoBO;
import org.apache.linkis.metadata.domain.mdq.bo.MdqTableFieldsInfoBO;
import org.apache.linkis.metadata.domain.mdq.bo.MdqTableImportInfoBO;
import org.apache.linkis.metadata.domain.mdq.po.MdqField;
import org.apache.linkis.metadata.domain.mdq.po.MdqImport;
import org.apache.linkis.metadata.domain.mdq.po.MdqLineage;
import org.apache.linkis.metadata.domain.mdq.po.MdqTable;
import org.apache.linkis.metadata.domain.mdq.vo.MdqTableBaseInfoVO;
import org.apache.linkis.metadata.domain.mdq.vo.MdqTableFieldsInfoVO;
import org.apache.linkis.metadata.domain.mdq.vo.MdqTablePartitionStatisticInfoVO;
import org.apache.linkis.metadata.domain.mdq.vo.MdqTableStatisticInfoVO;
import org.apache.linkis.metadata.hive.config.DataSource;
import org.apache.linkis.metadata.hive.dao.HiveMetaDao;
import org.apache.linkis.metadata.hive.dto.MetadataQueryParam;
import org.apache.linkis.metadata.service.HiveMetaWithPermissionService;
import org.apache.linkis.metadata.service.MdqService;
import org.apache.linkis.metadata.type.MdqImportType;
import org.apache.linkis.metadata.util.DWSConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MdqServiceImpl
implements MdqService {
    @Autowired
    private MdqDao mdqDao;
    @Autowired
    private HiveMetaDao hiveMetaDao;
    @Autowired
    HiveMetaWithPermissionService hiveMetaWithPermissionService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static volatile FileSystem rootHdfs = null;

    @Override
    @DataSource(name="secondDataSource")
    @Deprecated
    public void activateTable(Long tableId) {
        this.mdqDao.activateTable(tableId);
    }

    @Override
    @DataSource(name="secondDataSource")
    @Transactional
    public Long persistTable(MdqTableBO mdqTableBO, String userName) {
        List collect;
        this.checkIfNeedDeleteTable(mdqTableBO);
        MdqTableBaseInfoBO tableBaseInfo = mdqTableBO.getTableBaseInfo();
        MdqTable table = DomainCoversionUtils.mdqTableBaseInfoBOToMdqTable(tableBaseInfo);
        table.setImport(mdqTableBO.getImportInfo() != null);
        table.setCreator(userName);
        this.mdqDao.insertTable(table);
        List<MdqTableFieldsInfoBO> tableFieldsInfo = mdqTableBO.getTableFieldsInfo();
        List<MdqField> mdqFieldList = DomainCoversionUtils.mdqTableFieldsInfoBOListToMdqFieldList(tableFieldsInfo, table.getId());
        if (table.getPartitionTable().booleanValue() && table.getImport().booleanValue() && (collect = mdqFieldList.stream().filter(f -> "ds".equals(f.getName())).collect(Collectors.toList())).size() > 1) {
            mdqFieldList.remove(collect.get(1));
        }
        this.mdqDao.insertFields(mdqFieldList);
        if (mdqTableBO.getImportInfo() != null) {
            MdqTableImportInfoBO importInfo = mdqTableBO.getImportInfo();
            MdqImport mdqImport = DomainCoversionUtils.mdqTableImportInfoBOToMdqImport(importInfo);
            mdqImport.setTableId(table.getId());
            this.mdqDao.insertImport(mdqImport);
            if (importInfo.getImportType().equals(MdqImportType.Hive.ordinal())) {
                MdqLineage mdqLineage = DomainCoversionUtils.generateMdaLineage(importInfo);
                mdqLineage.setTableId(table.getId());
                this.mdqDao.insertLineage(mdqLineage);
            }
        }
        return table.getId();
    }

    @DataSource(name="secondDataSource")
    public void checkIfNeedDeleteTable(MdqTableBO mdqTableBO) {
        String database = mdqTableBO.getTableBaseInfo().getBase().getDatabase();
        String tableName = mdqTableBO.getTableBaseInfo().getBase().getName();
        MdqTable oldTable = this.mdqDao.selectTableForUpdate(database, tableName);
        boolean isPartitionsTabble = mdqTableBO.getTableBaseInfo().getBase().getPartitionTable();
        boolean isImport = mdqTableBO.getImportInfo() != null;
        Integer importType = null;
        if (isImport) {
            importType = mdqTableBO.getImportInfo().getImportType();
        }
        this.logger.info("\u5e93\u540d:" + database + "\u8868\u540d:" + tableName + "\u662f\u5426\u662f\u5206\u533a:" + isPartitionsTabble + "\u662f\u5426\u662f\u5bfc\u5165\u521b\u5efa:" + isImport + "\u5bfc\u5165\u7c7b\u578b:" + importType);
        if (oldTable != null) {
            String destination;
            HashMap hashMap;
            if (isImport && (importType.intValue() == MdqImportType.Csv.ordinal() || importType.intValue() == MdqImportType.Excel.ordinal()) && Boolean.valueOf((hashMap = (HashMap)new Gson().fromJson(destination = mdqTableBO.getImportInfo().getArgs().get("destination"), HashMap.class)).get("importData").toString()).booleanValue()) {
                this.logger.info("Simply add a partition column without dropping the original table(\u53ea\u662f\u5355\u7eaf\u589e\u52a0\u5206\u533a\u5217\uff0c\u4e0d\u5220\u9664\u6389\u539f\u6765\u7684\u8868)");
                return;
            }
            this.logger.info("This will overwrite the tables originally created through the wizard(\u5c06\u8986\u76d6\u6389\u539f\u6765\u901a\u8fc7\u5411\u5bfc\u5efa\u7acb\u7684\u8868):" + oldTable);
            this.mdqDao.deleteTableBaseInfo(oldTable.getId());
        }
    }

    @Override
    @DataSource(name="firstDataSource")
    public MdqTableStatisticInfoVO getTableStatisticInfo(MetadataQueryParam queryParam, String partitionSort) throws IOException {
        MdqTableStatisticInfoVO mdqTableStatisticInfoVO = this.getTableStatisticInfoFromHive(queryParam, partitionSort);
        return mdqTableStatisticInfoVO;
    }

    @Override
    public String displaysql(MdqTableBO mdqTableBO) {
        String dbName = mdqTableBO.getTableBaseInfo().getBase().getDatabase();
        String tableName = mdqTableBO.getTableBaseInfo().getBase().getName();
        String displayStr = "//The backend of Linkis is creating a new database table for you";
        return displayStr;
    }

    @Override
    @DataSource(name="secondDataSource")
    public boolean isExistInMdq(String database, String tableName, String user) {
        MdqTable table = this.mdqDao.selectTableByName(database, tableName, user);
        return table != null;
    }

    @Override
    @DataSource(name="secondDataSource")
    public MdqTableBaseInfoVO getTableBaseInfoFromMdq(String database, String tableName, String user) {
        MdqTable table = this.mdqDao.selectTableByName(database, tableName, user);
        return DomainCoversionUtils.mdqTableToMdqTableBaseInfoVO(table);
    }

    @Override
    @DataSource(name="firstDataSource")
    public MdqTableBaseInfoVO getTableBaseInfoFromHive(MetadataQueryParam queryParam) {
        List<Map<String, Object>> tables = this.hiveMetaWithPermissionService.getTablesByDbNameAndOptionalUserName(queryParam);
        List<Map<String, Object>> partitionKeys = this.hiveMetaDao.getPartitionKeys(queryParam);
        Optional<Map> tableOptional = tables.parallelStream().filter(f -> queryParam.getTableName().equals(f.get("NAME"))).findFirst();
        Map talbe = tableOptional.orElseThrow(() -> new IllegalArgumentException("table\u4e0d\u5b58\u5728"));
        MdqTableBaseInfoVO mdqTableBaseInfoVO = DomainCoversionUtils.mapToMdqTableBaseInfoVO(talbe, queryParam.getDbName());
        String tableComment = this.hiveMetaDao.getTableComment(queryParam.getDbName(), queryParam.getTableName());
        mdqTableBaseInfoVO.getBase().setComment(tableComment);
        mdqTableBaseInfoVO.getBase().setPartitionTable(!partitionKeys.isEmpty());
        return mdqTableBaseInfoVO;
    }

    @Override
    @DataSource(name="secondDataSource")
    public List<MdqTableFieldsInfoVO> getTableFieldsInfoFromMdq(String database, String tableName, String user) {
        MdqTable table = this.mdqDao.selectTableByName(database, tableName, user);
        List<MdqField> mdqFieldList = this.mdqDao.listMdqFieldByTableId(table.getId());
        return DomainCoversionUtils.mdqFieldListToMdqTableFieldsInfoVOList(mdqFieldList);
    }

    @Override
    @DataSource(name="firstDataSource")
    public List<MdqTableFieldsInfoVO> getTableFieldsInfoFromHive(MetadataQueryParam queryParam) {
        List<Map<String, Object>> columns = this.hiveMetaDao.getColumns(queryParam);
        List<Map<String, Object>> partitionKeys = this.hiveMetaDao.getPartitionKeys(queryParam);
        List<MdqTableFieldsInfoVO> normalColumns = DomainCoversionUtils.normalColumnListToMdqTableFieldsInfoVOList(columns);
        List<MdqTableFieldsInfoVO> partitions = DomainCoversionUtils.partitionColumnListToMdqTableFieldsInfoVOList(partitionKeys);
        normalColumns.addAll(partitions);
        return normalColumns;
    }

    @Override
    @DataSource(name="firstDataSource")
    public MdqTableStatisticInfoVO getTableStatisticInfoFromHive(MetadataQueryParam queryParam, String partitionSort) throws IOException {
        List<String> partitions = this.hiveMetaDao.getPartitions(queryParam);
        MdqTableStatisticInfoVO mdqTableStatisticInfoVO = new MdqTableStatisticInfoVO();
        mdqTableStatisticInfoVO.setRowNum(0);
        mdqTableStatisticInfoVO.setTableLastUpdateTime(null);
        mdqTableStatisticInfoVO.setFieldsNum(this.getTableFieldsInfoFromHive(queryParam).size());
        String tableLocation = this.getTableLocation(queryParam);
        mdqTableStatisticInfoVO.setTableSize(this.getTableSize(tableLocation));
        mdqTableStatisticInfoVO.setFileNum(this.getTableFileNum(tableLocation));
        if (partitions.isEmpty()) {
            mdqTableStatisticInfoVO.setPartitionsNum(0);
        } else {
            mdqTableStatisticInfoVO.setPartitionsNum(this.getPartitionsNum(tableLocation));
            mdqTableStatisticInfoVO.setPartitions(this.getMdqTablePartitionStatisticInfoVO(partitions, "", partitionSort));
        }
        return mdqTableStatisticInfoVO;
    }

    @Override
    @DataSource(name="firstDataSource")
    public MdqTablePartitionStatisticInfoVO getPartitionStatisticInfo(MetadataQueryParam queryParam, String partitionPath) throws IOException {
        String tableLocation = this.getTableLocation(queryParam);
        this.logger.info("start to get partitionStatisticInfo,path:{}", (Object)(tableLocation + partitionPath));
        return this.create(tableLocation + partitionPath);
    }

    public List<MdqTablePartitionStatisticInfoVO> getMdqTablePartitionStatisticInfoVO(List<String> partitions, String partitionPath, String partitionSort) {
        ArrayList<MdqTablePartitionStatisticInfoVO> statisticInfoVOS = new ArrayList<MdqTablePartitionStatisticInfoVO>();
        Map<String, List<Tunple>> partitionsStr = partitions.stream().map(this::splitStrByFirstSlanting).filter(Objects::nonNull).collect(Collectors.groupingBy(Tunple::getKey));
        partitionsStr.forEach((k, v) -> {
            MdqTablePartitionStatisticInfoVO mdqTablePartitionStatisticInfoVO = new MdqTablePartitionStatisticInfoVO();
            mdqTablePartitionStatisticInfoVO.setName((String)k);
            String subPartitionPath = String.format("%s/%s", partitionPath, k);
            mdqTablePartitionStatisticInfoVO.setPartitionPath(subPartitionPath);
            List<String> subPartitions = v.stream().map(Tunple::getValue).collect(Collectors.toList());
            List<MdqTablePartitionStatisticInfoVO> childrens = this.getMdqTablePartitionStatisticInfoVO(subPartitions, subPartitionPath, partitionSort);
            childrens = "asc".equals(partitionSort) ? childrens.stream().sorted(Comparator.comparing(MdqTablePartitionStatisticInfoVO::getName)).collect(Collectors.toList()) : childrens.stream().sorted(Comparator.comparing(MdqTablePartitionStatisticInfoVO::getName).reversed()).collect(Collectors.toList());
            mdqTablePartitionStatisticInfoVO.setChildrens(childrens);
            statisticInfoVOS.add(mdqTablePartitionStatisticInfoVO);
        });
        return statisticInfoVOS;
    }

    private Tunple<String, String> splitStrByFirstSlanting(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        int index = str.indexOf("/");
        if (index == -1) {
            return new Tunple<String, Object>(str, null);
        }
        return new Tunple<String, String>(str.substring(0, index), str.substring(index + 1));
    }

    private MdqTablePartitionStatisticInfoVO create(String path) throws IOException {
        MdqTablePartitionStatisticInfoVO mdqTablePartitionStatisticInfoVO = new MdqTablePartitionStatisticInfoVO();
        mdqTablePartitionStatisticInfoVO.setName(new Path(path).getName());
        mdqTablePartitionStatisticInfoVO.setFileNum(this.getTableFileNum(path));
        mdqTablePartitionStatisticInfoVO.setPartitionSize(this.getTableSize(path));
        mdqTablePartitionStatisticInfoVO.setModificationTime(this.getTableModificationTime(path));
        return mdqTablePartitionStatisticInfoVO;
    }

    private Date getTableModificationTime(String tableLocation) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)tableLocation)) {
            FileStatus tableFile = this.getFileStatus(tableLocation);
            return new Date(tableFile.getModificationTime());
        }
        return null;
    }

    private int getPartitionsNum(String tableLocation) throws IOException {
        int partitionsNum = 0;
        if (StringUtils.isNotBlank((CharSequence)tableLocation)) {
            FileStatus tableFile = this.getFileStatus(tableLocation);
            partitionsNum = this.getRootHdfs().listStatus(tableFile.getPath()).length;
        }
        return partitionsNum;
    }

    @DataSource(name="firstDataSource")
    public String getTableLocation(MetadataQueryParam queryParam) {
        String tableLocation = this.hiveMetaDao.getLocationByDbAndTable(queryParam);
        this.logger.info("tableLocation:" + tableLocation);
        return tableLocation;
    }

    private int getTableFileNum(String tableLocation) throws IOException {
        int tableFileNum = 0;
        if (StringUtils.isNotBlank((CharSequence)tableLocation)) {
            FileStatus tableFile = this.getFileStatus(tableLocation);
            tableFileNum = (int)this.getRootHdfs().getContentSummary(tableFile.getPath()).getFileCount();
        }
        return tableFileNum;
    }

    private String getTableSize(String tableLocation) throws IOException {
        String tableSize = "0B";
        if (StringUtils.isNotBlank((CharSequence)tableLocation)) {
            FileStatus tableFile = this.getFileStatus(tableLocation);
            tableSize = ByteTimeUtils.bytesToString((long)this.getRootHdfs().getContentSummary(tableFile.getPath()).getLength());
        }
        return tableSize;
    }

    private FileStatus getFileStatus(String location) throws IOException {
        try {
            return this.getRootHdfs().getFileStatus(new Path(location));
        }
        catch (IOException e) {
            String message = e.getMessage();
            String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
            if (message != null && message.matches(DWSConfig.HDFS_FILE_SYSTEM_REST_ERRS) || rootCauseMessage != null && rootCauseMessage.matches(DWSConfig.HDFS_FILE_SYSTEM_REST_ERRS)) {
                this.logger.info("Failed to getFileStatus, retry", (Throwable)e);
                this.resetRootHdfs();
                return this.getFileStatus(location);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetRootHdfs() {
        if (HadoopConf.HDFS_ENABLE_CACHE()) {
            HDFSUtils.closeHDFSFIleSystem((FileSystem)HDFSUtils.getHDFSRootUserFileSystem(), (String)((String)HadoopConf.HADOOP_ROOT_USER().getValue()), (boolean)true);
            return;
        }
        if (rootHdfs != null) {
            MdqServiceImpl mdqServiceImpl = this;
            synchronized (mdqServiceImpl) {
                if (rootHdfs != null) {
                    IOUtils.closeQuietly((Closeable)rootHdfs);
                    this.logger.info("reset RootHdfs");
                    rootHdfs = HDFSUtils.getHDFSRootUserFileSystem();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSystem getRootHdfs() {
        if (HadoopConf.HDFS_ENABLE_CACHE()) {
            return HDFSUtils.getHDFSRootUserFileSystem();
        }
        if (rootHdfs == null) {
            MdqServiceImpl mdqServiceImpl = this;
            synchronized (mdqServiceImpl) {
                if (rootHdfs == null) {
                    rootHdfs = HDFSUtils.getHDFSRootUserFileSystem();
                }
            }
        }
        return rootHdfs;
    }
}

