/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.ddl;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.metadata.conf.MdqConfiguration$;
import org.apache.linkis.metadata.ddl.ImportHelper;
import org.apache.linkis.metadata.ddl.SQLConst;
import org.apache.linkis.metadata.domain.mdq.bo.MdqTableBO;
import org.apache.linkis.metadata.domain.mdq.bo.MdqTableFieldsInfoBO;
import org.apache.linkis.metadata.errorcode.LinkisMetadataErrorCodeSummary;
import org.apache.linkis.metadata.exception.MdqIllegalParamException;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class HiveImportDDLHelper$
implements ImportHelper,
SQLConst,
Logging {
    public static HiveImportDDLHelper$ MODULE$;
    private final String DATABASE;
    private final String TABLE;
    private final String AS_SELECT;
    private final String FROM;
    private final CommonVars<String> DEFAULT_PARTITION_NAME;
    private final String DEFAULT_PARTITION_DESC;
    private final String STORED_AS_ORC;
    private final String INSERT_OVERWRITE;
    private final String DYNAMIC_MODE;
    private final String DYNAMIC_PAR;
    private Logger logger;
    private final String SPARK_SQL;
    private final String LEFT_PARENTHESES;
    private final String RIGHT_PARENTHESES;
    private final String COMMA;
    private final String SPACE;
    private final String COMMENT;
    private final String CREATE_TABLE;
    private final String PARTITIONED_BY;
    private final String LINE_BREAK;
    private final String MARKS;
    private final String SINGLE_MARK;
    private final String STORED_AS;
    private final String SEMICOLON;
    private volatile boolean bitmap$0;

    static {
        new HiveImportDDLHelper$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        HiveImportDDLHelper$ hiveImportDDLHelper$ = this;
        synchronized (hiveImportDDLHelper$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String SPARK_SQL() {
        return this.SPARK_SQL;
    }

    @Override
    public String LEFT_PARENTHESES() {
        return this.LEFT_PARENTHESES;
    }

    @Override
    public String RIGHT_PARENTHESES() {
        return this.RIGHT_PARENTHESES;
    }

    @Override
    public String COMMA() {
        return this.COMMA;
    }

    @Override
    public String SPACE() {
        return this.SPACE;
    }

    @Override
    public String COMMENT() {
        return this.COMMENT;
    }

    @Override
    public String CREATE_TABLE() {
        return this.CREATE_TABLE;
    }

    @Override
    public String PARTITIONED_BY() {
        return this.PARTITIONED_BY;
    }

    @Override
    public String LINE_BREAK() {
        return this.LINE_BREAK;
    }

    @Override
    public String MARKS() {
        return this.MARKS;
    }

    @Override
    public String SINGLE_MARK() {
        return this.SINGLE_MARK;
    }

    @Override
    public String STORED_AS() {
        return this.STORED_AS;
    }

    @Override
    public String SEMICOLON() {
        return this.SEMICOLON;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$SPARK_SQL_$eq(String x$1) {
        this.SPARK_SQL = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$LEFT_PARENTHESES_$eq(String x$1) {
        this.LEFT_PARENTHESES = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$RIGHT_PARENTHESES_$eq(String x$1) {
        this.RIGHT_PARENTHESES = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$COMMA_$eq(String x$1) {
        this.COMMA = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$SPACE_$eq(String x$1) {
        this.SPACE = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$COMMENT_$eq(String x$1) {
        this.COMMENT = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$CREATE_TABLE_$eq(String x$1) {
        this.CREATE_TABLE = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$PARTITIONED_BY_$eq(String x$1) {
        this.PARTITIONED_BY = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$LINE_BREAK_$eq(String x$1) {
        this.LINE_BREAK = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$MARKS_$eq(String x$1) {
        this.MARKS = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$SINGLE_MARK_$eq(String x$1) {
        this.SINGLE_MARK = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$STORED_AS_$eq(String x$1) {
        this.STORED_AS = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$SEMICOLON_$eq(String x$1) {
        this.SEMICOLON = x$1;
    }

    public String DATABASE() {
        return this.DATABASE;
    }

    public String TABLE() {
        return this.TABLE;
    }

    public String AS_SELECT() {
        return this.AS_SELECT;
    }

    public String FROM() {
        return this.FROM;
    }

    public CommonVars<String> DEFAULT_PARTITION_NAME() {
        return this.DEFAULT_PARTITION_NAME;
    }

    public String DEFAULT_PARTITION_DESC() {
        return this.DEFAULT_PARTITION_DESC;
    }

    public String STORED_AS_ORC() {
        return this.STORED_AS_ORC;
    }

    public String INSERT_OVERWRITE() {
        return this.INSERT_OVERWRITE;
    }

    public String DYNAMIC_MODE() {
        return this.DYNAMIC_MODE;
    }

    public String DYNAMIC_PAR() {
        return this.DYNAMIC_PAR;
    }

    @Override
    public String generateCode(MdqTableBO mdqTableBO, String user) {
        scala.collection.mutable.StringBuilder stringBuilder;
        this.logger().info(new StringBuilder(42).append("begin to generate code for ").append(mdqTableBO.getTableBaseInfo().getBase().getName()).append(" using Hive way").toString());
        scala.collection.mutable.StringBuilder executeCode = new scala.collection.mutable.StringBuilder();
        Map<String, String> args = mdqTableBO.getImportInfo().getArgs();
        String destinationDatabase = mdqTableBO.getTableBaseInfo().getBase().getDatabase();
        String destinationTable = mdqTableBO.getTableBaseInfo().getBase().getName();
        if (StringUtils.isEmpty((CharSequence)destinationDatabase) || StringUtils.isEmpty((CharSequence)destinationTable)) {
            this.logger().error("Hive create table destination database or tablename is null");
            throw new MdqIllegalParamException(LinkisMetadataErrorCodeSummary.HIVE_CREATE_IS_NULL.getErrorDesc());
        }
        if (StringUtils.isEmpty((CharSequence)args.get(this.DATABASE()))) {
            throw new MdqIllegalParamException(LinkisMetadataErrorCodeSummary.HIVE_CREATE__TABLE_IS_NULL.getErrorDesc());
        }
        String sourceDatabase = args.get(this.DATABASE());
        if (StringUtils.isEmpty((CharSequence)args.get(this.TABLE()))) {
            throw new MdqIllegalParamException(LinkisMetadataErrorCodeSummary.HIVE_CREATE__TABLE_IS_NULL.getErrorDesc());
        }
        String sourceTableName = args.get(this.TABLE());
        Boolean isPartitionTable = mdqTableBO.getTableBaseInfo().getBase().getPartitionTable();
        if (isPartitionTable != null && BoxesRunTime.equals((Object)isPartitionTable, (Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            String standardDs;
            executeCode.append(this.SPARK_SQL()).append(this.LEFT_PARENTHESES()).append(this.MARKS());
            executeCode.append(this.CREATE_TABLE()).append(destinationDatabase).append(".").append(destinationTable).append(this.SPACE());
            executeCode.append(this.LEFT_PARENTHESES());
            List<MdqTableFieldsInfoBO> fields = mdqTableBO.getTableFieldsInfo();
            ArrayBuffer createFieldsArray = new ArrayBuffer();
            ArrayBuffer insertFieldsArray = new ArrayBuffer();
            IntRef dsCount = IntRef.create((int)0);
            ObjectRef partitionValue = ObjectRef.create(null);
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fields).asScala()).foreach((Function1 & Serializable & scala.Serializable)field -> {
                String name = field.getName();
                String _type = field.getType();
                String desc = field.getComment();
                if (!((String)MODULE$.DEFAULT_PARTITION_NAME().getValue()).equals(name)) {
                    if (StringUtils.isNotEmpty((CharSequence)desc)) {
                        createFieldsArray.$plus$eq((Object)new StringBuilder(0).append(name).append(MODULE$.SPACE()).append(_type).append(MODULE$.SPACE()).append(MODULE$.COMMENT()).append(MODULE$.SPACE()).append(MODULE$.SINGLE_MARK()).append(desc).append(MODULE$.SINGLE_MARK()).toString());
                        return insertFieldsArray.$plus$eq((Object)name);
                    }
                    createFieldsArray.$plus$eq((Object)new StringBuilder(0).append(name).append(MODULE$.SPACE()).append(_type).toString());
                    return insertFieldsArray.$plus$eq((Object)name);
                }
                ++dsCount$1.elem;
                if (StringUtils.isNotBlank((CharSequence)field.getPartitionsValue())) {
                    partitionValue$1.elem = field.getPartitionsValue();
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            });
            executeCode.append(createFieldsArray.mkString(new StringBuilder(0).append(this.COMMA()).append(this.SPACE()).toString())).append(this.RIGHT_PARENTHESES()).append(this.SPACE());
            executeCode.append(this.DEFAULT_PARTITION_DESC()).append(this.SPACE());
            executeCode.append(this.STORED_AS_ORC());
            executeCode.append(this.MARKS()).append(this.RIGHT_PARENTHESES()).append(this.LINE_BREAK());
            boolean isSourceTablePartition = this.checkPartitionTable(fields);
            String string = standardDs = StringUtils.isNotBlank((CharSequence)((String)partitionValue.elem)) ? (String)partitionValue.elem : new SimpleDateFormat("yyyyMMdd").format(new Date(System.currentTimeMillis()));
            if (!isSourceTablePartition) {
                executeCode.append(this.SPARK_SQL()).append(this.LEFT_PARENTHESES()).append(this.MARKS());
                executeCode.append(new StringBuilder(1).append(this.INSERT_OVERWRITE()).append(destinationDatabase).append(".").append(destinationTable).toString()).append(this.SPACE());
                executeCode.append("partition").append(this.LEFT_PARENTHESES()).append("ds=").append("\"").append(standardDs).append("\"").append(this.RIGHT_PARENTHESES()).append(this.SPACE());
                executeCode.append(this.AS_SELECT()).append(this.SPACE()).append(insertFieldsArray.mkString(this.COMMA())).append(this.SPACE());
                executeCode.append(this.FROM()).append(sourceDatabase).append(".").append(sourceTableName);
                stringBuilder = executeCode.append(this.MARKS()).append(this.RIGHT_PARENTHESES());
            } else {
                boolean doubleDs;
                boolean bl = doubleDs = dsCount.elem >= 2;
                if (doubleDs) {
                    executeCode.append(this.DYNAMIC_PAR()).append(this.LINE_BREAK());
                    executeCode.append(this.DYNAMIC_MODE()).append(this.LINE_BREAK());
                    executeCode.append(this.SPARK_SQL()).append(this.LEFT_PARENTHESES()).append(this.MARKS());
                    executeCode.append(new StringBuilder(1).append(this.INSERT_OVERWRITE()).append(destinationDatabase).append(".").append(destinationTable).toString()).append(this.SPACE());
                    executeCode.append("partition").append(this.LEFT_PARENTHESES()).append("ds").append(this.RIGHT_PARENTHESES()).append(this.SPACE());
                    executeCode.append(this.AS_SELECT()).append(this.SPACE()).append(insertFieldsArray.mkString(this.COMMA())).append(this.COMMA()).append("ds").append(this.SPACE());
                    executeCode.append(this.FROM()).append(sourceDatabase).append(".").append(sourceTableName);
                    stringBuilder = executeCode.append(this.MARKS()).append(this.RIGHT_PARENTHESES());
                } else {
                    executeCode.append(this.SPARK_SQL()).append(this.LEFT_PARENTHESES()).append(this.MARKS());
                    executeCode.append(new StringBuilder(1).append(this.INSERT_OVERWRITE()).append(destinationDatabase).append(".").append(destinationTable).toString()).append(this.SPACE());
                    executeCode.append("partition").append(this.LEFT_PARENTHESES()).append("ds=").append("\"").append(standardDs).append("\"").append(this.RIGHT_PARENTHESES()).append(this.SPACE());
                    executeCode.append(this.AS_SELECT()).append(this.SPACE()).append(insertFieldsArray.mkString(this.COMMA())).append(this.SPACE());
                    executeCode.append(this.FROM()).append(sourceDatabase).append(".").append(sourceTableName);
                    stringBuilder = executeCode.append(this.MARKS()).append(this.RIGHT_PARENTHESES());
                }
            }
        } else {
            scala.collection.mutable.StringBuilder stringBuilder2;
            executeCode.append(this.SPARK_SQL()).append(this.LEFT_PARENTHESES()).append(this.MARKS());
            executeCode.append(this.CREATE_TABLE()).append(destinationDatabase).append(".").append(destinationTable).append(this.SPACE());
            executeCode.append(this.AS_SELECT()).append(this.SPACE());
            List<MdqTableFieldsInfoBO> fields = mdqTableBO.getTableFieldsInfo();
            if (fields.isEmpty()) {
                stringBuilder2 = executeCode.append("*").append(this.SPACE());
            } else {
                ArrayBuffer fieldArr = new ArrayBuffer();
                ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fields).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HiveImportDDLHelper$.$anonfun$generateCode$2(x$1)))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> fieldArr.$plus$eq((Object)x$2.getName()));
                stringBuilder2 = executeCode.append(fieldArr.mkString(", ")).append(this.SPACE());
            }
            executeCode.append(this.FROM()).append(this.SPACE()).append(sourceDatabase).append(".").append(sourceTableName);
            stringBuilder = executeCode.append(this.MARKS()).append(this.RIGHT_PARENTHESES());
        }
        String resultCode = executeCode.toString();
        this.logger().info(new StringBuilder(34).append("end to generate code for ").append(mdqTableBO.getTableBaseInfo().getBase().getName()).append(" code is ").append(resultCode).toString());
        return resultCode;
    }

    public boolean checkPartitionTable(List<MdqTableFieldsInfoBO> fields) {
        IntRef count = IntRef.create((int)0);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fields).asScala()).foreach((Function1 & Serializable & scala.Serializable)field -> {
            HiveImportDDLHelper$.$anonfun$checkPartitionTable$1(count, field);
            return BoxedUnit.UNIT;
        });
        return count.elem >= 2;
    }

    public static final /* synthetic */ boolean $anonfun$generateCode$2(MdqTableFieldsInfoBO x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ void $anonfun$checkPartitionTable$1(IntRef count$1, MdqTableFieldsInfoBO field) {
        if (field.getPartitionField() != null && Predef$.MODULE$.Boolean2boolean(field.getPartitionField())) {
            ++count$1.elem;
            return;
        }
    }

    private HiveImportDDLHelper$() {
        MODULE$ = this;
        SQLConst.$init$(this);
        Logging.$init$((Logging)this);
        this.DATABASE = "database";
        this.TABLE = "table";
        this.AS_SELECT = "select";
        this.FROM = new StringBuilder(4).append("from").append(this.SPACE()).toString();
        this.DEFAULT_PARTITION_NAME = CommonVars$.MODULE$.apply("bdp.dataworkcloud.datasource.default.par.name", (Object)"ds");
        this.DEFAULT_PARTITION_DESC = new StringBuilder(11).append(this.PARTITIONED_BY()).append("(ds string)").toString();
        this.STORED_AS_ORC = new StringBuilder(0).append(this.STORED_AS()).append(this.SPACE()).append(MdqConfiguration$.MODULE$.DEFAULT_STORED_TYPE().getValue()).toString();
        this.INSERT_OVERWRITE = new StringBuilder(22).append("insert overwrite table").append(this.SPACE()).toString();
        this.DYNAMIC_MODE = "spark.sql(\"set hive.exec.dynamic.partition.mode=nonstrict\")";
        this.DYNAMIC_PAR = "spark.sql(\"set hive.exec.dynamic.partition=true\")";
    }
}

