/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.configuration.service.impl;

import org.apache.linkis.configuration.dao.DepartmentMapper;
import org.apache.linkis.configuration.entity.DepartmentVo;
import org.apache.linkis.configuration.service.DepartmentService;
import org.apache.linkis.governance.common.protocol.conf.DepartmentRequest;
import org.apache.linkis.governance.common.protocol.conf.DepartmentResponse;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DepartmentServiceImpl
implements DepartmentService {
    private static final Logger logger = LoggerFactory.getLogger(DepartmentServiceImpl.class);
    @Autowired
    private DepartmentMapper departmentMapper;

    @Override
    @Receiver
    public DepartmentResponse getDepartmentByUser(DepartmentRequest departmentRequest, Sender sender) {
        DepartmentVo departmentVo = this.departmentMapper.getDepartmentByUser(departmentRequest.user());
        if (null == departmentVo) {
            logger.warn("Department data loading failed user {},department cache will set ''  ", (Object)departmentRequest.user());
            return new DepartmentResponse(departmentRequest.user(), "", "");
        }
        return new DepartmentResponse(departmentRequest.user(), departmentVo.getOrgId(), departmentVo.getOrgName());
    }
}

