/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.server.security;

import java.io.Serializable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.utils.DESUtil;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.server.conf.ServerConfiguration$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ProxyUserSSOUtils$
implements Logging {
    public static ProxyUserSSOUtils$ MODULE$;
    private final String PROXY_TICKET_HEADER_CRYPT_KEY;
    private final String PROXY_TICKET_HEADER_CONTENT;
    private final String linkisTrustCode;
    private final String PROXY_USER_TICKET_ID_STRING;
    private final boolean sslEnable;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ProxyUserSSOUtils$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        ProxyUserSSOUtils$ proxyUserSSOUtils$ = this;
        synchronized (proxyUserSSOUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private String PROXY_TICKET_HEADER_CRYPT_KEY() {
        return this.PROXY_TICKET_HEADER_CRYPT_KEY;
    }

    private String PROXY_TICKET_HEADER_CONTENT() {
        return this.PROXY_TICKET_HEADER_CONTENT;
    }

    private String linkisTrustCode() {
        return this.linkisTrustCode;
    }

    public String PROXY_USER_TICKET_ID_STRING() {
        return this.PROXY_USER_TICKET_ID_STRING;
    }

    private boolean sslEnable() {
        return this.sslEnable;
    }

    private Option<String> getProxyUsernameByTicket(String ticketId) {
        if (StringUtils.isBlank((CharSequence)ticketId)) {
            return None$.MODULE$;
        }
        String userName = DESUtil.decrypt((String)ticketId, (String)ServerConfiguration$.MODULE$.cryptKey());
        if (userName.startsWith(this.linkisTrustCode())) {
            return new Some((Object)userName.substring(this.linkisTrustCode().length()));
        }
        return None$.MODULE$;
    }

    private String getTicketByUsernameAndTrustCode(String userName, String trustCode) {
        if (!trustCode.equals(this.linkisTrustCode())) {
            this.logger().info(new StringBuilder(35).append(trustCode).append(" error,will be use default username").toString());
            return userName;
        }
        return DESUtil.encrypt((String)new StringBuilder(0).append(trustCode).append(userName).toString(), (String)ServerConfiguration$.MODULE$.cryptKey());
    }

    public Tuple2<String, String> getProxyUserTicketKV(String proxyUsername, String trustCode) {
        String userTicketId = this.getTicketByUsernameAndTrustCode(proxyUsername, trustCode);
        return new Tuple2((Object)this.PROXY_USER_TICKET_ID_STRING(), (Object)userTicketId);
    }

    public void setProxyUserCookie(Function1<Cookie, BoxedUnit> addCookie, String username, String trustCode) {
        this.logger().info(new StringBuilder(37).append("add login userTicketCookie for user ").append(username).append(".").toString());
        Tuple2<String, String> userTicketIdKv = this.getProxyUserTicketKV(username, trustCode);
        Cookie cookie = new Cookie((String)userTicketIdKv._1(), (String)userTicketIdKv._2());
        cookie.setMaxAge(-1);
        if (this.sslEnable()) {
            cookie.setSecure(true);
        }
        cookie.setPath("/");
        addCookie.apply((Object)cookie);
    }

    public void removeProxyUser(Function0<Cookie[]> getCookies) {
        Cookie[] cookies = (Cookie[])getCookies.apply();
        if (cookies != null) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cookies)).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ProxyUserSSOUtils$.$anonfun$removeProxyUser$1(x$1))).foreach((Function1 & Serializable & scala.Serializable)cookie -> {
                ProxyUserSSOUtils$.$anonfun$removeProxyUser$2(cookie);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void removeLoginUserByAddCookie(Function1<Cookie, BoxedUnit> addEmptyCookie) {
        Cookie cookie = new Cookie(this.PROXY_USER_TICKET_ID_STRING(), null);
        cookie.setMaxAge(0);
        cookie.setPath("/");
        addEmptyCookie.apply((Object)cookie);
    }

    public Option<String> getProxyUserUsername(HttpServletRequest req) {
        Option ticketOption = Option$.MODULE$.apply((Object)req.getCookies()).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2)).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ProxyUserSSOUtils$.$anonfun$getProxyUserUsername$2(x$3))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getValue()));
        if (ticketOption.isDefined()) {
            this.logger().info(new StringBuilder(29).append("PROXY_USER_TICKET_ID_STRING: ").append(ticketOption.get()).toString());
            return this.getProxyUsernameByTicket((String)ticketOption.get());
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$removeProxyUser$1(Cookie x$1) {
        String string = x$1.getName();
        String string2 = MODULE$.PROXY_USER_TICKET_ID_STRING();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$removeProxyUser$2(Cookie cookie) {
        cookie.setValue(null);
        cookie.setMaxAge(0);
    }

    public static final /* synthetic */ boolean $anonfun$getProxyUserUsername$2(Cookie x$3) {
        String string = x$3.getName();
        String string2 = MODULE$.PROXY_USER_TICKET_ID_STRING();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private ProxyUserSSOUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.PROXY_TICKET_HEADER_CRYPT_KEY = (String)CommonVars$.MODULE$.apply("wds.linkis.proxy.ticket.header.crypt.key", (Object)"linkis-trust-key").getValue();
        this.PROXY_TICKET_HEADER_CONTENT = (String)CommonVars$.MODULE$.apply("wds.linkis.proxy.ticket.header.crypt.key", (Object)"bfs_").getValue();
        this.linkisTrustCode = DESUtil.encrypt((String)this.PROXY_TICKET_HEADER_CONTENT(), (String)this.PROXY_TICKET_HEADER_CRYPT_KEY());
        this.PROXY_USER_TICKET_ID_STRING = (String)ServerConfiguration$.MODULE$.LINKIS_SERVER_SESSION_PROXY_TICKETID_KEY().getValue();
        this.sslEnable = BoxesRunTime.unboxToBoolean((Object)ServerConfiguration$.MODULE$.BDP_SERVER_SECURITY_SSL().getValue());
    }
}

