/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.ecm.server.service.impl;

import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.ecm.core.engineconn.EngineConn;
import org.apache.linkis.ecm.core.launch.EngineConnLaunch;
import org.apache.linkis.ecm.core.launch.ProcessEngineConnLaunch;
import org.apache.linkis.ecm.server.LinkisECMApplication;
import org.apache.linkis.ecm.server.conf.ECMConfiguration$;
import org.apache.linkis.ecm.server.listener.EngineConnStopEvent;
import org.apache.linkis.ecm.server.service.LocalDirsHandleService;
import org.apache.linkis.ecm.server.service.impl.AbstractEngineConnLaunchService;
import org.apache.linkis.ecm.utils.ECMCacheUtils;
import org.apache.linkis.governance.common.utils.JobUtils$;
import org.apache.linkis.governance.common.utils.LoggerUtils;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.apache.linkis.manager.common.protocol.engine.EngineConnStatusCallbackToAM;
import org.apache.linkis.manager.common.protocol.engine.EngineStopRequest;
import org.apache.linkis.manager.engineplugin.common.launch.entity.EngineConnLaunchRequest;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.rpc.Sender$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001i3Q\u0001C\u0005\u0002\u0002aAQ!\b\u0001\u0005\u0002yA\u0011\u0002\t\u0001A\u0002\u0003\u0007I\u0011B\u0011\t\u0013\u0019\u0002\u0001\u0019!a\u0001\n\u00139\u0003\"\u0003\u0019\u0001\u0001\u0004\u0005\t\u0015)\u0003#\u0011\u0015\t\u0004\u0001\"\u00013\u0011\u0015!\u0004\u0001\"\u00116\u0011\u0015\u0001\u0006\u0001\"\u0003R\u0005y\u0001&o\\2fgN,enZ5oK\u000e{gN\u001c'bk:\u001c\u0007nU3sm&\u001cWM\u0003\u0002\u000b\u0017\u0005!\u0011.\u001c9m\u0015\taQ\"A\u0004tKJ4\u0018nY3\u000b\u00059y\u0011AB:feZ,'O\u0003\u0002\u0011#\u0005\u0019QmY7\u000b\u0005I\u0019\u0012A\u00027j].L7O\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7\u0001A\n\u0003\u0001e\u0001\"AG\u000e\u000e\u0003%I!\u0001H\u0005\u0003?\u0005\u00137\u000f\u001e:bGR,enZ5oK\u000e{gN\u001c'bk:\u001c\u0007nU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011!\u0004A\u0001\u0017Y>\u001c\u0017\r\u001c#jeND\u0015M\u001c3mKN+'O^5dKV\t!\u0005\u0005\u0002$I5\t1\"\u0003\u0002&\u0017\t1Bj\\2bY\u0012K'o\u001d%b]\u0012dWmU3sm&\u001cW-\u0001\u000em_\u000e\fG\u000eR5sg\"\u000bg\u000e\u001a7f'\u0016\u0014h/[2f?\u0012*\u0017\u000f\u0006\u0002)]A\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t!QK\\5u\u0011\u001dy3!!AA\u0002\t\n1\u0001\u001f\u00132\u0003]awnY1m\t&\u00148\u000fS1oI2,7+\u001a:wS\u000e,\u0007%A\rtKRdunY1m\t&\u00148\u000fS1oI2,7+\u001a:wS\u000e,GC\u0001\u00154\u0011\u0015\u0001S\u00011\u0001#\u0003m\u0019H/\u0019:u\u000b:<\u0017N\\3D_:tWj\u001c8ji>\u00148\u000b^1siR\u0019\u0001F\u000e$\t\u000b]2\u0001\u0019\u0001\u001d\u0002\u000fI,\u0017/^3tiB\u0011\u0011\bR\u0007\u0002u)\u00111\bP\u0001\u0007K:$\u0018\u000e^=\u000b\u0005ur\u0014A\u00027bk:\u001c\u0007N\u0003\u0002@\u0001\u000611m\\7n_:T!!\u0011\"\u0002\u0019\u0015tw-\u001b8fa2,x-\u001b8\u000b\u0005\r\u000b\u0012aB7b]\u0006<WM]\u0005\u0003\u000bj\u0012q#\u00128hS:,7i\u001c8o\u0019\u0006,hn\u00195SKF,Xm\u001d;\t\u000b\u001d3\u0001\u0019\u0001%\u0002\t\r|gN\u001c\t\u0003\u0013:k\u0011A\u0013\u0006\u0003\u00172\u000b!\"\u001a8hS:,7m\u001c8o\u0015\tiu\"\u0001\u0003d_J,\u0017BA(K\u0005))enZ5oK\u000e{gN\\\u0001\u0015aJ|7-Z:t\u001b>t\u0017\u000e^8s)\"\u0014X-\u00193\u0015\u0007!\u0012F\u000bC\u0003T\u000f\u0001\u0007\u0001*\u0001\u0006f]\u001eLg.Z\"p]:DQ!P\u0004A\u0002U\u0003\"A\u0016-\u000e\u0003]S!!\u0010'\n\u0005e;&a\u0006)s_\u000e,7o]#oO&tWmQ8o]2\u000bWO\\2i\u0001")
public abstract class ProcessEngineConnLaunchService
extends AbstractEngineConnLaunchService {
    private LocalDirsHandleService localDirsHandleService;

    private LocalDirsHandleService localDirsHandleService() {
        return this.localDirsHandleService;
    }

    private void localDirsHandleService_$eq(LocalDirsHandleService x$1) {
        this.localDirsHandleService = x$1;
    }

    public void setLocalDirsHandleService(LocalDirsHandleService localDirsHandleService) {
        this.localDirsHandleService_$eq(localDirsHandleService);
    }

    @Override
    public void startEngineConnMonitorStart(EngineConnLaunchRequest request, EngineConn conn) {
        EngineConnLaunch engineConnLaunch = conn.getEngineConnLaunchRunner().getEngineConnLaunch();
        if (engineConnLaunch instanceof ProcessEngineConnLaunch) {
            ProcessEngineConnLaunch processEngineConnLaunch = (ProcessEngineConnLaunch)engineConnLaunch;
            processEngineConnLaunch.getPid().foreach((Function1 & Serializable & scala.Serializable)pid -> {
                conn.setPid(pid);
                return BoxedUnit.UNIT;
            });
            this.processMonitorThread(conn, processEngineConnLaunch);
            return;
        }
    }

    private void processMonitorThread(EngineConn engineConn, ProcessEngineConnLaunch launch) {
        Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tickedId = engineConn.getTickedId();
            scala.collection.mutable.StringBuilder errorMsg = new scala.collection.mutable.StringBuilder();
            String taskId = JobUtils$.MODULE$.getJobIdFromStringMap(launch.getEngineConnLaunchRequest().creationDesc().properties());
            LoggerUtils.setJobIdMDC((String)taskId);
            Utils$.MODULE$.tryAndWarnMsg((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                LineIterator iterator = IOUtils.lineIterator((InputStream)launch.getProcessInputStream(), (String)((String)Configuration$.MODULE$.BDP_ENCODING().getValue()));
                int maxLen = BoxesRunTime.unboxToInt((Object)ECMConfiguration$.MODULE$.ENGINE_START_ERROR_MSG_MAX_LEN().getValue());
                for (int count = 0; launch.isAlive() && iterator.hasNext() && count < maxLen; ++count) {
                    String line = iterator.next();
                    errorMsg.append(line).append("\n");
                }
                int exitCode = launch.processWaitFor();
                String engineType = LabelUtil$.MODULE$.getEngineType(launch.getEngineConnLaunchRequest().labels());
                String logPath = (String)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> engineConn.getEngineConnManagerEnv().engineConnLogDirs(), (Function1 & Serializable & scala.Serializable)t -> this.localDirsHandleService().getEngineConnLogDir(launch.getEngineConnLaunchRequest().user(), tickedId, engineType));
                if (exitCode != 0) {
                    EngineStopRequest stopRequest = ECMCacheUtils.getStopEC(engineConn.getServiceInstance());
                    if (stopRequest != null && engineConn.getPid() != null && engineConn.getPid().equals(stopRequest.getIdentifier())) {
                        this.logger().info(new StringBuilder(59).append("EC ").append(engineConn.getServiceInstance()).append(" exit should by kill stop request ").append(stopRequest).append(", do not report status").toString());
                    } else {
                        boolean canRetry = errorMsg.isEmpty() || new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(ECMConfiguration$.MODULE$.EC_CAN_RETRY_EXIT_CODES())).contains((Object)BoxesRunTime.boxToInteger((int)exitCode));
                        this.logger().warn(new StringBuilder(73).append("Failed to start ec ").append(engineConn.getServiceInstance()).append(", status shutting down exit code ").append(exitCode).append(", canRetry ").append(canRetry).append(", logPath ").append(logPath).toString());
                        Sender$.MODULE$.getSender(ECMConfiguration$.MODULE$.MANAGER_SERVICE_NAME()).send((Object)new EngineConnStatusCallbackToAM(engineConn.getServiceInstance(), NodeStatus.ShuttingDown, new StringBuilder(116).append("Failed to start EngineConn, reason: ").append((CharSequence)errorMsg).append("\n You can go to this path(").append(logPath).append(") to find the reason or ask the administrator for help").toString(), canRetry));
                    }
                    engineConn.setStatus(NodeStatus.ShuttingDown);
                } else {
                    engineConn.setStatus(NodeStatus.Success);
                }
                EngineStopRequest engineStopRequest = new EngineStopRequest();
                engineStopRequest.setEngineType(engineType);
                engineStopRequest.setUser(launch.getEngineConnLaunchRequest().user());
                engineStopRequest.setIdentifier(engineConn.getPid());
                engineStopRequest.setIdentifierType("process");
                engineStopRequest.setLogDirSuffix(logPath);
                engineStopRequest.setServiceInstance(engineConn.getServiceInstance());
                LinkisECMApplication.getContext().getECMAsyncListenerBus().post((Event)new EngineConnStopEvent(engineConn, engineStopRequest));
            }, new StringBuilder(28).append("EngineConns: ").append(engineConn.getServiceInstance()).append(" monitor Failed").toString(), this.logger());
            LoggerUtils.removeJobIdMDC();
        }, (ExecutionContext)this.executor());
    }
}

