/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.resultset.table;

import java.io.Serializable;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.io.resultset.ResultDeserializer;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.storage.conf.LinkisStorageConf$;
import org.apache.linkis.storage.domain.Column;
import org.apache.linkis.storage.domain.DataType$;
import org.apache.linkis.storage.domain.Dolphin$;
import org.apache.linkis.storage.errorcode.LinkisStorageErrorCodeSummary;
import org.apache.linkis.storage.exception.ColLengthExceedException;
import org.apache.linkis.storage.exception.ColumnIndexExceedException;
import org.apache.linkis.storage.exception.StorageErrorException;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00014AAC\u0006\u00011!)q\u0006\u0001C\u0001a!I!\u0007\u0001a\u0001\u0002\u0004%\ta\r\u0005\ni\u0001\u0001\r\u00111A\u0005\u0002UB\u0011B\u0010\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0012\t\u000f}\u0002\u0001\u0019!C\u0001\u0001\"9q\n\u0001a\u0001\n\u0003\u0001\u0006B\u0002*\u0001A\u0003&\u0011\tC\u0003T\u0001\u0011\u0005C\u000bC\u0003^\u0001\u0011\u0005cLA\fUC\ndWMU3tk2$H)Z:fe&\fG.\u001b>fe*\u0011A\"D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001d=\t\u0011B]3tk2$8/\u001a;\u000b\u0005A\t\u0012aB:u_J\fw-\u001a\u0006\u0003%M\ta\u0001\\5oW&\u001c(B\u0001\u000b\u0016\u0003\u0019\t\u0007/Y2iK*\ta#A\u0002pe\u001e\u001c\u0001aE\u0002\u00013%\u0002BA\u0007\u0011#M5\t1D\u0003\u0002\u000f9)\u0011QDH\u0001\u0003S>T!aH\t\u0002\r\r|W.\\8o\u0013\t\t3D\u0001\nSKN,H\u000e\u001e#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\bCA\u0012%\u001b\u0005Y\u0011BA\u0013\f\u00055!\u0016M\u00197f\u001b\u0016$\u0018\rR1uCB\u00111eJ\u0005\u0003Q-\u00111\u0002V1cY\u0016\u0014VmY8sIB\u0011!&L\u0007\u0002W)\u0011AFH\u0001\u0006kRLGn]\u0005\u0003]-\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002cA\u00111\u0005A\u0001\t[\u0016$\u0018\rR1uCV\t!%\u0001\u0007nKR\fG)\u0019;b?\u0012*\u0017\u000f\u0006\u00027yA\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t!QK\\5u\u0011\u001di4!!AA\u0002\t\n1\u0001\u001f\u00132\u0003%iW\r^1ECR\f\u0007%A\u0005d_2,XN\\*fiV\t\u0011\tE\u0002C\u00132s!aQ$\u0011\u0005\u0011CT\"A#\u000b\u0005\u0019;\u0012A\u0002\u001fs_>$h(\u0003\u0002Iq\u00051\u0001K]3eK\u001aL!AS&\u0003\u0007M+GO\u0003\u0002IqA\u0011q'T\u0005\u0003\u001db\u00121!\u00138u\u00035\u0019w\u000e\\;n]N+Go\u0018\u0013fcR\u0011a'\u0015\u0005\b{\u0019\t\t\u00111\u0001B\u0003)\u0019w\u000e\\;n]N+G\u000fI\u0001\u000fGJ,\u0017\r^3NKR\fG)\u0019;b)\t\u0011S\u000bC\u0003W\u0011\u0001\u0007q+A\u0003csR,7\u000fE\u000281jK!!\u0017\u001d\u0003\u000b\u0005\u0013(/Y=\u0011\u0005]Z\u0016B\u0001/9\u0005\u0011\u0011\u0015\u0010^3\u0002\u0019\r\u0014X-\u0019;f%\u0016\u001cwN\u001d3\u0015\u0005\u0019z\u0006\"\u0002,\n\u0001\u00049\u0006")
public class TableResultDeserializer
extends ResultDeserializer<TableMetaData, TableRecord>
implements Logging {
    private TableMetaData metaData;
    private Set<Object> columnSet;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        TableResultDeserializer tableResultDeserializer = this;
        synchronized (tableResultDeserializer) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public TableMetaData metaData() {
        return this.metaData;
    }

    public void metaData_$eq(TableMetaData x$1) {
        this.metaData = x$1;
    }

    public Set<Object> columnSet() {
        return this.columnSet;
    }

    public void columnSet_$eq(Set<Object> x$1) {
        this.columnSet = x$1;
    }

    public TableMetaData createMetaData(byte[] bytes) {
        int colByteLen = new StringOps(Predef$.MODULE$.augmentString(Dolphin$.MODULE$.getString(bytes, 0, Dolphin$.MODULE$.INT_LEN()))).toInt();
        String colString = Dolphin$.MODULE$.getString(bytes, Dolphin$.MODULE$.INT_LEN(), colByteLen);
        String[] colArray = colString.endsWith(Dolphin$.MODULE$.COL_SPLIT()) ? colString.substring(0, colString.length() - 1).split(Dolphin$.MODULE$.COL_SPLIT()) : colString.split(Dolphin$.MODULE$.COL_SPLIT());
        IntRef index = IntRef.create((int)(Dolphin$.MODULE$.INT_LEN() + colByteLen));
        if (colArray.length % 3 != 0) {
            throw new StorageErrorException(LinkisStorageErrorCodeSummary.PARSING_METADATA_FAILED.getErrorCode(), LinkisStorageErrorCodeSummary.PARSING_METADATA_FAILED.getErrorDesc());
        }
        ArrayBuffer columns = new ArrayBuffer();
        RichInt$.MODULE$.until$extension1(Predef$.MODULE$.intWrapper(0), colArray.length, 3).foreach((Function1 & Serializable & scala.Serializable)i -> TableResultDeserializer.$anonfun$createMetaData$1(colArray, bytes, index, columns, BoxesRunTime.unboxToInt((Object)i)));
        this.metaData_$eq(new TableMetaData((Column[])columns.toArray(ClassTag$.MODULE$.apply(Column.class))));
        return this.metaData();
    }

    public TableRecord createRecord(byte[] bytes) {
        int colByteLen = new StringOps(Predef$.MODULE$.augmentString(Dolphin$.MODULE$.getString(bytes, 0, Dolphin$.MODULE$.INT_LEN()))).toInt();
        String colString = Dolphin$.MODULE$.getString(bytes, Dolphin$.MODULE$.INT_LEN(), colByteLen);
        String[] colArray = colString.endsWith(Dolphin$.MODULE$.COL_SPLIT()) ? colString.substring(0, colString.length() - 1).split(Dolphin$.MODULE$.COL_SPLIT()) : colString.split(Dolphin$.MODULE$.COL_SPLIT());
        IntRef index = IntRef.create((int)(Dolphin$.MODULE$.INT_LEN() + colByteLen));
        BooleanRef enableLimit = BooleanRef.create((boolean)false);
        if (StringUtils.isNotBlank((CharSequence)LinkisStorageConf$.MODULE$.enableLimitThreadLocal().get())) {
            enableLimit.elem = true;
        }
        int[] columnIndices = LinkisStorageConf$.MODULE$.columnIndicesThreadLocal().get();
        if (this.columnSet() == null && columnIndices != null) {
            this.columnSet_$eq((Set<Object>)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(columnIndices)).toSet());
        }
        int lastIndex = columnIndices != null && columnIndices.length > 0 ? columnIndices[columnIndices.length - 1] : 0;
        int realValueSize = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])colArray)).size();
        if (enableLimit.elem && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.metaData().columns())).size() <= columnIndices[0]) {
            throw new ColumnIndexExceedException(LinkisStorageErrorCodeSummary.RESULT_COLUMN_INDEX_OUT_OF_BOUNDS.getErrorCode(), MessageFormat.format(LinkisStorageErrorCodeSummary.RESULT_COLUMN_INDEX_OUT_OF_BOUNDS.getErrorDesc(), BoxesRunTime.boxToInteger((int)columnIndices[0]), BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.metaData().columns())).size())));
        }
        if (enableLimit.elem && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.metaData().columns())).size() > lastIndex) {
            realValueSize = columnIndices.length;
        } else if (enableLimit.elem && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.metaData().columns())).size() <= lastIndex) {
            realValueSize = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.metaData().columns())).size() % columnIndices.length;
        }
        int columnSize = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])colArray)).size();
        Object[] rowArray = new Object[realValueSize];
        IntRef colIdx = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), columnSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int len = new StringOps(Predef$.MODULE$.augmentString(colArray[i])).toInt();
            String res = Dolphin$.MODULE$.getString(bytes, index$2.elem, len);
            if (res.length() > LinkisStorageConf$.MODULE$.LINKIS_RESULT_COL_LENGTH() && enableLimit$1.elem) {
                throw new ColLengthExceedException(LinkisStorageErrorCodeSummary.RESULT_COL_LENGTH.getErrorCode(), MessageFormat.format(LinkisStorageErrorCodeSummary.RESULT_COL_LENGTH.getErrorDesc(), BoxesRunTime.boxToInteger((int)res.length()), BoxesRunTime.boxToInteger((int)LinkisStorageConf$.MODULE$.LINKIS_RESULT_COL_LENGTH())));
            }
            index$2.elem += len;
            if (enableLimit$1.elem) {
                if (this.columnSet().contains((Object)BoxesRunTime.boxToInteger((int)i))) {
                    rowArray$1[colIdx$1.elem] = DataType$.MODULE$.toValue(this.metaData().columns()[i].dataType(), res);
                    ++colIdx$1.elem;
                    return;
                }
                return;
            }
            if (i >= this.metaData().columns().length) {
                rowArray$1[i] = res;
                return;
            }
            rowArray$1[i] = DataType$.MODULE$.toValue(this.metaData().columns()[i].dataType(), res);
        });
        return new TableRecord(rowArray);
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$createMetaData$1(String[] colArray$1, byte[] bytes$1, IntRef index$1, ArrayBuffer columns$1, int i) {
        int len = new StringOps(Predef$.MODULE$.augmentString(colArray$1[i])).toInt();
        String colName = Dolphin$.MODULE$.toStringValue(Dolphin$.MODULE$.getString(bytes$1, index$1.elem, len));
        index$1.elem += len;
        len = new StringOps(Predef$.MODULE$.augmentString(colArray$1[i + 1])).toInt();
        String colType = Dolphin$.MODULE$.toStringValue(Dolphin$.MODULE$.getString(bytes$1, index$1.elem, len));
        index$1.elem += len;
        len = new StringOps(Predef$.MODULE$.augmentString(colArray$1[i + 2])).toInt();
        String colComment = Dolphin$.MODULE$.toStringValue(Dolphin$.MODULE$.getString(bytes$1, index$1.elem, len));
        index$1.elem += len;
        return columns$1.$plus$eq((Object)new Column(colName, DataType$.MODULE$.toDataType(colType), colComment));
    }

    public TableResultDeserializer() {
        Logging.$init$((Logging)this);
        this.columnSet = null;
    }
}

