/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.service.engine;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.exception.LinkisRetryException;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf$;
import org.apache.linkis.governance.common.utils.JobUtils$;
import org.apache.linkis.manager.am.conf.AMConfiguration;
import org.apache.linkis.manager.am.label.EngineReuseLabelChooser;
import org.apache.linkis.manager.am.selector.NodeSelector;
import org.apache.linkis.manager.am.service.engine.AbstractEngineService;
import org.apache.linkis.manager.am.service.engine.DefaultEngineCreateService;
import org.apache.linkis.manager.am.service.engine.EngineReuseService;
import org.apache.linkis.manager.am.service.engine.EngineStopService;
import org.apache.linkis.manager.am.utils.AMUtils$;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.apache.linkis.manager.common.entity.node.EngineNode;
import org.apache.linkis.manager.common.entity.node.Node;
import org.apache.linkis.manager.common.entity.node.ScoreServiceInstance;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.protocol.engine.EngineReuseRequest;
import org.apache.linkis.manager.common.protocol.engine.EngineStopRequest;
import org.apache.linkis.manager.common.utils.ManagerUtils;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactory;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.EngineNodeLabel;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.ReuseExclusionLabel;
import org.apache.linkis.manager.label.entity.node.AliasServiceInstanceLabel;
import org.apache.linkis.manager.label.service.NodeLabelService;
import org.apache.linkis.manager.label.service.UserLabelService;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.manager.label.utils.LabelUtils;
import org.apache.linkis.manager.service.common.label.LabelFilter;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@Service
@ScalaSignature(bytes="\u0006\u0001\t%a\u0001\u0002\r\u001a\u0001!BQ\u0001\u000f\u0001\u0005\u0002eB\u0011b\u000f\u0001A\u0002\u0003\u0007I\u0011\u0002\u001f\t\u0013\r\u0003\u0001\u0019!a\u0001\n\u0013!\u0005\"C'\u0001\u0001\u0004\u0005\t\u0015)\u0003>\u0011%Y\u0006\u00011AA\u0002\u0013%A\fC\u0005e\u0001\u0001\u0007\t\u0019!C\u0005K\"Iq\r\u0001a\u0001\u0002\u0003\u0006K!\u0018\u0005\nS\u0002\u0001\r\u00111A\u0005\n)D\u0011B\u001c\u0001A\u0002\u0003\u0007I\u0011B8\t\u0013E\u0004\u0001\u0019!A!B\u0013Y\u0007\"C:\u0001\u0001\u0004\u0005\r\u0011\"\u0003u\u0011-\t)\u0001\u0001a\u0001\u0002\u0004%I!a\u0002\t\u0015\u0005-\u0001\u00011A\u0001B\u0003&Q\u000fC\u0006\u0002\u0010\u0001\u0001\r\u00111A\u0005\n\u0005E\u0001bCA\r\u0001\u0001\u0007\t\u0019!C\u0005\u00037A1\"a\b\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0014!Y\u00111\u0005\u0001A\u0002\u0003\u0007I\u0011BA\u0013\u0011-\ti\u0003\u0001a\u0001\u0002\u0004%I!a\f\t\u0017\u0005M\u0002\u00011A\u0001B\u0003&\u0011q\u0005\u0005\f\u0003o\u0001\u0001\u0019!a\u0001\n\u0013\tI\u0004C\u0006\u0002J\u0001\u0001\r\u00111A\u0005\n\u0005-\u0003bCA(\u0001\u0001\u0007\t\u0011)Q\u0005\u0003wAq!a\u0015\u0001\t\u0003\n)FA\rEK\u001a\fW\u000f\u001c;F]\u001eLg.\u001a*fkN,7+\u001a:wS\u000e,'B\u0001\u000e\u001c\u0003\u0019)gnZ5oK*\u0011A$H\u0001\bg\u0016\u0014h/[2f\u0015\tqr$\u0001\u0002b[*\u0011\u0001%I\u0001\b[\u0006t\u0017mZ3s\u0015\t\u00113%\u0001\u0004mS:\\\u0017n\u001d\u0006\u0003I\u0015\na!\u00199bG\",'\"\u0001\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001IS\u0006\r\t\u0003U-j\u0011!G\u0005\u0003Ye\u0011Q#\u00112tiJ\f7\r^#oO&tWmU3sm&\u001cW\r\u0005\u0002+]%\u0011q&\u0007\u0002\u0013\u000b:<\u0017N\\3SKV\u001cXmU3sm&\u001cW\r\u0005\u00022m5\t!G\u0003\u00024i\u0005)Q\u000f^5mg*\u0011Q'I\u0001\u0007G>lWn\u001c8\n\u0005]\u0012$a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\u0002\"A\u000b\u0001\u0002\u00199|G-Z*fY\u0016\u001cGo\u001c:\u0016\u0003u\u0002\"AP!\u000e\u0003}R!\u0001Q\u000f\u0002\u0011M,G.Z2u_JL!AQ \u0003\u00199{G-Z*fY\u0016\u001cGo\u001c:\u0002!9|G-Z*fY\u0016\u001cGo\u001c:`I\u0015\fHCA#L!\t1\u0015*D\u0001H\u0015\u0005A\u0015!B:dC2\f\u0017B\u0001&H\u0005\u0011)f.\u001b;\t\u000f1\u001b\u0011\u0011!a\u0001{\u0005\u0019\u0001\u0010J\u0019\u0002\u001b9|G-Z*fY\u0016\u001cGo\u001c:!Q\t!q\n\u0005\u0002Q36\t\u0011K\u0003\u0002S'\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005Q+\u0016a\u00024bGR|'/\u001f\u0006\u0003-^\u000bQAY3b]NT!\u0001W\u0013\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.L!AW)\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001\u00058pI\u0016d\u0015MY3m'\u0016\u0014h/[2f+\u0005i\u0006C\u00010c\u001b\u0005y&B\u0001\u000fa\u0015\t\tw$A\u0003mC\n,G.\u0003\u0002d?\n\u0001bj\u001c3f\u0019\u0006\u0014W\r\\*feZL7-Z\u0001\u0015]>$W\rT1cK2\u001cVM\u001d<jG\u0016|F%Z9\u0015\u0005\u00153\u0007b\u0002'\u0007\u0003\u0003\u0005\r!X\u0001\u0012]>$W\rT1cK2\u001cVM\u001d<jG\u0016\u0004\u0003FA\u0004P\u0003A)8/\u001a:MC\n,GnU3sm&\u001cW-F\u0001l!\tqF.\u0003\u0002n?\n\u0001Rk]3s\u0019\u0006\u0014W\r\\*feZL7-Z\u0001\u0015kN,'\u000fT1cK2\u001cVM\u001d<jG\u0016|F%Z9\u0015\u0005\u0015\u0003\bb\u0002'\n\u0003\u0003\u0005\ra[\u0001\u0012kN,'\u000fT1cK2\u001cVM\u001d<jG\u0016\u0004\u0003F\u0001\u0006P\u0003a)gnZ5oKJ+Wo]3MC\n,Gn\u00115p_N,'o]\u000b\u0002kB\u0019ao_?\u000e\u0003]T!\u0001_=\u0002\tU$\u0018\u000e\u001c\u0006\u0002u\u0006!!.\u0019<b\u0013\taxO\u0001\u0003MSN$\bc\u0001@\u0002\u00025\tqP\u0003\u0002b;%\u0019\u00111A@\u0003/\u0015sw-\u001b8f%\u0016,8/\u001a'bE\u0016d7\t[8pg\u0016\u0014\u0018\u0001H3oO&tWMU3vg\u0016d\u0015MY3m\u0007\"|wn]3sg~#S-\u001d\u000b\u0004\u000b\u0006%\u0001b\u0002'\r\u0003\u0003\u0005\r!^\u0001\u001aK:<\u0017N\\3SKV\u001cX\rT1cK2\u001c\u0005n\\8tKJ\u001c\b\u0005\u000b\u0002\u000e\u001f\u0006\tRM\\4j]\u0016\u001cFo\u001c9TKJ4\u0018nY3\u0016\u0005\u0005M\u0001c\u0001\u0016\u0002\u0016%\u0019\u0011qC\r\u0003#\u0015sw-\u001b8f'R|\u0007oU3sm&\u001cW-A\u000bf]\u001eLg.Z*u_B\u001cVM\u001d<jG\u0016|F%Z9\u0015\u0007\u0015\u000bi\u0002\u0003\u0005M\u001f\u0005\u0005\t\u0019AA\n\u0003I)gnZ5oKN#x\u000e]*feZL7-\u001a\u0011)\u0005Ay\u0015aE3oO&tWm\u0011:fCR,7+\u001a:wS\u000e,WCAA\u0014!\rQ\u0013\u0011F\u0005\u0004\u0003WI\"A\u0007#fM\u0006,H\u000e^#oO&tWm\u0011:fCR,7+\u001a:wS\u000e,\u0017aF3oO&tWm\u0011:fCR,7+\u001a:wS\u000e,w\fJ3r)\r)\u0015\u0011\u0007\u0005\t\u0019J\t\t\u00111\u0001\u0002(\u0005!RM\\4j]\u0016\u001c%/Z1uKN+'O^5dK\u0002B#aE(\u0002\u00171\f'-\u001a7GS2$XM]\u000b\u0003\u0003w\u0001B!!\u0010\u0002F5\u0011\u0011q\b\u0006\u0004C\u0006\u0005#bA\u001b\u0002D)\u0011AdH\u0005\u0005\u0003\u000f\nyDA\u0006MC\n,GNR5mi\u0016\u0014\u0018a\u00047bE\u0016dg)\u001b7uKJ|F%Z9\u0015\u0007\u0015\u000bi\u0005\u0003\u0005M+\u0005\u0005\t\u0019AA\u001e\u00031a\u0017MY3m\r&dG/\u001a:!Q\t1r*A\u0006sKV\u001cX-\u00128hS:,GCBA,\u0003S\nY\b\u0005\u0003\u0002Z\u0005\u0015TBAA.\u0015\u0011\ti&a\u0018\u0002\t9|G-\u001a\u0006\u0005\u0003C\n\u0019'\u0001\u0004f]RLG/\u001f\u0006\u0003k}IA!a\u001a\u0002\\\tQQI\\4j]\u0016tu\u000eZ3\t\u000f\u0005-t\u00031\u0001\u0002n\u0005\u0011RM\\4j]\u0016\u0014V-^:f%\u0016\fX/Z:u!\u0011\ty'a\u001e\u000e\u0005\u0005E$b\u0001\u000e\u0002t)!\u0011QOA2\u0003!\u0001(o\u001c;pG>d\u0017\u0002BA=\u0003c\u0012!#\u00128hS:,'+Z;tKJ+\u0017/^3ti\"9\u0011QP\fA\u0002\u0005}\u0014AB:f]\u0012,'\u000f\u0005\u0003\u0002\u0002\u0006\u001dUBAAB\u0015\r\t))I\u0001\u0004eB\u001c\u0017\u0002BAE\u0003\u0007\u0013aaU3oI\u0016\u0014\b&B\f\u0002\u000e\u0006}\u0005#\u0002$\u0002\u0010\u0006M\u0015bAAI\u000f\n1A\u000f\u001b:poN\u0004B!!&\u0002\u001c6\u0011\u0011q\u0013\u0006\u0004\u00033#\u0014!C3yG\u0016\u0004H/[8o\u0013\u0011\ti*a&\u0003)1Kgn[5t%\u0016$(/_#yG\u0016\u0004H/[8oc\u001dq\u0012\u0011UA\\\u0003S\u0004B!a)\u00022:!\u0011QUAW!\r\t9kR\u0007\u0003\u0003SS1!a+(\u0003\u0019a$o\\8u}%\u0019\u0011qV$\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019,!.\u0003\rM#(/\u001b8h\u0015\r\tykR\u0019\nG\u0005e\u0016\u0011YAp\u0003\u0007,B!a/\u0002>V\u0011\u0011\u0011\u0015\u0003\b\u0003\u007f;#\u0019AAe\u0005\u0005!\u0016\u0002BAb\u0003\u000b\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$bAAd\u000f\u00061A\u000f\u001b:poN\fB!a3\u0002RB\u0019a)!4\n\u0007\u0005=wIA\u0004O_RD\u0017N\\4\u0011\t\u0005M\u0017\u0011\u001c\b\u0004\r\u0006U\u0017bAAl\u000f\u00069\u0001/Y2lC\u001e,\u0017\u0002BAn\u0003;\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005]w)M\u0005$\u0003C\f\u0019/!:\u0002H:\u0019a)a9\n\u0007\u0005\u001dw)M\u0003#\r\u001e\u000b9OA\u0003tG\u0006d\u0017-M\u0002'\u0003'C3aFAw!\u0011\ty/a>\u000e\u0005\u0005E(b\u0001*\u0002t*!\u0011Q_AB\u0003\u001diWm]:bO\u0016LA!!?\u0002r\nA!+Z2fSZ,'\u000fK\u0002\u0001\u0003{\u0004B!a@\u0003\u00065\u0011!\u0011\u0001\u0006\u0004\u0005\u00079\u0016AC:uKJ,w\u000e^=qK&!!q\u0001B\u0001\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class DefaultEngineReuseService
extends AbstractEngineService
implements EngineReuseService,
Logging {
    @Autowired
    private NodeSelector nodeSelector;
    @Autowired
    private NodeLabelService nodeLabelService;
    @Autowired
    private UserLabelService userLabelService;
    @Autowired
    private List<EngineReuseLabelChooser> engineReuseLabelChoosers;
    @Autowired
    private EngineStopService engineStopService;
    @Autowired
    private DefaultEngineCreateService engineCreateService;
    @Autowired
    private LabelFilter labelFilter;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        DefaultEngineReuseService defaultEngineReuseService = this;
        synchronized (defaultEngineReuseService) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private NodeSelector nodeSelector() {
        return this.nodeSelector;
    }

    private void nodeSelector_$eq(NodeSelector x$1) {
        this.nodeSelector = x$1;
    }

    private NodeLabelService nodeLabelService() {
        return this.nodeLabelService;
    }

    private void nodeLabelService_$eq(NodeLabelService x$1) {
        this.nodeLabelService = x$1;
    }

    private UserLabelService userLabelService() {
        return this.userLabelService;
    }

    private void userLabelService_$eq(UserLabelService x$1) {
        this.userLabelService = x$1;
    }

    private List<EngineReuseLabelChooser> engineReuseLabelChoosers() {
        return this.engineReuseLabelChoosers;
    }

    private void engineReuseLabelChoosers_$eq(List<EngineReuseLabelChooser> x$1) {
        this.engineReuseLabelChoosers = x$1;
    }

    private EngineStopService engineStopService() {
        return this.engineStopService;
    }

    private void engineStopService_$eq(EngineStopService x$1) {
        this.engineStopService = x$1;
    }

    private DefaultEngineCreateService engineCreateService() {
        return this.engineCreateService;
    }

    private void engineCreateService_$eq(DefaultEngineCreateService x$1) {
        this.engineCreateService = x$1;
    }

    private LabelFilter labelFilter() {
        return this.labelFilter;
    }

    private void labelFilter_$eq(LabelFilter x$1) {
        this.labelFilter = x$1;
    }

    @Override
    @Receiver
    public EngineNode reuseEngine(EngineReuseRequest engineReuseRequest, Sender sender) throws LinkisRetryException {
        Map<ScoreServiceInstance, List<Label<?>>> instances;
        String[] stringArray;
        String taskId = JobUtils$.MODULE$.getJobIdFromStringMap(engineReuseRequest.getProperties());
        this.logger().info(new StringBuilder(41).append("Task ").append(taskId).append(" Start to reuse Engine for request: ").append(engineReuseRequest).toString());
        LabelBuilderFactory labelBuilderFactory = LabelBuilderFactoryContext.getLabelBuilderFactory();
        Buffer labelList = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(LabelUtils.distinctLabel((List)labelBuilderFactory.getLabels(engineReuseRequest.getLabels()), this.userLabelService().getUserLabels(engineReuseRequest.getUser()))).asScala();
        Option option = labelList.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultEngineReuseService.$anonfun$reuseEngine$1(x$1)));
        if (option instanceof Some) {
            Some some = (Some)option;
            Label l = (Label)some.value();
            stringArray = ((ReuseExclusionLabel)l).getInstances();
        } else if (None$.MODULE$.equals(option)) {
            stringArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        } else {
            throw new MatchError((Object)option);
        }
        String[] exclusionInstances = stringArray;
        if (exclusionInstances.length == 1) {
            String string = exclusionInstances[0];
            String string2 = GovernanceCommonConf$.MODULE$.WILDCARD_CONSTANT();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.logger().info(new StringBuilder(82).append("Task ").append(taskId).append(" exists ReuseExclusionLabel and the configuration does not choose to reuse EC").toString());
                return null;
            }
        }
        ObjectRef filterLabelList = ObjectRef.create((Object)((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)labelList.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DefaultEngineReuseService.$anonfun$reuseEngine$2(x$2)))).asJava()));
        AliasServiceInstanceLabel engineConnAliasLabel = (AliasServiceInstanceLabel)labelBuilderFactory.createLabel(AliasServiceInstanceLabel.class);
        engineConnAliasLabel.setAlias((String)GovernanceCommonConf$.MODULE$.ENGINE_CONN_SPRING_NAME().getValue());
        ((List)filterLabelList.elem).add(engineConnAliasLabel);
        if (this.engineReuseLabelChoosers() != null) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.engineReuseLabelChoosers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)chooser -> {
                filterLabelList.elem = chooser.chooseLabels((List)filterLabelList.elem);
                return BoxedUnit.UNIT;
            });
        }
        if ((instances = this.nodeLabelService().getScoredNodeMapsByLabels((List)filterLabelList.elem)) != null && exclusionInstances != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])exclusionInstances)).nonEmpty()) {
            ScoreServiceInstance[] instancesKeys = (ScoreServiceInstance[])((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(instances).asScala()).keys().toArray(ClassTag$.MODULE$.apply(ScoreServiceInstance.class));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])instancesKeys)).filter((Function1 & Serializable & scala.Serializable)instance -> BoxesRunTime.boxToBoolean((boolean)DefaultEngineReuseService.$anonfun$reuseEngine$4(exclusionInstances, instance))))).foreach((Function1 & Serializable & scala.Serializable)instance -> {
                this.logger().info(new StringBuilder(46).append("will  be not reuse ").append(instance.getServiceInstance()).append(", cause use exclusion label").toString());
                return (List)instances.remove(instance);
            });
        }
        if (instances == null || instances.isEmpty()) {
            throw new LinkisRetryException(30001, "No engine can be reused, cause from db is null");
        }
        ObjectRef engineScoreList = ObjectRef.create((Object)this.getEngineNodeManager().getEngineNodes((ScoreServiceInstance[])((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(instances).asScala()).keys().toSeq().toArray(ClassTag$.MODULE$.apply(ScoreServiceInstance.class))));
        if (AMConfiguration.EC_REUSE_WITH_RESOURCE_RULE_ENABLE) {
            String engineType;
            List<Label<?>> labels = this.engineCreateService().buildLabel(engineReuseRequest.getLabels(), engineReuseRequest.getUser());
            if (engineReuseRequest.getProperties() == null) {
                engineReuseRequest.setProperties(new HashMap());
            }
            if (StringUtils.isNotBlank((CharSequence)(engineType = LabelUtil$.MODULE$.getEngineType(labels))) && AMConfiguration.EC_REUSE_WITH_RESOURCE_WITH_ECS.contains(engineType.toLowerCase())) {
                NodeResource resource = this.engineCreateService().generateResource(engineReuseRequest.getProperties(), engineReuseRequest.getUser(), this.labelFilter().choseEngineLabel(labels), ((TimeType)AMConfiguration.ENGINE_START_MAX_TIME.getValue()).toLong());
                engineScoreList.elem = (EngineNode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((EngineNode[])engineScoreList.elem))).filter((Function1 & Serializable & scala.Serializable)engine -> BoxesRunTime.boxToBoolean((boolean)DefaultEngineReuseService.$anonfun$reuseEngine$7(engine))))).filter((Function1 & Serializable & scala.Serializable)engine -> BoxesRunTime.boxToBoolean((boolean)DefaultEngineReuseService.$anonfun$reuseEngine$8(resource, engine)));
            }
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((EngineNode[])engineScoreList.elem))).isEmpty()) {
                throw new LinkisRetryException(30001, "No engine can be reused, cause all engine resources are not sufficient.");
            }
        }
        ObjectRef engine2 = ObjectRef.create(null);
        IntRef count = IntRef.create((int)1);
        long timeout = engineReuseRequest.getTimeOut() <= 0L ? ((TimeType)AMConfiguration.ENGINE_REUSE_MAX_TIME.getValue()).toLong() : engineReuseRequest.getTimeOut();
        int reuseLimit = engineReuseRequest.getReuseCount() <= 0 ? Predef$.MODULE$.Integer2int(AMConfiguration.ENGINE_REUSE_COUNT_LIMIT) : engineReuseRequest.getReuseCount();
        long startTime = System.currentTimeMillis();
        try {
            Utils$.MODULE$.waitUntil((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.selectEngineToReuse$1(count, reuseLimit, engineScoreList, engine2), (Duration)Duration$.MODULE$.apply(timeout, TimeUnit.MILLISECONDS));
        }
        catch (TimeoutException e) {
            throw new LinkisRetryException(30001, new StringBuilder(62).append("Waiting for Engine initialization failure, already waiting ").append(timeout).append(" ms").toString());
        }
        catch (Throwable t) {
            this.logger().info(new StringBuilder(38).append("Failed to reuse engineConn time taken ").append(System.currentTimeMillis() - startTime).toString());
            throw t;
        }
        this.logger().info(new StringBuilder(67).append("Finished to reuse Engine for request: ").append(engineReuseRequest).append(" get EngineNode ").append((EngineNode)engine2.elem).append(", time taken ").append(System.currentTimeMillis() - startTime).toString());
        scala.collection.mutable.Map engineServiceLabelList = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(instances).asScala()).filter((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)DefaultEngineReuseService.$anonfun$reuseEngine$13(engine2, kv)));
        if (engineServiceLabelList != null && engineServiceLabelList.nonEmpty()) {
            ((EngineNode)engine2.elem).setLabels((List)((Tuple2)engineServiceLabelList.head())._2());
        } else {
            this.logger().info(new StringBuilder(48).append("Get choosen engineNode : ").append(AMUtils$.MODULE$.GSON().toJson((Object)((EngineNode)engine2.elem))).append(" from engineLabelMap : ").append(AMUtils$.MODULE$.GSON().toJson(instances)).toString());
        }
        return (EngineNode)engine2.elem;
    }

    public static final /* synthetic */ boolean $anonfun$reuseEngine$1(Label x$1) {
        return x$1 instanceof ReuseExclusionLabel;
    }

    public static final /* synthetic */ boolean $anonfun$reuseEngine$2(Label x$2) {
        return x$2 instanceof EngineNodeLabel;
    }

    public static final /* synthetic */ boolean $anonfun$reuseEngine$4(String[] exclusionInstances$1, ScoreServiceInstance instance) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])exclusionInstances$1)).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.equalsIgnoreCase(instance.getServiceInstance().getInstance())));
    }

    public static final /* synthetic */ boolean $anonfun$reuseEngine$7(EngineNode engine) {
        NodeStatus nodeStatus = engine.getNodeStatus();
        NodeStatus nodeStatus2 = NodeStatus.Unlock;
        return !(nodeStatus != null ? !nodeStatus.equals(nodeStatus2) : nodeStatus2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$reuseEngine$8(NodeResource resource$1, EngineNode engine) {
        if (engine.getNodeResource().getUsedResource() != null) {
            return engine.getNodeResource().getUsedResource().notLess(resource$1.getMaxResource());
        }
        return engine.getNodeResource().getLockedResource().notLess(resource$1.getMaxResource());
    }

    public static final /* synthetic */ boolean $anonfun$reuseEngine$11(Option choseNode$1, EngineNode x$4) {
        return !x$4.equals(choseNode$1.get());
    }

    private final boolean selectEngineToReuse$1(IntRef count$1, int reuseLimit$1, ObjectRef engineScoreList$1, ObjectRef engine$1) {
        if (count$1.elem > reuseLimit$1) {
            throw new LinkisRetryException(30001, new StringBuilder(28).append("Engine reuse exceeds limit: ").append(reuseLimit$1).toString());
        }
        Option<Node> choseNode = this.nodeSelector().choseNode((Node[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((EngineNode[])engineScoreList$1.elem))).toArray(ClassTag$.MODULE$.apply(Node.class)));
        if (choseNode.isEmpty()) {
            throw new LinkisRetryException(30001, "No engine can be reused");
        }
        EngineNode engineNode = (EngineNode)choseNode.get();
        this.logger().info(new StringBuilder(29).append("prepare to reuse engineNode: ").append(engineNode.getServiceInstance()).toString());
        engine$1.elem = (EngineNode)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> this.getEngineNodeManager().reuseEngine(engineNode), (Function1 & Serializable & scala.Serializable)t -> {
            block0: {
                this.logger().info(new StringBuilder(23).append("Failed to reuse engine ").append(engineNode.getServiceInstance()).toString(), t);
                if (!(ExceptionUtils.getRootCause((Throwable)t) instanceof TimeoutException)) break block0;
                this.logger().info(new StringBuilder(34).append("Failed to reuse ").append(engineNode.getServiceInstance()).append(", now to stop this").toString());
                EngineStopRequest stopEngineRequest = new EngineStopRequest(engineNode.getServiceInstance(), ManagerUtils.getAdminUser());
                this.engineStopService().asyncStopEngine(stopEngineRequest);
            }
            return null;
        });
        if ((EngineNode)engine$1.elem == null) {
            ++count$1.elem;
            engineScoreList$1.elem = (EngineNode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((EngineNode[])engineScoreList$1.elem))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DefaultEngineReuseService.$anonfun$reuseEngine$11(choseNode, x$4)));
        }
        return (EngineNode)engine$1.elem != null;
    }

    public static final /* synthetic */ boolean $anonfun$reuseEngine$13(ObjectRef engine$1, Tuple2 kv) {
        return ((ScoreServiceInstance)kv._1()).getServiceInstance().equals((Object)((EngineNode)engine$1.elem).getServiceInstance());
    }

    public DefaultEngineReuseService() {
        Logging.$init$((Logging)this);
    }
}

