/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.basedatamanager.server.restful;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.basedatamanager.server.domain.UdfBaseInfoEntity;
import org.apache.linkis.basedatamanager.server.domain.UdfTreeEntity;
import org.apache.linkis.basedatamanager.server.service.UdfBaseInfoService;
import org.apache.linkis.basedatamanager.server.service.UdfTreeService;
import org.apache.linkis.basedatamanager.server.utils.UdfTreeUtils;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"UdfTreeRestfulApi"})
@RestController
@RequestMapping(path={"/basedata-manager/udf-tree"})
public class UdfTreeRestfulApi {
    @Autowired
    UdfTreeService udfTreeService;
    @Autowired
    UdfBaseInfoService udfBaseinfoService;

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="string", name="searchName"), @ApiImplicitParam(paramType="query", dataType="int", name="currentPage"), @ApiImplicitParam(paramType="query", dataType="int", name="pageSize")})
    @ApiOperation(value="list", notes="Query list data of UDF Tree", httpMethod="GET")
    @RequestMapping(path={""}, method={RequestMethod.GET})
    public Message list(HttpServletRequest request, String searchName, Integer currentPage, Integer pageSize) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Query list data of UDF Tree,search name:" + searchName));
        PageInfo pageList = this.udfTreeService.getListByPage(searchName, currentPage, pageSize);
        return Message.ok((String)"").data("list", (Object)pageList);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="string", name="searchName"), @ApiImplicitParam(paramType="query", dataType="string", name="category")})
    @ApiOperation(value="all", notes="Query all data of UDF Tree", httpMethod="GET")
    @RequestMapping(path={"/all"}, method={RequestMethod.GET})
    public Message all(HttpServletRequest request, String searchName, String category) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Query all data of UDF Tree,search name:" + searchName));
        List<Object> udfTreeEntityList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)searchName) && StringUtils.isNotBlank((CharSequence)category)) {
            UdfTreeEntity entity = new UdfTreeEntity();
            entity.setCategory(category);
            entity.setUserName(searchName);
            QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper((Object)entity).eq((Object)"user_name", (Object)entity.getUserName())).eq((Object)"category", (Object)entity.getCategory());
            udfTreeEntityList = new UdfTreeUtils(this.udfTreeService.list((Wrapper)queryWrapper)).buildTree();
        }
        return Message.ok((String)"").data("list", udfTreeEntityList);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", dataType="long", name="id")})
    @ApiOperation(value="get", notes="Get a UDF Tree Record by id", httpMethod="GET")
    @RequestMapping(path={"/{id}"}, method={RequestMethod.GET})
    public Message get(HttpServletRequest request, @PathVariable(value="id") Long id) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Get a UDF Tree Record,id:" + id.toString()));
        UdfTreeEntity errorCode = (UdfTreeEntity)this.udfTreeService.getById(id);
        return Message.ok((String)"").data("item", (Object)errorCode);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="body", dataType="UdfTreeEntity", name="udfTreeEntity")})
    @ApiOperation(value="add", notes="Add a UDF Tree Record", httpMethod="POST")
    @RequestMapping(path={""}, method={RequestMethod.POST})
    public Message add(HttpServletRequest request, @RequestBody UdfTreeEntity udfTreeEntity) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Add a UDF Tree Record," + udfTreeEntity.toString()));
        if (!Configuration.isAdmin((String)username)) {
            return Message.error((String)("User '" + username + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
        }
        boolean result = this.udfTreeService.save(udfTreeEntity);
        return Message.ok((String)"").data("result", (Object)result);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", dataType="long", name="id")})
    @ApiOperation(value="remove", notes="Remove a UDF Tree Record by id", httpMethod="DELETE")
    @RequestMapping(path={"/{id}"}, method={RequestMethod.DELETE})
    public Message remove(HttpServletRequest request, @PathVariable(value="id") Long id) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Remove a UDF Tree Record,id:" + id.toString()));
        if (!Configuration.isAdmin((String)username)) {
            return Message.error((String)("User '" + username + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
        }
        UdfTreeEntity entity = (UdfTreeEntity)this.udfTreeService.getById(id);
        if (null != entity && entity.getParent() == -1L) {
            return Message.error((String)"The root directory is forbidden to delete[\"\u6839\u76ee\u5f55\u7981\u6b62\u5220\u9664\"]");
        }
        QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper((Object)new UdfTreeEntity()).eq((Object)"parent", (Object)id);
        List folderList = this.udfTreeService.list((Wrapper)queryWrapper);
        QueryWrapper udfQueryWrapper = (QueryWrapper)new QueryWrapper((Object)new UdfBaseInfoEntity()).eq((Object)"tree_id", (Object)id);
        List functoinList = this.udfBaseinfoService.list((Wrapper)udfQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)folderList) && CollectionUtils.isEmpty((Collection)functoinList)) {
            boolean result = this.udfTreeService.removeById(id);
            return Message.ok((String)"").data("result", (Object)result);
        }
        return Message.error((String)"Please delete the subdirectory first[\u8bf7\u5148\u5220\u9664\u5b50\u76ee\u5f55]");
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="body", dataType="UdfTreeEntity", name="udfTreeEntity")})
    @ApiOperation(value="update", notes="Update a UDF Tree Record", httpMethod="PUT")
    @RequestMapping(path={""}, method={RequestMethod.PUT})
    public Message update(HttpServletRequest request, @RequestBody UdfTreeEntity udfTreeEntity) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Update a UDF Tree Record,id:" + udfTreeEntity.getId().toString()));
        if (!Configuration.isAdmin((String)username)) {
            return Message.error((String)("User '" + username + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
        }
        boolean result = this.udfTreeService.updateById(udfTreeEntity);
        return Message.ok((String)"").data("result", (Object)result);
    }
}

