/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.gateway.parser;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.ServiceInstance$;
import org.apache.linkis.gateway.http.GatewayContext;
import org.apache.linkis.gateway.http.GatewayRoute;
import org.apache.linkis.gateway.parser.AbstractGatewayParser;
import org.apache.linkis.gateway.parser.AbstractGatewayParser$;
import org.apache.linkis.gateway.parser.GatewayParser;
import org.apache.linkis.rpc.conf.RPCConfiguration$;
import org.apache.linkis.server.conf.ServerConfiguration$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0003\u0006\u0001+!A!\u0004\u0001B\u0001B\u0003%1\u0004C\u0003%\u0001\u0011\u0005Q\u0005C\u0004)\u0001\t\u0007I\u0011B\u0015\t\rI\u0002\u0001\u0015!\u0003+\u0011\u001d\u0019\u0004A1A\u0005\n%Ba\u0001\u000e\u0001!\u0002\u0013Q\u0003\"B\u001b\u0001\t\u00032\u0004\"\u0002\"\u0001\t\u0003\u001a%\u0001\u0006#fM\u0006,H\u000e^$bi\u0016<\u0018-\u001f)beN,'O\u0003\u0002\f\u0019\u00051\u0001/\u0019:tKJT!!\u0004\b\u0002\u000f\u001d\fG/Z<bs*\u0011q\u0002E\u0001\u0007Y&t7.[:\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001815\t!\"\u0003\u0002\u001a\u0015\t)\u0012IY:ue\u0006\u001cGoR1uK^\f\u0017\u0010U1sg\u0016\u0014\u0018AD4bi\u0016<\u0018-\u001f)beN,'o\u001d\t\u00049}\tS\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005]\u0011\u0013BA\u0012\u000b\u000559\u0015\r^3xCf\u0004\u0016M]:fe\u00061A(\u001b8jiz\"\"AJ\u0014\u0011\u0005]\u0001\u0001\"\u0002\u000e\u0003\u0001\u0004Y\u0012\u0001D\"P\u001b6{ej\u0018*F\u000f\u0016CV#\u0001\u0016\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013\u0001C7bi\u000eD\u0017N\\4\u000b\u0005=j\u0012\u0001B;uS2L!!\r\u0017\u0003\u000bI+w-\u001a=\u0002\u001b\r{U*T(O?J+u)\u0012-!\u0003Y\u0019E*S#O)~CU)\u0011*U\u0005\u0016\u000bEk\u0018*F\u000f\u0016C\u0016aF\"M\u0013\u0016sEk\u0018%F\u0003J#&)R!U?J+u)\u0012-!\u0003a\u0019\bn\\;mI\u000e{g\u000e^1j]J+\u0017/^3ti\n{G-\u001f\u000b\u0003oi\u0002\"\u0001\b\u001d\n\u0005ej\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006w\u001d\u0001\r\u0001P\u0001\u000fO\u0006$Xm^1z\u0007>tG/\u001a=u!\ti\u0004)D\u0001?\u0015\tyD\"\u0001\u0003iiR\u0004\u0018BA!?\u000599\u0015\r^3xCf\u001cuN\u001c;fqR\fQ\u0001]1sg\u0016$\"\u0001R$\u0011\u0005q)\u0015B\u0001$\u001e\u0005\u0011)f.\u001b;\t\u000bmB\u0001\u0019\u0001\u001f")
public class DefaultGatewayParser
extends AbstractGatewayParser {
    private final GatewayParser[] gatewayParsers;
    private final Regex COMMON_REGEX;
    private final Regex CLIENT_HEARTBEAT_REGEX;

    private Regex COMMON_REGEX() {
        return this.COMMON_REGEX;
    }

    private Regex CLIENT_HEARTBEAT_REGEX() {
        return this.CLIENT_HEARTBEAT_REGEX;
    }

    @Override
    public boolean shouldContainRequestBody(GatewayContext gatewayContext) {
        String string;
        String string2 = gatewayContext.getRequest().getMethod().toUpperCase(Locale.getDefault());
        String string3 = "GET";
        return (string2 == null ? string3 != null : !string2.equals(string3)) && ((string = gatewayContext.getRequest().getRequestURI()).startsWith((String)ServerConfiguration$.MODULE$.BDP_SERVER_USER_URI().getValue()) ? true : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.gatewayParsers)).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.shouldContainRequestBody(gatewayContext))));
    }

    @Override
    public void parse(GatewayContext gatewayContext) {
        String path = gatewayContext.getRequest().getRequestURI();
        if (gatewayContext.getGatewayRoute() == null) {
            gatewayContext.setGatewayRoute(new GatewayRoute());
            gatewayContext.getGatewayRoute().setRequestURI(path);
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.gatewayParsers)).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.parse(gatewayContext);
            return BoxedUnit.UNIT;
        });
        if (gatewayContext.getGatewayRoute().getServiceInstance() == null) {
            String string = path;
            Option option = this.CLIENT_HEARTBEAT_REGEX().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String version = (String)((LinearSeqOptimized)option.get()).apply(0);
                if (this.sendResponseWhenNotMatchVersion(gatewayContext, version)) {
                    return;
                }
                this.logger().info(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)gatewayContext.getRequest().getRemoteAddress()), " try to heartbeat."));
                this.responseHeartbeat(gatewayContext);
                return;
            }
            Option option2 = this.COMMON_REGEX().unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                String version = (String)((LinearSeqOptimized)option2.get()).apply(0);
                String serviceId = (String)((LinearSeqOptimized)option2.get()).apply(1);
                if (this.sendResponseWhenNotMatchVersion(gatewayContext, version)) {
                    return;
                }
                String applicationName = BoxesRunTime.unboxToBoolean((Object)RPCConfiguration$.MODULE$.ENABLE_PUBLIC_SERVICE().getValue()) && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RPCConfiguration$.MODULE$.PUBLIC_SERVICE_LIST())).contains((Object)serviceId) ? (String)RPCConfiguration$.MODULE$.PUBLIC_SERVICE_APPLICATION_NAME().getValue() : (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RPCConfiguration$.MODULE$.LINKIS_DATASOURCE_SERVICE_LIST())).contains((Object)serviceId) ? (String)RPCConfiguration$.MODULE$.LINKIS_DATASOURCE_SERVICE_NAME().getValue() : (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RPCConfiguration$.MODULE$.LINKIS_MANAGER_SERVICE_LIST())).contains((Object)serviceId) ? (String)RPCConfiguration$.MODULE$.LINKIS_MANAGER_SERVICE_NAME().getValue() : serviceId));
                gatewayContext.getGatewayRoute().setServiceInstance(ServiceInstance$.MODULE$.apply(applicationName, null));
                return;
            }
            if (string.startsWith("/dws/")) {
                HashMap<String, String> params = gatewayContext.getGatewayRoute().getParams();
                params.put("proxyId", "dws");
                String secondaryProxyId = StringUtils.substringBetween((String)string, (String)"/dws/", (String)"/");
                Object object = StringUtils.isNotBlank((CharSequence)secondaryProxyId) ? params.put("proxyId", new StringBuilder(4).append("dws/").append(secondaryProxyId).toString()) : BoxedUnit.UNIT;
                gatewayContext.getGatewayRoute().setParams(params);
                return;
            }
            this.sendErrorResponse(new StringBuilder(42).append("Cannot find a service to deal ").append(path).append(", ignore it.").toString(), gatewayContext);
            return;
        }
    }

    public DefaultGatewayParser(GatewayParser[] gatewayParsers) {
        this.gatewayParsers = gatewayParsers;
        this.COMMON_REGEX = new StringOps(Predef$.MODULE$.augmentString("/api/rest_[a-zA-Z]+/(v\\d+)/([^/]+)/.+")).r();
        this.CLIENT_HEARTBEAT_REGEX = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(27).append("/api/rest_[a-zA-Z]+/(v\\d+)/").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])AbstractGatewayParser$.MODULE$.GATEWAY_HEART_BEAT_URL())).mkString("/")).toString())).r();
    }
}

