/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.monitor.until;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.linkis.common.utils.Utils;
import org.apache.linkis.monitor.config.MonitorConfig;
import org.apache.linkis.monitor.constants.Constants;
import org.apache.linkis.monitor.utils.alert.AlertDesc;
import org.apache.linkis.monitor.utils.alert.ims.MonitorAlertUtils;
import org.apache.linkis.monitor.utils.alert.ims.PooledImsAlertUtils;
import org.apache.linkis.monitor.utils.log.LogUtils;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ApplicationContextEvent;
import scala.concurrent.ExecutionContextExecutorService;

public class ThreadUtils
extends ApplicationContextEvent {
    private static final Logger logger = LogUtils.stdOutLogger();
    public static ExecutionContextExecutorService executors = Utils.newCachedExecutionContext((int)5, (String)"alert-pool-thread-", (boolean)false);

    public ThreadUtils(ApplicationContext source) {
        super(source);
    }

    public static String run(List<String> cmdList, String shellName) {
        FutureTask<Object> future = new FutureTask<Object>(() -> Utils.exec((String[])cmdList.toArray(new String[2]), (long)-1L));
        executors.submit(future);
        String msg = "";
        try {
            msg = future.get(((Integer)MonitorConfig.SHELL_TIMEOUT.getValue()).intValue(), TimeUnit.MINUTES).toString();
        }
        catch (TimeoutException e) {
            logger.info("execute shell time out {}", (Object)shellName);
            HashMap<String, String> parms = new HashMap<String, String>();
            parms.put("$shellName", shellName);
            Map<String, AlertDesc> ecmResourceAlerts = MonitorAlertUtils.getAlerts(Constants.THREAD_TIME_OUT_IM(), parms);
            PooledImsAlertUtils.addAlert(ecmResourceAlerts.get("12014"));
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Thread error msg {}", (Object)e.getMessage());
        }
        return msg;
    }
}

