/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.client.service;

import org.apache.linkis.cs.client.ContextClient;
import org.apache.linkis.cs.client.builder.ContextClientFactory;
import org.apache.linkis.cs.client.service.CSNodeService;
import org.apache.linkis.cs.client.service.DefaultSearchService;
import org.apache.linkis.cs.client.service.SearchService;
import org.apache.linkis.cs.client.utils.SerializeHelper;
import org.apache.linkis.cs.common.entity.enumeration.ContextType;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSNodeServiceImpl
implements CSNodeService {
    private static final Logger logger = LoggerFactory.getLogger(CSNodeServiceImpl.class);
    private SearchService searchService = DefaultSearchService.getInstance();
    private static CSNodeService csNodeService;

    private CSNodeServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CSNodeService getInstance() {
        if (null != csNodeService) return csNodeService;
        Class<CSNodeServiceImpl> clazz = CSNodeServiceImpl.class;
        synchronized (CSNodeServiceImpl.class) {
            if (null != csNodeService) return csNodeService;
            csNodeService = new CSNodeServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return csNodeService;
        }
    }

    @Override
    public void initNodeCSInfo(String contextIDStr, String ndeName) {
        try {
            ContextClient contextClient = ContextClientFactory.getOrCreateContextClient();
            ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
            contextClient.removeAllValueByKeyPrefixAndContextType(contextID, ContextType.METADATA, "node." + ndeName + ".");
            logger.info("contextIDStr: {} and  nodeName: {} init cs info", (Object)contextIDStr, (Object)ndeName);
        }
        catch (Exception e) {
            logger.error("Failed to init node cs Info", (Throwable)e);
        }
    }
}

