/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.table;

import com.fasterxml.jackson.annotation.JsonFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SortOrder;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.knox.gateway.shell.table.KnoxShellTableAggregator;
import org.apache.knox.gateway.shell.table.KnoxShellTableBuilder;
import org.apache.knox.gateway.shell.table.KnoxShellTableCall;
import org.apache.knox.gateway.shell.table.KnoxShellTableCallHistory;
import org.apache.knox.gateway.shell.table.KnoxShellTableCell;
import org.apache.knox.gateway.shell.table.KnoxShellTableFilter;
import org.apache.knox.gateway.shell.table.KnoxShellTableJSONSerializer;
import org.apache.knox.gateway.shell.table.KnoxShellTableRenderer;

@JsonFilter(value="knoxShellTableFilter")
public class KnoxShellTable {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    List<String> headers = new ArrayList<String>();
    List<List<Comparable<? extends Object>>> rows = new ArrayList<List<Comparable<? extends Object>>>();
    String title;
    long id = KnoxShellTable.getUniqueTableId();

    public KnoxShellTable title(String title) {
        this.title = title;
        return this;
    }

    public KnoxShellTable header(String header) {
        this.headers.add(header.trim());
        return this;
    }

    public KnoxShellTable row() {
        this.rows.add(new ArrayList());
        return this;
    }

    public KnoxShellTable value(Comparable<? extends Object> value) {
        int index = this.rows.isEmpty() ? 0 : this.rows.size() - 1;
        List<Comparable<? extends Object>> row = this.rows.get(index);
        row.add(value);
        return this;
    }

    public KnoxShellTableCell<? extends Comparable<? extends Object>> cell(int colIndex, int rowIndex) {
        return new KnoxShellTableCell(this.headers, this.rows, colIndex, rowIndex);
    }

    public List<Comparable<? extends Object>> values(int colIndex) {
        ArrayList<Comparable<? extends Object>> col = new ArrayList<Comparable<? extends Object>>();
        this.rows.forEach(row -> col.add((Comparable<? extends Object>)row.get(colIndex)));
        return col;
    }

    public List<Comparable<? extends Object>> values(String colName) {
        int colIndex = this.headers.indexOf(colName);
        ArrayList<Comparable<? extends Object>> col = new ArrayList<Comparable<? extends Object>>();
        this.rows.forEach(row -> col.add((Comparable<? extends Object>)row.get(colIndex)));
        return col;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Conversions getConversion(Comparable<? extends Object> colIndex) {
        Conversions type = null;
        if (colIndex instanceof Double) {
            return Conversions.DOUBLE;
        }
        if (colIndex instanceof Integer) {
            return Conversions.INTEGER;
        }
        if (colIndex instanceof Float) {
            return Conversions.FLOAT;
        }
        if (colIndex instanceof Byte) {
            return Conversions.BYTE;
        }
        if (colIndex instanceof Short) {
            return Conversions.SHORT;
        }
        if (colIndex instanceof Long) {
            return Conversions.LONG;
        }
        if (!(colIndex instanceof String)) throw new IllegalArgumentException("Unsupported data type");
        if (!((String)((Object)colIndex)).matches("-?\\d+(\\.\\d+)?")) throw new IllegalArgumentException("String contains non-numeric characters");
        return Conversions.STRING;
    }

    private double[] toDoubleArray(String colName) throws IllegalArgumentException {
        List<Comparable<? extends Object>> col = this.values(colName);
        double[] colArray = new double[col.size()];
        Enum conversionMethod = null;
        block9: for (int i = 0; i < col.size(); ++i) {
            Comparable<? extends Object> v = col.get(i);
            if (v instanceof String && ((String)((Object)v)).trim().isEmpty()) {
                col.set(i, (Comparable<? extends Object>)((Object)"0"));
            }
            if (i == 0) {
                conversionMethod = this.getConversion(col.get(i));
            }
            switch (1.$SwitchMap$org$apache$knox$gateway$shell$table$KnoxShellTable$Conversions[conversionMethod.ordinal()]) {
                case 1: {
                    colArray[i] = (Double)col.get(i);
                    continue block9;
                }
                case 2: {
                    colArray[i] = ((Integer)col.get(i)).intValue();
                    continue block9;
                }
                case 3: {
                    colArray[i] = ((Float)col.get(i)).floatValue();
                    continue block9;
                }
                case 4: {
                    colArray[i] = ((Byte)col.get(i)).byteValue();
                    continue block9;
                }
                case 5: {
                    colArray[i] = ((Short)col.get(i)).shortValue();
                    continue block9;
                }
                case 6: {
                    colArray[i] = ((Long)col.get(i)).longValue();
                    continue block9;
                }
                case 7: {
                    colArray[i] = Double.parseDouble((String)((Object)col.get(i)));
                }
            }
        }
        return colArray;
    }

    public double mean(String colName) {
        return StatUtils.mean((double[])this.toDoubleArray(colName));
    }

    public double mean(int colIndex) {
        return this.mean(this.headers.get(colIndex));
    }

    public double median(String colName) {
        return StatUtils.percentile((double[])this.toDoubleArray(colName), (double)50.0);
    }

    public double median(int colIndex) {
        return this.median(this.headers.get(colIndex));
    }

    public double mode(String colName) {
        return StatUtils.mode((double[])this.toDoubleArray(colName))[0];
    }

    public double mode(int colIndex) {
        return this.mode(this.headers.get(colIndex));
    }

    public double sum(String colName) {
        return StatUtils.sum((double[])this.toDoubleArray(colName));
    }

    public double sum(int colIndex) {
        return this.sum(this.headers.get(colIndex));
    }

    public double max(String colName) {
        return StatUtils.max((double[])this.toDoubleArray(colName));
    }

    public double max(int colIndex) {
        return this.max(this.headers.get(colIndex));
    }

    public double min(String colName) {
        return StatUtils.min((double[])this.toDoubleArray(colName));
    }

    public double min(int colIndex) {
        return this.min(this.headers.get(colIndex));
    }

    public KnoxShellTable apply(KnoxShellTableCell<? extends Comparable<? extends Object>> cell) {
        if (!this.headers.isEmpty()) {
            this.headers.set(cell.colIndex, cell.header);
        }
        if (!this.rows.isEmpty()) {
            this.rows.get(cell.rowIndex).set(cell.colIndex, (Comparable<? extends Object>)cell.value);
        }
        return this;
    }

    public KnoxShellTable trim(String colName) {
        int colIndex = this.headers.indexOf(colName);
        return this.trim(colIndex);
    }

    public KnoxShellTable trim(int colIndex) {
        List<Comparable<? extends Object>> col = this.values(colIndex);
        for (int i = 0; i < col.size(); ++i) {
            String v = (String)((Object)col.get(i));
            this.rows.get(i).set(colIndex, (Comparable<? extends Object>)((Object)v.trim()));
        }
        return this;
    }

    public List<String> getHeaders() {
        return this.headers == null || this.headers.isEmpty() ? null : this.headers;
    }

    public List<List<Comparable<? extends Object>>> getRows() {
        return this.rows;
    }

    public String getTitle() {
        return this.title;
    }

    public long getId() {
        return this.id;
    }

    public static KnoxShellTableBuilder builder() {
        return new KnoxShellTableBuilder();
    }

    static long getUniqueTableId() {
        return System.currentTimeMillis() + ThreadLocalRandom.current().nextLong(1000L);
    }

    public List<KnoxShellTableCall> getCallHistoryList() {
        LinkedList<KnoxShellTableCall> sanitizedCallHistoryList = new LinkedList<KnoxShellTableCall>();
        KnoxShellTableCallHistory.getInstance().getCallHistory(this.id).forEach(call -> {
            Map<Object, Class<Object>> params = call.hasSensitiveData() ? Collections.singletonMap("***", String.class) : call.getParams();
            sanitizedCallHistoryList.add(new KnoxShellTableCall(call.getInvokerClass(), call.getMethod(), call.isBuilderMethod(), params));
        });
        return sanitizedCallHistoryList;
    }

    public String getCallHistory() {
        StringBuilder callHistoryStringBuilder = new StringBuilder("Call history (id=").append(this.id).append(')').append(LINE_SEPARATOR).append(LINE_SEPARATOR);
        AtomicInteger index = new AtomicInteger(1);
        this.getCallHistoryList().forEach(callHistory -> callHistoryStringBuilder.append("Step ").append(index.getAndIncrement()).append(':').append(LINE_SEPARATOR).append(callHistory).append(LINE_SEPARATOR));
        return callHistoryStringBuilder.toString();
    }

    public String rollback() {
        KnoxShellTable rolledBack = KnoxShellTableCallHistory.getInstance().rollback(this.id);
        this.id = rolledBack.id;
        this.title = rolledBack.title;
        this.headers = rolledBack.headers;
        this.rows = rolledBack.rows;
        return "Successfully rolled back";
    }

    public KnoxShellTable replayAll() {
        int step = KnoxShellTableCallHistory.getInstance().getCallHistory(this.id).size();
        return this.replay(step);
    }

    public KnoxShellTable replay(int step) {
        return KnoxShellTable.replay(this.id, step);
    }

    public static KnoxShellTable replay(long id, int step) {
        return KnoxShellTableCallHistory.getInstance().replay(id, step);
    }

    public KnoxShellTableFilter filter() {
        return new KnoxShellTableFilter(this);
    }

    public KnoxShellTableAggregator aggregate() {
        return new KnoxShellTableAggregator(this);
    }

    /*
     * WARNING - void declaration
     */
    public KnoxShellTable select(String cols) {
        void var7_10;
        String[] colnames;
        KnoxShellTable table = new KnoxShellTable();
        ArrayList<List<Comparable<? extends Object>>> columns = new ArrayList<List<Comparable<? extends Object>>>();
        cols = cols.trim();
        String[] stringArray = colnames = cols.split("\\s*,\\s*");
        int n = stringArray.length;
        boolean bl = false;
        while (var7_10 < n) {
            String colName = stringArray[var7_10];
            table.header(colName);
            columns.add(this.values(this.headers.indexOf(colName)));
            ++var7_10;
        }
        for (int i = 0; i < this.rows.size(); ++i) {
            table.row();
            for (List list : columns) {
                table.value((Comparable)list.get(i));
            }
        }
        return table;
    }

    public KnoxShellTable sort(String colName) {
        return this.sort(colName, SortOrder.ASCENDING);
    }

    public KnoxShellTable sortNumeric(String colName) {
        double[] col = this.toDoubleArray(colName);
        ArrayList<Comparable<? extends Object>> column = new ArrayList<Comparable<? extends Object>>();
        for (double v : col) {
            column.add((Comparable<? extends Object>)v);
        }
        return this.sort(column, SortOrder.ASCENDING);
    }

    public KnoxShellTable sort(String colName, SortOrder order) {
        List<Comparable<? extends Object>> col = this.values(colName);
        return this.sort(col, order);
    }

    public KnoxShellTable sort(List<Comparable<? extends Object>> col, SortOrder order) {
        KnoxShellTable table = new KnoxShellTable();
        ArrayList<RowIndex> index = new ArrayList<RowIndex>();
        for (int i = 0; i < col.size(); ++i) {
            Comparable<? extends Object> value = col.get(i);
            index.add(new RowIndex(value, i));
        }
        if (SortOrder.ASCENDING.equals((Object)order)) {
            Collections.sort(index);
        } else {
            index.sort(Collections.reverseOrder());
        }
        table.headers = new ArrayList<String>(this.headers);
        for (RowIndex i : index) {
            table.rows.add(new ArrayList(this.rows.get(i.index)));
        }
        return table;
    }

    public String toString() {
        return new KnoxShellTableRenderer(this).toString();
    }

    public String toJSON() {
        return this.toJSON(null);
    }

    public String toJSON(boolean data) {
        return this.toJSON(data, null);
    }

    public String toJSON(String path) {
        return this.toJSON(true, path);
    }

    public String toJSON(boolean data, String path) {
        return KnoxShellTableJSONSerializer.serializeKnoxShellTable(this, data, path);
    }

    public String toCSV() {
        return this.toCSV(null);
    }

    public String toCSV(String filePath) {
        return new KnoxShellTableRenderer(this).toCSV(filePath);
    }

    private static class RowIndex
    implements Comparable<RowIndex> {
        Comparable value;
        int index;

        RowIndex(Comparable<? extends Object> value, int index) {
            this.value = value;
            this.index = index;
        }

        @Override
        public int compareTo(RowIndex other) {
            return this.value.compareTo(other.value);
        }
    }

    private static enum Conversions {
        DOUBLE,
        INTEGER,
        FLOAT,
        BYTE,
        SHORT,
        LONG,
        STRING;

    }
}

