/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiHdfsReplicationArguments;
import com.cloudera.api.swagger.model.ApiHiveTable;
import com.cloudera.api.swagger.model.ApiServiceRef;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Schema(description="Replication arguments for Hive services.")
public class ApiHiveReplicationArguments {
    @SerializedName(value="sourceService")
    private ApiServiceRef sourceService = null;
    @SerializedName(value="tableFilters")
    private List<ApiHiveTable> tableFilters = null;
    @SerializedName(value="exportDir")
    private String exportDir = null;
    @SerializedName(value="force")
    private Boolean force = null;
    @SerializedName(value="replicateData")
    private Boolean replicateData = null;
    @SerializedName(value="hdfsArguments")
    private ApiHdfsReplicationArguments hdfsArguments = null;
    @SerializedName(value="replicateImpalaMetadata")
    private Boolean replicateImpalaMetadata = null;
    @SerializedName(value="runInvalidateMetadata")
    private Boolean runInvalidateMetadata = null;
    @SerializedName(value="dryRun")
    private Boolean dryRun = null;
    @SerializedName(value="numThreads")
    private BigDecimal numThreads = null;
    @SerializedName(value="sentryMigration")
    private Boolean sentryMigration = null;
    @SerializedName(value="skipUrlPermissions")
    private Boolean skipUrlPermissions = null;
    @SerializedName(value="atlasReplicationNeeded")
    private Boolean atlasReplicationNeeded = null;
    @SerializedName(value="sentryExportProperties")
    private Map<String, String> sentryExportProperties = null;
    @SerializedName(value="rangerImportProperties")
    private Map<String, String> rangerImportProperties = null;

    public ApiHiveReplicationArguments sourceService(ApiServiceRef sourceService) {
        this.sourceService = sourceService;
        return this;
    }

    @Schema(description="")
    public ApiServiceRef getSourceService() {
        return this.sourceService;
    }

    public void setSourceService(ApiServiceRef sourceService) {
        this.sourceService = sourceService;
    }

    public ApiHiveReplicationArguments tableFilters(List<ApiHiveTable> tableFilters) {
        this.tableFilters = tableFilters;
        return this;
    }

    public ApiHiveReplicationArguments addTableFiltersItem(ApiHiveTable tableFiltersItem) {
        if (this.tableFilters == null) {
            this.tableFilters = new ArrayList<ApiHiveTable>();
        }
        this.tableFilters.add(tableFiltersItem);
        return this;
    }

    @Schema(description="Filters for tables to include in the replication. Optional. If not provided, include all tables in all databases.")
    public List<ApiHiveTable> getTableFilters() {
        return this.tableFilters;
    }

    public void setTableFilters(List<ApiHiveTable> tableFilters) {
        this.tableFilters = tableFilters;
    }

    public ApiHiveReplicationArguments exportDir(String exportDir) {
        this.exportDir = exportDir;
        return this;
    }

    @Schema(description="Directory, in the HDFS service where the target Hive service's data is stored, where the export file will be saved. Optional. If not provided, Cloudera Manager will pick a directory for storing the data.")
    public String getExportDir() {
        return this.exportDir;
    }

    public void setExportDir(String exportDir) {
        this.exportDir = exportDir;
    }

    public ApiHiveReplicationArguments force(Boolean force) {
        this.force = force;
        return this;
    }

    @Schema(description="Whether to force overwriting of mismatched tables. Defaults to false.")
    public Boolean isForce() {
        return this.force;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public ApiHiveReplicationArguments replicateData(Boolean replicateData) {
        this.replicateData = replicateData;
        return this;
    }

    @Schema(description="Whether to replicate table data stored in HDFS. Defaults to false. <p/> If set, the \"hdfsArguments\" property must be set to configure the HDFS replication job.")
    public Boolean isReplicateData() {
        return this.replicateData;
    }

    public void setReplicateData(Boolean replicateData) {
        this.replicateData = replicateData;
    }

    public ApiHiveReplicationArguments hdfsArguments(ApiHdfsReplicationArguments hdfsArguments) {
        this.hdfsArguments = hdfsArguments;
        return this;
    }

    @Schema(description="")
    public ApiHdfsReplicationArguments getHdfsArguments() {
        return this.hdfsArguments;
    }

    public void setHdfsArguments(ApiHdfsReplicationArguments hdfsArguments) {
        this.hdfsArguments = hdfsArguments;
    }

    public ApiHiveReplicationArguments replicateImpalaMetadata(Boolean replicateImpalaMetadata) {
        this.replicateImpalaMetadata = replicateImpalaMetadata;
        return this;
    }

    @Schema(description="Whether to replicate the impala metadata. (i.e. the metadata for impala UDFs and their corresponding binaries in HDFS).")
    public Boolean isReplicateImpalaMetadata() {
        return this.replicateImpalaMetadata;
    }

    public void setReplicateImpalaMetadata(Boolean replicateImpalaMetadata) {
        this.replicateImpalaMetadata = replicateImpalaMetadata;
    }

    public ApiHiveReplicationArguments runInvalidateMetadata(Boolean runInvalidateMetadata) {
        this.runInvalidateMetadata = runInvalidateMetadata;
        return this;
    }

    @Schema(description="Whether to run invalidate metadata query or not")
    public Boolean isRunInvalidateMetadata() {
        return this.runInvalidateMetadata;
    }

    public void setRunInvalidateMetadata(Boolean runInvalidateMetadata) {
        this.runInvalidateMetadata = runInvalidateMetadata;
    }

    public ApiHiveReplicationArguments dryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @Schema(description="Whether to perform a dry run. Defaults to false")
    public Boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public ApiHiveReplicationArguments numThreads(BigDecimal numThreads) {
        this.numThreads = numThreads;
        return this;
    }

    @Schema(description="Number of threads to use in multi-threaded export/import phase")
    public BigDecimal getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(BigDecimal numThreads) {
        this.numThreads = numThreads;
    }

    public ApiHiveReplicationArguments sentryMigration(Boolean sentryMigration) {
        this.sentryMigration = sentryMigration;
        return this;
    }

    @Schema(required=true, description="")
    public Boolean isSentryMigration() {
        return this.sentryMigration;
    }

    public void setSentryMigration(Boolean sentryMigration) {
        this.sentryMigration = sentryMigration;
    }

    public ApiHiveReplicationArguments skipUrlPermissions(Boolean skipUrlPermissions) {
        this.skipUrlPermissions = skipUrlPermissions;
        return this;
    }

    @Schema(required=true, description="Is skipUrlPermissions on.")
    public Boolean isSkipUrlPermissions() {
        return this.skipUrlPermissions;
    }

    public void setSkipUrlPermissions(Boolean skipUrlPermissions) {
        this.skipUrlPermissions = skipUrlPermissions;
    }

    public ApiHiveReplicationArguments atlasReplicationNeeded(Boolean atlasReplicationNeeded) {
        this.atlasReplicationNeeded = atlasReplicationNeeded;
        return this;
    }

    @Schema(description="")
    public Boolean isAtlasReplicationNeeded() {
        return this.atlasReplicationNeeded;
    }

    public void setAtlasReplicationNeeded(Boolean atlasReplicationNeeded) {
        this.atlasReplicationNeeded = atlasReplicationNeeded;
    }

    public ApiHiveReplicationArguments sentryExportProperties(Map<String, String> sentryExportProperties) {
        this.sentryExportProperties = sentryExportProperties;
        return this;
    }

    public ApiHiveReplicationArguments putSentryExportPropertiesItem(String key, String sentryExportPropertiesItem) {
        if (this.sentryExportProperties == null) {
            this.sentryExportProperties = new HashMap<String, String>();
        }
        this.sentryExportProperties.put(key, sentryExportPropertiesItem);
        return this;
    }

    @Schema(description="Additional properties to add or override in authorization-migration-site.xml for Sentry export, on the source.")
    public Map<String, String> getSentryExportProperties() {
        return this.sentryExportProperties;
    }

    public void setSentryExportProperties(Map<String, String> sentryExportProperties) {
        this.sentryExportProperties = sentryExportProperties;
    }

    public ApiHiveReplicationArguments rangerImportProperties(Map<String, String> rangerImportProperties) {
        this.rangerImportProperties = rangerImportProperties;
        return this;
    }

    public ApiHiveReplicationArguments putRangerImportPropertiesItem(String key, String rangerImportPropertiesItem) {
        if (this.rangerImportProperties == null) {
            this.rangerImportProperties = new HashMap<String, String>();
        }
        this.rangerImportProperties.put(key, rangerImportPropertiesItem);
        return this;
    }

    @Schema(description="Additional properties to add or override in authorization-migration-site.xml for Ranger import, on the destination.")
    public Map<String, String> getRangerImportProperties() {
        return this.rangerImportProperties;
    }

    public void setRangerImportProperties(Map<String, String> rangerImportProperties) {
        this.rangerImportProperties = rangerImportProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHiveReplicationArguments apiHiveReplicationArguments = (ApiHiveReplicationArguments)o;
        return Objects.equals(this.sourceService, apiHiveReplicationArguments.sourceService) && Objects.equals(this.tableFilters, apiHiveReplicationArguments.tableFilters) && Objects.equals(this.exportDir, apiHiveReplicationArguments.exportDir) && Objects.equals(this.force, apiHiveReplicationArguments.force) && Objects.equals(this.replicateData, apiHiveReplicationArguments.replicateData) && Objects.equals(this.hdfsArguments, apiHiveReplicationArguments.hdfsArguments) && Objects.equals(this.replicateImpalaMetadata, apiHiveReplicationArguments.replicateImpalaMetadata) && Objects.equals(this.runInvalidateMetadata, apiHiveReplicationArguments.runInvalidateMetadata) && Objects.equals(this.dryRun, apiHiveReplicationArguments.dryRun) && Objects.equals(this.numThreads, apiHiveReplicationArguments.numThreads) && Objects.equals(this.sentryMigration, apiHiveReplicationArguments.sentryMigration) && Objects.equals(this.skipUrlPermissions, apiHiveReplicationArguments.skipUrlPermissions) && Objects.equals(this.atlasReplicationNeeded, apiHiveReplicationArguments.atlasReplicationNeeded) && Objects.equals(this.sentryExportProperties, apiHiveReplicationArguments.sentryExportProperties) && Objects.equals(this.rangerImportProperties, apiHiveReplicationArguments.rangerImportProperties);
    }

    public int hashCode() {
        return Objects.hash(this.sourceService, this.tableFilters, this.exportDir, this.force, this.replicateData, this.hdfsArguments, this.replicateImpalaMetadata, this.runInvalidateMetadata, this.dryRun, this.numThreads, this.sentryMigration, this.skipUrlPermissions, this.atlasReplicationNeeded, this.sentryExportProperties, this.rangerImportProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHiveReplicationArguments {\n");
        sb.append("    sourceService: ").append(this.toIndentedString(this.sourceService)).append("\n");
        sb.append("    tableFilters: ").append(this.toIndentedString(this.tableFilters)).append("\n");
        sb.append("    exportDir: ").append(this.toIndentedString(this.exportDir)).append("\n");
        sb.append("    force: ").append(this.toIndentedString(this.force)).append("\n");
        sb.append("    replicateData: ").append(this.toIndentedString(this.replicateData)).append("\n");
        sb.append("    hdfsArguments: ").append(this.toIndentedString(this.hdfsArguments)).append("\n");
        sb.append("    replicateImpalaMetadata: ").append(this.toIndentedString(this.replicateImpalaMetadata)).append("\n");
        sb.append("    runInvalidateMetadata: ").append(this.toIndentedString(this.runInvalidateMetadata)).append("\n");
        sb.append("    dryRun: ").append(this.toIndentedString(this.dryRun)).append("\n");
        sb.append("    numThreads: ").append(this.toIndentedString(this.numThreads)).append("\n");
        sb.append("    sentryMigration: ").append(this.toIndentedString(this.sentryMigration)).append("\n");
        sb.append("    skipUrlPermissions: ").append(this.toIndentedString(this.skipUrlPermissions)).append("\n");
        sb.append("    atlasReplicationNeeded: ").append(this.toIndentedString(this.atlasReplicationNeeded)).append("\n");
        sb.append("    sentryExportProperties: ").append(this.toIndentedString(this.sentryExportProperties)).append("\n");
        sb.append("    rangerImportProperties: ").append(this.toIndentedString(this.rangerImportProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

