/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.MDCKeySetExtractor;
import org.apache.log4j.pattern.CachedDateFormat;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.xml.UnrecognizedElementHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.AttributesImpl;

public final class XSLTLayout
extends Layout
implements UnrecognizedElementHandler {
    private static final String XSLT_NS = "http://www.w3.org/1999/XSL/Transform";
    private static final String LOG4J_NS = "http://jakarta.apache.org/log4j/";
    private boolean locationInfo = false;
    private String mediaType = "text/plain";
    private Charset encoding;
    private SAXTransformerFactory transformerFactory;
    private Templates templates;
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private boolean ignoresThrowable = false;
    private boolean properties = true;
    private boolean activated = false;
    private final CachedDateFormat utcDateFormat;

    public XSLTLayout() {
        this.transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        SimpleDateFormat zdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        zdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.utcDateFormat = new CachedDateFormat(zdf, 1000);
    }

    @Override
    public synchronized String getContentType() {
        return this.mediaType;
    }

    public synchronized void setLocationInfo(boolean flag) {
        this.locationInfo = flag;
    }

    public synchronized boolean getLocationInfo() {
        return this.locationInfo;
    }

    public synchronized void setProperties(boolean flag) {
        this.properties = flag;
    }

    public synchronized boolean getProperties() {
        return this.properties;
    }

    @Override
    public synchronized void activateOptions() {
        if (this.templates == null) {
            try {
                InputStream is = XSLTLayout.class.getResourceAsStream("default.xslt");
                StreamSource ss = new StreamSource(is);
                this.templates = this.transformerFactory.newTemplates(ss);
                this.encoding = Charset.forName("US-ASCII");
                this.mediaType = "text/plain";
            }
            catch (Exception ex) {
                LogLog.error("Error loading default.xslt", ex);
            }
        }
        this.activated = true;
    }

    @Override
    public synchronized boolean ignoresThrowable() {
        return this.ignoresThrowable;
    }

    public synchronized void setIgnoresThrowable(boolean ignoresThrowable) {
        this.ignoresThrowable = ignoresThrowable;
    }

    @Override
    public synchronized String format(LoggingEvent event) {
        if (!this.activated) {
            this.activateOptions();
        }
        if (this.templates != null && this.encoding != null) {
            this.outputStream.reset();
            try {
                int endDecl;
                Set mdcKeySet;
                int i;
                String[] s;
                TransformerHandler transformer = this.transformerFactory.newTransformerHandler(this.templates);
                transformer.setResult(new StreamResult(this.outputStream));
                transformer.startDocument();
                AttributesImpl attrs = new AttributesImpl();
                attrs.addAttribute(null, "logger", "logger", "CDATA", event.getLoggerName());
                attrs.addAttribute(null, "timestamp", "timestamp", "CDATA", Long.toString(event.timeStamp));
                attrs.addAttribute(null, "level", "level", "CDATA", event.getLevel().toString());
                attrs.addAttribute(null, "thread", "thread", "CDATA", event.getThreadName());
                StringBuffer buf = new StringBuffer();
                this.utcDateFormat.format(event.timeStamp, buf);
                attrs.addAttribute(null, "time", "time", "CDATA", buf.toString());
                transformer.startElement(LOG4J_NS, "event", "event", attrs);
                attrs.clear();
                transformer.startElement(LOG4J_NS, "message", "message", attrs);
                String msg = event.getRenderedMessage();
                if (msg != null && msg.length() > 0) {
                    transformer.characters(msg.toCharArray(), 0, msg.length());
                }
                transformer.endElement(LOG4J_NS, "message", "message");
                String ndc = event.getNDC();
                if (ndc != null) {
                    transformer.startElement(LOG4J_NS, "NDC", "NDC", attrs);
                    char[] ndcChars = ndc.toCharArray();
                    transformer.characters(ndcChars, 0, ndcChars.length);
                    transformer.endElement(LOG4J_NS, "NDC", "NDC");
                }
                if (!this.ignoresThrowable && (s = event.getThrowableStrRep()) != null) {
                    transformer.startElement(LOG4J_NS, "throwable", "throwable", attrs);
                    char[] nl = new char[]{'\n'};
                    for (i = 0; i < s.length; ++i) {
                        char[] line = s[i].toCharArray();
                        transformer.characters(line, 0, line.length);
                        transformer.characters(nl, 0, nl.length);
                    }
                    transformer.endElement(LOG4J_NS, "throwable", "throwable");
                }
                if (this.locationInfo) {
                    LocationInfo locationInfo = event.getLocationInformation();
                    attrs.addAttribute(null, "class", "class", "CDATA", locationInfo.getClassName());
                    attrs.addAttribute(null, "method", "method", "CDATA", locationInfo.getMethodName());
                    attrs.addAttribute(null, "file", "file", "CDATA", locationInfo.getFileName());
                    attrs.addAttribute(null, "line", "line", "CDATA", locationInfo.getLineNumber());
                    transformer.startElement(LOG4J_NS, "locationInfo", "locationInfo", attrs);
                    transformer.endElement(LOG4J_NS, "locationInfo", "locationInfo");
                }
                if (this.properties && (mdcKeySet = MDCKeySetExtractor.INSTANCE.getPropertyKeySet(event)) != null && mdcKeySet.size() > 0) {
                    attrs.clear();
                    transformer.startElement(LOG4J_NS, "properties", "properties", attrs);
                    Object[] keys = mdcKeySet.toArray();
                    Arrays.sort(keys);
                    for (i = 0; i < keys.length; ++i) {
                        String key = keys[i].toString();
                        Object val = event.getMDC(key);
                        attrs.clear();
                        attrs.addAttribute(null, "name", "name", "CDATA", key);
                        attrs.addAttribute(null, "value", "value", "CDATA", val.toString());
                        transformer.startElement(LOG4J_NS, "data", "data", attrs);
                        transformer.endElement(LOG4J_NS, "data", "data");
                    }
                }
                transformer.endElement(LOG4J_NS, "event", "event");
                transformer.endDocument();
                String body = this.encoding.decode(ByteBuffer.wrap(this.outputStream.toByteArray())).toString();
                this.outputStream.reset();
                if (body.startsWith("<?xml ") && (endDecl = body.indexOf("?>")) != -1) {
                    endDecl += 2;
                    while (endDecl < body.length() && (body.charAt(endDecl) == '\n' || body.charAt(endDecl) == '\r')) {
                        ++endDecl;
                    }
                    return body.substring(endDecl);
                }
                return body;
            }
            catch (Exception ex) {
                LogLog.error("Error during transformation", ex);
                return ex.toString();
            }
        }
        return "No valid transform or encoding specified.";
    }

    public void setTransform(Document xsltdoc) throws TransformerConfigurationException {
        Element outputElement;
        String encodingName = null;
        this.mediaType = null;
        String method = null;
        NodeList nodes = xsltdoc.getElementsByTagNameNS(XSLT_NS, "output");
        for (int i = 0; i < nodes.getLength(); ++i) {
            outputElement = (Element)nodes.item(i);
            if (method == null || method.length() == 0) {
                method = outputElement.getAttributeNS(null, "method");
            }
            if (encodingName == null || encodingName.length() == 0) {
                encodingName = outputElement.getAttributeNS(null, "encoding");
            }
            if (this.mediaType != null && this.mediaType.length() != 0) continue;
            this.mediaType = outputElement.getAttributeNS(null, "media-type");
        }
        if (this.mediaType == null || this.mediaType.length() == 0) {
            this.mediaType = "html".equals(method) ? "text/html" : ("xml".equals(method) ? "text/xml" : "text/plain");
        }
        if (encodingName == null || encodingName.length() == 0) {
            Element transformElement = xsltdoc.getDocumentElement();
            outputElement = xsltdoc.createElementNS(XSLT_NS, "output");
            outputElement.setAttributeNS(null, "encoding", "US-ASCII");
            transformElement.insertBefore(outputElement, transformElement.getFirstChild());
            this.encoding = Charset.forName("US-ASCII");
        } else {
            this.encoding = Charset.forName(encodingName);
        }
        DOMSource transformSource = new DOMSource(xsltdoc);
        this.templates = this.transformerFactory.newTemplates(transformSource);
    }

    @Override
    public boolean parseUnrecognizedElement(Element element, Properties props) throws Exception {
        if (XSLT_NS.equals(element.getNamespaceURI()) || element.getNodeName().indexOf("transform") != -1 || element.getNodeName().indexOf("stylesheet") != -1) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DOMSource source = new DOMSource(element);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(source, new StreamResult(os));
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setNamespaceAware(true);
            Document xsltdoc = domFactory.newDocumentBuilder().parse(is);
            this.setTransform(xsltdoc);
            return true;
        }
        return false;
    }
}

