/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem2.collection;

import java.util.ConcurrentModificationException;
import java.util.Spliterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.jena.mem2.collection.FastHashBase;
import org.apache.jena.mem2.collection.JenaSetHashOptimized;
import org.apache.jena.mem2.iterator.SparseArrayIndexedIterator;
import org.apache.jena.mem2.spliterator.SparseArrayIndexedSpliterator;
import org.apache.jena.util.iterator.ExtendedIterator;

public abstract class FastHashSet<K>
extends FastHashBase<K>
implements JenaSetHashOptimized<K> {
    protected FastHashSet(int initialSize) {
        super(initialSize);
    }

    protected FastHashSet() {
    }

    protected FastHashSet(FastHashSet<K> setToCopy) {
        super(setToCopy);
    }

    @Override
    public boolean tryAdd(K key) {
        return this.tryAdd(key, key.hashCode());
    }

    @Override
    public boolean tryAdd(K value, int hashCode) {
        this.growPositionsArrayIfNeeded();
        int pIndex = this.findPosition(value, hashCode);
        if (pIndex < 0) {
            int eIndex = this.getFreeKeyIndex();
            this.keys[eIndex] = value;
            this.hashCodesOrDeletedIndices[eIndex] = hashCode;
            this.positions[pIndex ^ 0xFFFFFFFF] = ~eIndex;
            return true;
        }
        return false;
    }

    public int addAndGetIndex(K value) {
        return this.addAndGetIndex(value, value.hashCode());
    }

    public int addAndGetIndex(K value, int hashCode) {
        this.growPositionsArrayIfNeeded();
        int pIndex = this.findPosition(value, hashCode);
        if (pIndex < 0) {
            int eIndex = this.getFreeKeyIndex();
            this.keys[eIndex] = value;
            this.hashCodesOrDeletedIndices[eIndex] = hashCode;
            this.positions[pIndex ^ 0xFFFFFFFF] = ~eIndex;
            return eIndex;
        }
        return this.positions[pIndex];
    }

    @Override
    public void addUnchecked(K key) {
        this.addUnchecked(key, key.hashCode());
    }

    @Override
    public void addUnchecked(K value, int hashCode) {
        this.growPositionsArrayIfNeeded();
        int eIndex = this.getFreeKeyIndex();
        this.keys[eIndex] = value;
        this.hashCodesOrDeletedIndices[eIndex] = hashCode;
        this.positions[this.findEmptySlotWithoutEqualityCheck((int)hashCode)] = ~eIndex;
    }

    public K getKeyAt(int i) {
        return (K)this.keys[i];
    }

    public final ExtendedIterator<IndexedKey<K>> indexedKeyIterator() {
        int initialSize = this.size();
        Runnable checkForConcurrentModification = () -> {
            if (this.size() != initialSize) {
                throw new ConcurrentModificationException();
            }
        };
        return new SparseArrayIndexedIterator<Object>(this.keys, this.keysPos, checkForConcurrentModification);
    }

    public final Spliterator<IndexedKey<K>> indexedKeySpliterator() {
        int initialSize = this.size();
        Runnable checkForConcurrentModification = () -> {
            if (this.size() != initialSize) {
                throw new ConcurrentModificationException();
            }
        };
        return new SparseArrayIndexedSpliterator<Object>(this.keys, this.keysPos, checkForConcurrentModification);
    }

    public final Stream<IndexedKey<K>> indexedKeyStream() {
        return StreamSupport.stream(this.indexedKeySpliterator(), false);
    }

    public final Stream<IndexedKey<K>> indexedKeyStreamParallel() {
        return StreamSupport.stream(this.indexedKeySpliterator(), true);
    }

    public record IndexedKey<K>(int index, K key) {
    }
}

