/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode;

import java.util.ArrayList;
import java.util.List;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.SectionType;
import org.apache.james.imap.decode.DecodingException;

public class FetchPartPathDecoder {
    private static final int ARRAY_INCREMENT = 20;
    private static final int ARRAY_INITIAL_SIZE = 1;
    private SectionType sectionType;
    private int[] path;
    private int partial;
    private int used;
    private List<String> names;

    public SectionType decode(CharSequence sectionSpecification) throws DecodingException {
        this.init();
        this.sectionType = this.decode(0, sectionSpecification);
        this.prunePath();
        return this.sectionType;
    }

    private void prunePath() {
        int length;
        if (this.path != null && this.used < (length = this.path.length)) {
            int[] newPath = new int[this.used];
            System.arraycopy(this.path, 0, newPath, 0, this.used);
            this.path = newPath;
        }
    }

    private SectionType decode(int at, CharSequence sectionSpecification) throws DecodingException {
        SectionType result;
        int length = sectionSpecification.length();
        if (at < length) {
            char next = sectionSpecification.charAt(at);
            switch (next) {
                case '.': {
                    this.separator();
                    result = this.decode(at + 1, sectionSpecification);
                    break;
                }
                case '0': {
                    result = this.digit(at, sectionSpecification, 0);
                    break;
                }
                case '1': {
                    result = this.digit(at, sectionSpecification, 1);
                    break;
                }
                case '2': {
                    result = this.digit(at, sectionSpecification, 2);
                    break;
                }
                case '3': {
                    result = this.digit(at, sectionSpecification, 3);
                    break;
                }
                case '4': {
                    result = this.digit(at, sectionSpecification, 4);
                    break;
                }
                case '5': {
                    result = this.digit(at, sectionSpecification, 5);
                    break;
                }
                case '6': {
                    result = this.digit(at, sectionSpecification, 6);
                    break;
                }
                case '7': {
                    result = this.digit(at, sectionSpecification, 7);
                    break;
                }
                case '8': {
                    result = this.digit(at, sectionSpecification, 8);
                    break;
                }
                case '9': {
                    result = this.digit(at, sectionSpecification, 9);
                    break;
                }
                case 'T': 
                case 't': {
                    result = this.text(at, sectionSpecification);
                    break;
                }
                case 'H': 
                case 'h': {
                    result = this.header(at, sectionSpecification);
                    break;
                }
                case 'M': 
                case 'm': {
                    result = this.mime(at, sectionSpecification);
                    break;
                }
                default: {
                    throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Did not expect '" + next + "' here in body specification.");
                }
            }
        } else {
            this.storePartial();
            result = SectionType.CONTENT;
        }
        return result;
    }

    private SectionType mime(int at, CharSequence sectionSpecification) throws DecodingException {
        if (sectionSpecification.length() != at + 4) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown body specification");
        }
        this.mustBeI(sectionSpecification, at + 1);
        this.mustBeM(sectionSpecification, at + 2);
        this.mustBeE(sectionSpecification, at + 3);
        this.storePartial();
        return SectionType.MIME;
    }

    private void mustBeI(CharSequence sectionSpecification, int position) throws DecodingException {
        char i = sectionSpecification.charAt(position);
        if (i != 'i' && i != 'I') {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown body specification");
        }
    }

    private void mustBeM(CharSequence sectionSpecification, int position) throws DecodingException {
        char next = sectionSpecification.charAt(position);
        if (next != 'm' && next != 'M') {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown body specification");
        }
    }

    private void mustBeN(CharSequence sectionSpecification, int position) throws DecodingException {
        char next = sectionSpecification.charAt(position);
        if (next != 'n' && next != 'N') {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown body specification");
        }
    }

    private void mustBeO(CharSequence sectionSpecification, int position) throws DecodingException {
        char next = sectionSpecification.charAt(position);
        if (next != 'o' && next != 'O') {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown body specification");
        }
    }

    private void mustBeE(CharSequence sectionSpecification, int position) throws DecodingException {
        char next = sectionSpecification.charAt(position);
        if (next != 'e' && next != 'E') {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown body specification");
        }
    }

    private void mustBeA(CharSequence sectionSpecification, int position) throws DecodingException {
        char next = sectionSpecification.charAt(position);
        if (next != 'a' && next != 'A') {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown body specification");
        }
    }

    private void mustBeD(CharSequence sectionSpecification, int position) throws DecodingException {
        char next = sectionSpecification.charAt(position);
        if (next != 'd' && next != 'D') {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown body specification");
        }
    }

    private void mustBeR(CharSequence sectionSpecification, int position) throws DecodingException {
        char next = sectionSpecification.charAt(position);
        if (next != 'r' && next != 'R') {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown body specification");
        }
    }

    private void mustBeX(CharSequence sectionSpecification, int position) throws DecodingException {
        char next = sectionSpecification.charAt(position);
        if (next != 'x' && next != 'X') {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown body specification");
        }
    }

    private void mustBeT(CharSequence sectionSpecification, int position) throws DecodingException {
        char next = sectionSpecification.charAt(position);
        if (next != 't' && next != 'T') {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown body specification");
        }
    }

    private void mustBeF(CharSequence sectionSpecification, int position) throws DecodingException {
        char next = sectionSpecification.charAt(position);
        if (next != 'f' && next != 'F') {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown body specification");
        }
    }

    private void mustBeL(CharSequence sectionSpecification, int position) throws DecodingException {
        char next = sectionSpecification.charAt(position);
        if (next != 'l' && next != 'L') {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown body specification");
        }
    }

    private void mustBeS(CharSequence sectionSpecification, int position) throws DecodingException {
        char next = sectionSpecification.charAt(position);
        if (next != 's' && next != 'S') {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown body specification");
        }
    }

    private void mustBeDot(CharSequence sectionSpecification, int position) throws DecodingException {
        char next = sectionSpecification.charAt(position);
        if (next != '.') {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown body specification");
        }
    }

    private void mustBeOpenParen(CharSequence sectionSpecification, int position) throws DecodingException {
        if (position >= sectionSpecification.length()) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown body specification");
        }
        char next = sectionSpecification.charAt(position);
        if (next != '(') {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown body specification");
        }
    }

    private SectionType header(int at, CharSequence sectionSpecification) throws DecodingException {
        SectionType result;
        int length = sectionSpecification.length();
        if (length > at + 5) {
            this.mustBeE(sectionSpecification, at + 1);
            this.mustBeA(sectionSpecification, at + 2);
            this.mustBeD(sectionSpecification, at + 3);
            this.mustBeE(sectionSpecification, at + 4);
            this.mustBeR(sectionSpecification, at + 5);
            this.storePartial();
            result = length == at + 6 ? SectionType.HEADER : this.headerFields(at + 6, sectionSpecification);
        } else {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown body specification");
        }
        return result;
    }

    private SectionType headerFields(int at, CharSequence sectionSpecification) throws DecodingException {
        int namesStartAt;
        SectionType result;
        int length = sectionSpecification.length();
        if (length > at + 7) {
            this.mustBeDot(sectionSpecification, at);
            this.mustBeF(sectionSpecification, at + 1);
            this.mustBeI(sectionSpecification, at + 2);
            this.mustBeE(sectionSpecification, at + 3);
            this.mustBeL(sectionSpecification, at + 4);
            this.mustBeD(sectionSpecification, at + 5);
            this.mustBeS(sectionSpecification, at + 6);
            char next = sectionSpecification.charAt(at + 7);
            switch (next) {
                case ' ': {
                    result = SectionType.HEADER_FIELDS;
                    namesStartAt = this.skipSpaces(at + 7, sectionSpecification);
                    break;
                }
                case '.': {
                    if (length > at + 10) {
                        this.mustBeN(sectionSpecification, at + 8);
                        this.mustBeO(sectionSpecification, at + 9);
                        this.mustBeT(sectionSpecification, at + 10);
                        result = SectionType.HEADER_NOT_FIELDS;
                        namesStartAt = this.skipSpaces(at + 11, sectionSpecification);
                        break;
                    }
                    throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown body specification");
                }
                default: {
                    throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown body specification");
                }
            }
        } else {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown body specification");
        }
        this.mustBeOpenParen(sectionSpecification, namesStartAt);
        this.readHeaderNames(namesStartAt + 1, sectionSpecification);
        return result;
    }

    private void readHeaderNames(int at, CharSequence sectionSpecification) throws DecodingException {
        this.names = new ArrayList<String>();
        int firstWordStart = this.skipSpaces(at, sectionSpecification);
        this.readHeaderNames(firstWordStart, firstWordStart, sectionSpecification);
    }

    private void readHeaderNames(int at, int lastWordStart, CharSequence sectionSpecification) throws DecodingException {
        block4: while (at < sectionSpecification.length()) {
            char next = sectionSpecification.charAt(at);
            switch (next) {
                case ' ': {
                    int nextWord;
                    this.readName(lastWordStart, at, sectionSpecification);
                    at = nextWord = this.skipSpaces(at, sectionSpecification);
                    lastWordStart = nextWord;
                    continue block4;
                }
                case ')': {
                    this.readName(lastWordStart, at, sectionSpecification);
                    return;
                }
            }
            ++at;
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Closing parenthesis missing.");
    }

    private void readName(int wordStart, int wordFinish, CharSequence sectionSpecification) {
        if (wordStart <= wordFinish) {
            CharSequence word = sectionSpecification.subSequence(wordStart, wordFinish);
            String name = word.toString();
            this.names.add(name);
        }
    }

    private int skipSpaces(int at, CharSequence sectionSpecification) {
        char next;
        int result = at < sectionSpecification.length() ? ((next = sectionSpecification.charAt(at)) == ' ' ? this.skipSpaces(at + 1, sectionSpecification) : at) : at;
        return result;
    }

    private SectionType text(int at, CharSequence sectionSpecification) throws DecodingException {
        if (sectionSpecification.length() != at + 4) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown body specification");
        }
        this.mustBeE(sectionSpecification, at + 1);
        this.mustBeX(sectionSpecification, at + 2);
        this.mustBeT(sectionSpecification, at + 3);
        this.storePartial();
        return SectionType.TEXT;
    }

    private SectionType digit(int at, CharSequence sectionSpecification, int digit) throws DecodingException {
        this.digit(digit);
        return this.decode(at + 1, sectionSpecification);
    }

    private void init() {
        this.sectionType = SectionType.CONTENT;
        this.resetPartial();
        this.path = null;
        this.used = 0;
        this.names = null;
    }

    private void resetPartial() {
        this.partial = 0;
    }

    private void separator() {
        this.storePartial();
    }

    private void storePartial() {
        if (this.partial > 0) {
            this.ensureSpaceForOneInPath();
            this.path[this.used++] = this.partial;
            this.resetPartial();
        }
    }

    private void ensureSpaceForOneInPath() {
        if (this.path == null) {
            this.path = new int[1];
        } else {
            int length = this.path.length;
            if (this.used >= length) {
                int[] newPath = new int[length + 20];
                System.arraycopy(this.path, 0, newPath, 0, length);
                this.path = newPath;
            }
        }
    }

    private void digit(int digit) {
        this.partial = this.partial * 10 + digit;
    }

    public final int[] getPath() {
        return this.path;
    }

    public final SectionType getSpecifier() {
        return this.sectionType;
    }

    public final List<String> getNames() {
        return this.names;
    }
}

