/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.fetchmail;

import jakarta.mail.internet.ParseException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.user.api.UsersRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ParsedConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParsedConfiguration.class);
    private String fieldJavaMailFolderName = "INBOX";
    private String fieldJavaMailProviderName = "pop3";
    private boolean fieldFetchAll = false;
    private String fieldFetchTaskName;
    private String fieldHost;
    private boolean fieldLeave = false;
    private boolean fieldLeaveBlacklisted = true;
    private boolean fieldLeaveRemoteRecipient = true;
    private boolean fieldLeaveUserUndefined = true;
    private boolean fieldLeaveUndeliverable = true;
    private boolean fieldMarkSeen = true;
    private boolean fieldMarkBlacklistedSeen = false;
    private boolean fieldMarkRemoteRecipientSeen = false;
    private boolean fieldMarkUserUndefinedSeen = false;
    private boolean fieldMarkUndeliverableSeen = false;
    private boolean fieldDeferRecipientNotFound = false;
    private boolean fieldRecurse = false;
    private String fieldDefaultDomainName;
    private boolean fieldRejectUserUndefined;
    private int fieldRemoteReceivedHeaderIndex = -1;
    private boolean fieldLeaveRemoteReceivedHeaderInvalid = true;
    private boolean fieldMarkRemoteReceivedHeaderInvalidSeen = false;
    private boolean fieldRejectRemoteReceivedHeaderInvalid;
    private boolean fieldRejectRecipientNotFound;
    private boolean fieldLeaveRecipientNotFound;
    private boolean fieldMarkRecipientNotFoundSeen;
    private boolean fieldRejectBlacklisted;
    private boolean fieldRejectRemoteRecipient;
    private Set<MailAddress> fieldBlacklist;
    private int fieldMaxMessageSizeLimit = 0;
    private boolean fieldRejectMaxMessageSizeExceeded;
    private boolean fieldLeaveMaxMessageSizeExceeded;
    private boolean fieldMarkMaxMessageSizeExceededSeen;
    private UsersRepository fieldLocalUsers;
    private DNSService dnsServer;
    private MailQueue queue;
    private DomainList domainList;

    public String getJavaMailFolderName() {
        return this.fieldJavaMailFolderName;
    }

    public String getJavaMailProviderName() {
        return this.fieldJavaMailProviderName;
    }

    protected void setJavaMailFolderName(String javaMailFolderName) {
        this.fieldJavaMailFolderName = javaMailFolderName;
    }

    protected void setJavaMailProviderName(String javaMailProviderName) {
        this.fieldJavaMailProviderName = javaMailProviderName;
    }

    private ParsedConfiguration() {
    }

    public ParsedConfiguration(HierarchicalConfiguration<ImmutableNode> configuration, UsersRepository localUsers, DNSService dnsServer, DomainList domainList, MailQueue queue) throws ConfigurationException {
        this();
        this.setLocalUsers(localUsers);
        this.setDNSServer(dnsServer);
        this.setDomainList(domainList);
        this.setMailQueue(queue);
        this.configure(configuration);
    }

    protected void configure(HierarchicalConfiguration<ImmutableNode> conf) throws ConfigurationException {
        this.setHost(conf.getString("host"));
        this.setFetchTaskName(conf.getString("[@name]"));
        this.setJavaMailProviderName(conf.getString("javaMailProviderName"));
        this.setJavaMailFolderName(conf.getString("javaMailFolderName"));
        this.setRecurse(conf.getBoolean("recursesubfolders"));
        HierarchicalConfiguration recipientNotFound = conf.configurationAt("recipientnotfound");
        this.setDeferRecipientNotFound(recipientNotFound.getBoolean("[@defer]"));
        this.setRejectRecipientNotFound(recipientNotFound.getBoolean("[@reject]"));
        this.setLeaveRecipientNotFound(recipientNotFound.getBoolean("[@leaveonserver]"));
        this.setMarkRecipientNotFoundSeen(recipientNotFound.getBoolean("[@markseen]"));
        this.setDefaultDomainName(conf.getString("defaultdomain", "localhost"));
        this.setFetchAll(conf.getBoolean("fetchall"));
        HierarchicalConfiguration fetched = conf.configurationAt("fetched");
        this.setLeave(fetched.getBoolean("[@leaveonserver]"));
        this.setMarkSeen(fetched.getBoolean("[@markseen]"));
        HierarchicalConfiguration remoterecipient = conf.configurationAt("remoterecipient");
        this.setRejectRemoteRecipient(remoterecipient.getBoolean("[@reject]"));
        this.setLeaveRemoteRecipient(remoterecipient.getBoolean("[@leaveonserver]"));
        this.setMarkRemoteRecipientSeen(remoterecipient.getBoolean("[@markseen]"));
        HierarchicalConfiguration blacklist = conf.configurationAt("blacklist");
        this.setBlacklist(conf.getString("blacklist", ""));
        this.setRejectBlacklisted(blacklist.getBoolean("[@reject]"));
        this.setLeaveBlacklisted(blacklist.getBoolean("[@leaveonserver]"));
        this.setMarkBlacklistedSeen(blacklist.getBoolean("[@markseen]"));
        HierarchicalConfiguration userundefined = conf.configurationAt("userundefined");
        this.setRejectUserUndefined(userundefined.getBoolean("[@reject]"));
        this.setLeaveUserUndefined(userundefined.getBoolean("[@leaveonserver]"));
        this.setMarkUserUndefinedSeen(userundefined.getBoolean("[@markseen]"));
        HierarchicalConfiguration undeliverable = conf.configurationAt("undeliverable");
        this.setLeaveUndeliverable(undeliverable.getBoolean("[@leaveonserver]"));
        this.setMarkUndeliverableSeen(undeliverable.getBoolean("[@markseen]"));
        if (conf.getKeys("remotereceivedheader").hasNext()) {
            HierarchicalConfiguration remotereceivedheader = conf.configurationAt("remotereceivedheader");
            this.setRemoteReceivedHeaderIndex(remotereceivedheader.getInt("[@index]"));
            this.setRejectRemoteReceivedHeaderInvalid(remotereceivedheader.getBoolean("[@reject]"));
            this.setLeaveRemoteReceivedHeaderInvalid(remotereceivedheader.getBoolean("[@leaveonserver]"));
            this.setMarkRemoteReceivedHeaderInvalidSeen(remotereceivedheader.getBoolean("[@markseen]"));
        }
        if (conf.getKeys("maxmessagesize").hasNext()) {
            HierarchicalConfiguration maxmessagesize = conf.configurationAt("maxmessagesize");
            this.setMaxMessageSizeLimit(maxmessagesize.getInt("[@limit]") * 1024);
            this.setRejectMaxMessageSizeExceeded(maxmessagesize.getBoolean("[@reject]"));
            this.setLeaveMaxMessageSizeExceeded(maxmessagesize.getBoolean("[@leaveonserver]"));
            this.setMarkMaxMessageSizeExceededSeen(maxmessagesize.getBoolean("[@markseen]"));
        }
        LOGGER.info("Configured FetchMail fetch task {}", (Object)this.getFetchTaskName());
    }

    public boolean isFetchAll() {
        return this.fieldFetchAll;
    }

    public String getFetchTaskName() {
        return this.fieldFetchTaskName;
    }

    public String getHost() {
        return this.fieldHost;
    }

    public boolean isLeave() {
        return this.fieldLeave;
    }

    public boolean isMarkSeen() {
        return this.fieldMarkSeen;
    }

    protected boolean isOpenReadOnly() {
        return this.isLeave() && !this.isMarkSeen() && this.isLeaveBlacklisted() && !this.isMarkBlacklistedSeen() && this.isLeaveRemoteRecipient() && !this.isMarkRemoteRecipientSeen() && this.isLeaveUserUndefined() && !this.isMarkUserUndefinedSeen() && this.isLeaveUndeliverable() && !this.isMarkUndeliverableSeen() && this.isLeaveMaxMessageSizeExceeded() && !this.isMarkMaxMessageSizeExceededSeen() && this.isLeaveRemoteReceivedHeaderInvalid() && !this.isMarkRemoteReceivedHeaderInvalidSeen();
    }

    public boolean isRecurse() {
        return this.fieldRecurse;
    }

    protected void setFetchAll(boolean fetchAll) {
        this.fieldFetchAll = fetchAll;
    }

    protected void setFetchTaskName(String fetchTaskName) {
        this.fieldFetchTaskName = fetchTaskName;
    }

    protected void setHost(String host) {
        this.fieldHost = host;
    }

    protected void setLeave(boolean keep) {
        this.fieldLeave = keep;
    }

    protected void setMarkSeen(boolean markSeen) {
        this.fieldMarkSeen = markSeen;
    }

    protected void setRecurse(boolean recurse) {
        this.fieldRecurse = recurse;
    }

    public UsersRepository getLocalUsers() {
        return this.fieldLocalUsers;
    }

    protected void setLocalUsers(UsersRepository localUsers) {
        this.fieldLocalUsers = localUsers;
    }

    public DNSService getDNSServer() {
        return this.dnsServer;
    }

    protected void setDNSServer(DNSService dnsServer) {
        this.dnsServer = dnsServer;
    }

    public boolean isLeaveBlacklisted() {
        return this.fieldLeaveBlacklisted;
    }

    public boolean isMarkBlacklistedSeen() {
        return this.fieldMarkBlacklistedSeen;
    }

    protected void setLeaveBlacklisted(boolean keepRejected) {
        this.fieldLeaveBlacklisted = keepRejected;
    }

    protected void setMarkBlacklistedSeen(boolean markRejectedSeen) {
        this.fieldMarkBlacklistedSeen = markRejectedSeen;
    }

    public Set<MailAddress> getBlacklist() {
        return this.fieldBlacklist;
    }

    protected void setBlacklist(Set<MailAddress> blacklist) {
        this.fieldBlacklist = blacklist;
    }

    protected void setBlacklist(String blacklistValue) throws ConfigurationException {
        StringTokenizer st = new StringTokenizer(blacklistValue, ", \t", false);
        HashSet<MailAddress> blacklist = new HashSet<MailAddress>();
        String token = null;
        while (st.hasMoreTokens()) {
            try {
                token = st.nextToken();
                blacklist.add(new MailAddress(token));
            }
            catch (ParseException pe) {
                throw new ConfigurationException("Invalid blacklist mail address specified: " + token);
            }
        }
        this.setBlacklist(blacklist);
    }

    public boolean isRejectUserUndefined() {
        return this.fieldRejectUserUndefined;
    }

    protected void setRejectUserUndefined(boolean localRecipientsOnly) {
        this.fieldRejectUserUndefined = localRecipientsOnly;
    }

    public boolean isMarkUserUndefinedSeen() {
        return this.fieldMarkUserUndefinedSeen;
    }

    protected void setMarkUserUndefinedSeen(boolean markExternalSeen) {
        this.fieldMarkUserUndefinedSeen = markExternalSeen;
    }

    public boolean isLeaveUserUndefined() {
        return this.fieldLeaveUserUndefined;
    }

    protected void setLeaveUserUndefined(boolean leaveExternal) {
        this.fieldLeaveUserUndefined = leaveExternal;
    }

    public boolean isLeaveRemoteRecipient() {
        return this.fieldLeaveRemoteRecipient;
    }

    public boolean isMarkRemoteRecipientSeen() {
        return this.fieldMarkRemoteRecipientSeen;
    }

    protected void setLeaveRemoteRecipient(boolean leaveRemoteRecipient) {
        this.fieldLeaveRemoteRecipient = leaveRemoteRecipient;
    }

    protected void setMarkRemoteRecipientSeen(boolean markRemoteRecipientSeen) {
        this.fieldMarkRemoteRecipientSeen = markRemoteRecipientSeen;
    }

    public boolean isRejectRemoteRecipient() {
        return this.fieldRejectRemoteRecipient;
    }

    protected void setRejectRemoteRecipient(boolean rejectRemoteRecipient) {
        this.fieldRejectRemoteRecipient = rejectRemoteRecipient;
    }

    public String getDefaultDomainName() {
        String defaultDomainName = this.getDefaultDomainNameBasic();
        if (null == defaultDomainName) {
            this.updateDefaultDomainName();
            return this.getDefaultDomainName();
        }
        return defaultDomainName;
    }

    private String getDefaultDomainNameBasic() {
        return this.fieldDefaultDomainName;
    }

    protected void setDefaultDomainName(String defaultDomainName) throws ConfigurationException {
        this.validateDefaultDomainName(defaultDomainName);
        this.setDefaultDomainNameBasic(defaultDomainName);
    }

    private void setDefaultDomainNameBasic(String defaultDomainName) {
        this.fieldDefaultDomainName = defaultDomainName;
    }

    protected void validateDefaultDomainName(String defaultDomainName) throws ConfigurationException {
        try {
            if (!this.getDomainList().containsDomain(Domain.of((String)defaultDomainName))) {
                throw new ConfigurationException("Default domain name is not a local server: " + defaultDomainName);
            }
        }
        catch (DomainListException e) {
            throw new ConfigurationException("Unable to access DomainList", (Throwable)e);
        }
    }

    protected String computeDefaultDomainName() {
        String hostName;
        try {
            hostName = this.getDNSServer().getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ue) {
            hostName = "localhost";
        }
        return hostName;
    }

    protected void updateDefaultDomainName() {
        this.setDefaultDomainNameBasic(this.computeDefaultDomainName());
    }

    public boolean isLeaveUndeliverable() {
        return this.fieldLeaveUndeliverable;
    }

    public boolean isMarkUndeliverableSeen() {
        return this.fieldMarkUndeliverableSeen;
    }

    protected void setLeaveUndeliverable(boolean leaveUndeliverable) {
        this.fieldLeaveUndeliverable = leaveUndeliverable;
    }

    protected void setMarkUndeliverableSeen(boolean markUndeliverableSeen) {
        this.fieldMarkUndeliverableSeen = markUndeliverableSeen;
    }

    public boolean isRejectBlacklisted() {
        return this.fieldRejectBlacklisted;
    }

    protected void setRejectBlacklisted(boolean rejectBlacklisted) {
        this.fieldRejectBlacklisted = rejectBlacklisted;
    }

    public boolean isLeaveRecipientNotFound() {
        return this.fieldLeaveRecipientNotFound;
    }

    public boolean isMarkRecipientNotFoundSeen() {
        return this.fieldMarkRecipientNotFoundSeen;
    }

    public boolean isRejectRecipientNotFound() {
        return this.fieldRejectRecipientNotFound;
    }

    protected void setLeaveRecipientNotFound(boolean leaveRecipientNotFound) {
        this.fieldLeaveRecipientNotFound = leaveRecipientNotFound;
    }

    protected void setMarkRecipientNotFoundSeen(boolean markRecipientNotFoundSeen) {
        this.fieldMarkRecipientNotFoundSeen = markRecipientNotFoundSeen;
    }

    protected void setRejectRecipientNotFound(boolean rejectRecipientNotFound) {
        this.fieldRejectRecipientNotFound = rejectRecipientNotFound;
    }

    public boolean isDeferRecipientNotFound() {
        return this.fieldDeferRecipientNotFound;
    }

    protected void setDeferRecipientNotFound(boolean deferRecipientNotFound) {
        this.fieldDeferRecipientNotFound = deferRecipientNotFound;
    }

    public int getRemoteReceivedHeaderIndex() {
        return this.fieldRemoteReceivedHeaderIndex;
    }

    protected void setRemoteReceivedHeaderIndex(int remoteReceivedHeaderIndex) {
        this.fieldRemoteReceivedHeaderIndex = remoteReceivedHeaderIndex;
    }

    public boolean isLeaveMaxMessageSizeExceeded() {
        return this.fieldLeaveMaxMessageSizeExceeded;
    }

    public boolean isMarkMaxMessageSizeExceededSeen() {
        return this.fieldMarkMaxMessageSizeExceededSeen;
    }

    public int getMaxMessageSizeLimit() {
        return this.fieldMaxMessageSizeLimit;
    }

    public boolean isRejectMaxMessageSizeExceeded() {
        return this.fieldRejectMaxMessageSizeExceeded;
    }

    protected void setLeaveMaxMessageSizeExceeded(boolean leaveMaxMessageSize) {
        this.fieldLeaveMaxMessageSizeExceeded = leaveMaxMessageSize;
    }

    protected void setMarkMaxMessageSizeExceededSeen(boolean markMaxMessageSizeSeen) {
        this.fieldMarkMaxMessageSizeExceededSeen = markMaxMessageSizeSeen;
    }

    protected void setMaxMessageSizeLimit(int maxMessageSizeLimit) {
        this.fieldMaxMessageSizeLimit = maxMessageSizeLimit;
    }

    protected void setRejectMaxMessageSizeExceeded(boolean rejectMaxMessageSize) {
        this.fieldRejectMaxMessageSizeExceeded = rejectMaxMessageSize;
    }

    public boolean isLeaveRemoteReceivedHeaderInvalid() {
        return this.fieldLeaveRemoteReceivedHeaderInvalid;
    }

    public boolean isMarkRemoteReceivedHeaderInvalidSeen() {
        return this.fieldMarkRemoteReceivedHeaderInvalidSeen;
    }

    public boolean isRejectRemoteReceivedHeaderInvalid() {
        return this.fieldRejectRemoteReceivedHeaderInvalid;
    }

    protected void setLeaveRemoteReceivedHeaderInvalid(boolean leaveRemoteReceivedHeaderInvalid) {
        this.fieldLeaveRemoteReceivedHeaderInvalid = leaveRemoteReceivedHeaderInvalid;
    }

    protected void setMarkRemoteReceivedHeaderInvalidSeen(boolean markRemoteReceivedHeaderInvalidSeen) {
        this.fieldMarkRemoteReceivedHeaderInvalidSeen = markRemoteReceivedHeaderInvalidSeen;
    }

    protected void setRejectRemoteReceivedHeaderInvalid(boolean rejectRemoteReceivedHeaderInvalid) {
        this.fieldRejectRemoteReceivedHeaderInvalid = rejectRemoteReceivedHeaderInvalid;
    }

    public void setMailQueue(MailQueue queue) {
        this.queue = queue;
    }

    public MailQueue getMailQueue() {
        return this.queue;
    }

    public DomainList getDomainList() {
        return this.domainList;
    }

    public void setDomainList(DomainList domainList) {
        this.domainList = domainList;
    }
}

