/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.annotations.VisibleForTesting;
import jakarta.mail.MessagingException;
import jakarta.mail.Part;
import java.util.Collection;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.utils.MimeWalk;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class PartHasContentType
extends GenericMatcher {
    @VisibleForTesting
    MimeWalk.Configuration configuration = MimeWalk.Configuration.DEFAULT;

    public void init() throws MessagingException {
        this.configuration = MimeWalk.Configuration.parse(this.getCondition());
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        return new MimeWalk(this.configuration, this::partMatch).matchMail(mail);
    }

    private boolean partMatch(Part part) throws MessagingException {
        for (MimeWalk.Mask mask : this.configuration.masks()) {
            if (!part.getContentType().startsWith(mask.getMatchString())) continue;
            return true;
        }
        return false;
    }
}

