/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search.opensearch.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.mailbox.model.QuotaRatio;

public class QuotaRatioAsJson {
    private final String user;
    private final Optional<String> domain;
    private final QuotaRatio quotaRatio;
    private final long sizeUsed;
    private final long countUsed;
    private final Optional<Long> sizeLimit;
    private final Optional<Long> countLimit;

    public static Builder builder() {
        return new Builder();
    }

    private QuotaRatioAsJson(String user, Optional<String> domain, QuotaRatio quotaRatio, long sizeUsed, long countUsed, Optional<Long> sizeLimit, Optional<Long> countLimit) {
        this.user = user;
        this.domain = domain;
        this.quotaRatio = quotaRatio;
        this.sizeUsed = sizeUsed;
        this.countUsed = countUsed;
        this.sizeLimit = sizeLimit;
        this.countLimit = countLimit;
    }

    @JsonProperty(value="user")
    public String getUser() {
        return this.user;
    }

    @JsonProperty(value="domain")
    public Optional<String> getDomain() {
        return this.domain;
    }

    @JsonProperty(value="quotaRatio")
    public double getMaxQuotaRatio() {
        return this.quotaRatio.max();
    }

    @JsonProperty(value="sizeUsed")
    public long getSizeUsed() {
        return this.sizeUsed;
    }

    @JsonProperty(value="countUsed")
    public long getCountUsed() {
        return this.countUsed;
    }

    @JsonProperty(value="sizeLimit")
    public Optional<Long> getSizeLimit() {
        return this.sizeLimit;
    }

    @JsonProperty(value="countLimit")
    public Optional<Long> getCountLimit() {
        return this.countLimit;
    }

    @JsonProperty(value="date")
    public Date getDate() {
        return new Date();
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaRatioAsJson) {
            QuotaRatioAsJson that = (QuotaRatioAsJson)o;
            return Objects.equals(this.quotaRatio, that.quotaRatio) && Objects.equals(this.user, that.user) && Objects.equals(this.sizeLimit, that.sizeLimit) && Objects.equals(this.sizeUsed, that.sizeUsed) && Objects.equals(this.countLimit, that.countLimit) && Objects.equals(this.countUsed, that.countUsed) && Objects.equals(this.domain, that.domain);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.user, this.domain, this.quotaRatio, this.sizeLimit, this.sizeUsed, this.countLimit, this.countUsed);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("quotaRatio", (Object)this.quotaRatio).add("user", (Object)this.user).add("domain", this.domain).add("sizeLimit", this.sizeLimit).add("sizeUsed", this.sizeUsed).add("countLimit", this.countLimit).add("countUsed", this.countUsed).toString();
    }

    public static class Builder {
        private String user;
        private Optional<String> domain = Optional.empty();
        private Optional<Long> sizeUsed;
        private Optional<Long> sizeLimit;
        private Optional<Long> countUsed;
        private Optional<Long> countLimit;
        private QuotaRatio quotaRatio;

        private Builder() {
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder domain(Optional<String> domain) {
            this.domain = domain;
            return this;
        }

        public Builder quotaRatio(QuotaRatio quotaRatio) {
            this.quotaRatio = quotaRatio;
            return this;
        }

        public Builder sizeUsed(long sizeUsed) {
            this.sizeUsed = Optional.of(sizeUsed);
            return this;
        }

        public Builder countUsed(long countUsed) {
            this.countUsed = Optional.of(countUsed);
            return this;
        }

        public Builder sizeLimit(Optional<Long> sizeLimit) {
            this.sizeLimit = sizeLimit;
            return this;
        }

        public Builder countLimit(Optional<Long> countLimit) {
            this.countLimit = countLimit;
            return this;
        }

        public QuotaRatioAsJson build() {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.user) ? 1 : 0) != 0, (Object)"'user' is mandatory");
            Preconditions.checkNotNull((Object)this.quotaRatio, (Object)"'quotaRatio' is mandatory");
            Preconditions.checkState((boolean)this.sizeUsed.isPresent(), (Object)"'sizeUsed' is mandatory");
            Preconditions.checkState((boolean)this.countUsed.isPresent(), (Object)"'countUsed' is mandatory");
            return new QuotaRatioAsJson(this.user, this.domain, this.quotaRatio, this.sizeUsed.get(), this.countUsed.get(), this.sizeLimit, this.countLimit);
        }
    }
}

