/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Optional;

public class CassandraTypesProvider {
    private final CqlSession session;

    @Inject
    public CassandraTypesProvider(CqlSession session) {
        this.session = session;
    }

    public Map<CqlIdentifier, UserDefinedType> userDefinedTypes() {
        return this.session.getKeyspace().map(keyspace -> ((KeyspaceMetadata)this.session.getMetadata().getKeyspaces().get(keyspace)).getUserDefinedTypes()).orElse((Map)ImmutableMap.of());
    }

    public UserDefinedType getDefinedUserType(String typeName) {
        return Optional.ofNullable(this.userDefinedTypes().get(CqlIdentifier.fromCql((String)typeName))).orElseThrow(() -> new RuntimeException("Cassandra UDT " + typeName + " can not be retrieved")).copy(true);
    }
}

