/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vacation.postgres;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.james.backends.postgres.PostgresCommons;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.util.ValuePatch;
import org.apache.james.vacation.api.AccountId;
import org.apache.james.vacation.api.Vacation;
import org.apache.james.vacation.api.VacationPatch;
import org.apache.james.vacation.postgres.PostgresVacationDataDefinition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertOnDuplicateSetMoreStep;
import org.jooq.InsertOnDuplicateSetStep;
import org.jooq.InsertSetMoreStep;
import org.jooq.Record;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class PostgresVacationResponseDAO {
    private final PostgresExecutor postgresExecutor;

    public PostgresVacationResponseDAO(PostgresExecutor postgresExecutor) {
        this.postgresExecutor = postgresExecutor;
    }

    public Mono<Void> modifyVacation(AccountId accountId, VacationPatch vacationPatch) {
        return this.postgresExecutor.executeVoid(dsl -> {
            if (vacationPatch.isIdentity()) {
                return Mono.from((Publisher)this.insertVacationQuery(accountId, vacationPatch, (DSLContext)dsl).onConflictDoNothing());
            }
            return Mono.from(this.withUpdateOnConflict(vacationPatch, this.insertVacationQuery(accountId, vacationPatch, (DSLContext)dsl)));
        });
    }

    private InsertSetMoreStep<Record> insertVacationQuery(AccountId accountId, VacationPatch vacationPatch, DSLContext dsl) {
        InsertSetMoreStep baseInsert = dsl.insertInto(PostgresVacationDataDefinition.PostgresVacationResponseTable.TABLE_NAME).set(PostgresVacationDataDefinition.PostgresVacationResponseTable.ACCOUNT_ID, (Object)accountId.getIdentifier());
        return (InsertSetMoreStep)Stream.of(this.applyInsertForField(PostgresVacationDataDefinition.PostgresVacationResponseTable.IS_ENABLED, VacationPatch::getIsEnabled), this.applyInsertForField(PostgresVacationDataDefinition.PostgresVacationResponseTable.SUBJECT, VacationPatch::getSubject), this.applyInsertForField(PostgresVacationDataDefinition.PostgresVacationResponseTable.HTML, VacationPatch::getHtmlBody), this.applyInsertForField(PostgresVacationDataDefinition.PostgresVacationResponseTable.TEXT, VacationPatch::getTextBody), this.applyInsertForFieldZonedDateTime(PostgresVacationDataDefinition.PostgresVacationResponseTable.FROM_DATE, VacationPatch::getFromDate), this.applyInsertForFieldZonedDateTime(PostgresVacationDataDefinition.PostgresVacationResponseTable.TO_DATE, VacationPatch::getToDate)).reduce((vacation, insert) -> insert, (a, b) -> (vacation, insert) -> (InsertSetMoreStep)b.apply(vacation, (InsertSetMoreStep)a.apply(vacation, insert))).apply(vacationPatch, baseInsert);
    }

    private InsertOnDuplicateSetMoreStep<Record> withUpdateOnConflict(VacationPatch vacationPatch, InsertSetMoreStep<Record> insertVacation) {
        InsertOnDuplicateSetStep baseUpdateIfConflict = insertVacation.onConflict(new Field[]{PostgresVacationDataDefinition.PostgresVacationResponseTable.ACCOUNT_ID}).doUpdate();
        return (InsertOnDuplicateSetMoreStep)Stream.of(this.applyUpdateOnConflictForField(PostgresVacationDataDefinition.PostgresVacationResponseTable.IS_ENABLED, VacationPatch::getIsEnabled), this.applyUpdateOnConflictForField(PostgresVacationDataDefinition.PostgresVacationResponseTable.SUBJECT, VacationPatch::getSubject), this.applyUpdateOnConflictForField(PostgresVacationDataDefinition.PostgresVacationResponseTable.HTML, VacationPatch::getHtmlBody), this.applyUpdateOnConflictForField(PostgresVacationDataDefinition.PostgresVacationResponseTable.TEXT, VacationPatch::getTextBody), this.applyUpdateOnConflictForFieldZonedDateTime(PostgresVacationDataDefinition.PostgresVacationResponseTable.FROM_DATE, VacationPatch::getFromDate), this.applyUpdateOnConflictForFieldZonedDateTime(PostgresVacationDataDefinition.PostgresVacationResponseTable.TO_DATE, VacationPatch::getToDate)).reduce((vacation, updateOnConflict) -> updateOnConflict, (a, b) -> (vacation, updateOnConflict) -> (InsertOnDuplicateSetStep)b.apply(vacation, (InsertOnDuplicateSetStep)a.apply(vacation, updateOnConflict))).apply(vacationPatch, baseUpdateIfConflict);
    }

    private <F, V> BiFunction<VacationPatch, InsertSetMoreStep<Record>, InsertSetMoreStep<Record>> applyInsertForField(Field<F> field, Function<VacationPatch, ValuePatch<V>> getter) {
        return (vacation, insert) -> ((ValuePatch)getter.apply((VacationPatch)vacation)).mapNotKeptToOptional(optionalValue -> this.applyInsertForField(field, (Optional)optionalValue, (InsertSetMoreStep<Record>)insert)).orElse(insert);
    }

    private <F> BiFunction<VacationPatch, InsertSetMoreStep<Record>, InsertSetMoreStep<Record>> applyInsertForFieldZonedDateTime(Field<F> field, Function<VacationPatch, ValuePatch<ZonedDateTime>> getter) {
        return (vacation, insert) -> ((ValuePatch)getter.apply((VacationPatch)vacation)).mapNotKeptToOptional(optionalValue -> this.applyInsertForField(field, optionalValue.map(zonedDateTime -> zonedDateTime.withZoneSameInstant(ZoneId.of("UTC")).toLocalDateTime()), (InsertSetMoreStep<Record>)insert)).orElse(insert);
    }

    private <T> InsertSetMoreStep<Record> applyInsertForField(Field field, Optional<T> value, InsertSetMoreStep<Record> insert) {
        return insert.set(field, value.orElse(null));
    }

    private <F, V> BiFunction<VacationPatch, InsertOnDuplicateSetStep<Record>, InsertOnDuplicateSetStep<Record>> applyUpdateOnConflictForField(Field<F> field, Function<VacationPatch, ValuePatch<V>> getter) {
        return (vacation, update) -> ((ValuePatch)getter.apply((VacationPatch)vacation)).mapNotKeptToOptional(optionalValue -> this.applyUpdateOnConflictForField(field, (Optional)optionalValue, (InsertOnDuplicateSetStep<Record>)update)).orElse(update);
    }

    private <F> BiFunction<VacationPatch, InsertOnDuplicateSetStep<Record>, InsertOnDuplicateSetStep<Record>> applyUpdateOnConflictForFieldZonedDateTime(Field<F> field, Function<VacationPatch, ValuePatch<ZonedDateTime>> getter) {
        return (vacation, update) -> ((ValuePatch)getter.apply((VacationPatch)vacation)).mapNotKeptToOptional(optionalValue -> this.applyUpdateOnConflictForField(field, optionalValue.map(zonedDateTime -> zonedDateTime.withZoneSameInstant(ZoneId.of("UTC")).toLocalDateTime()), (InsertOnDuplicateSetStep<Record>)update)).orElse(update);
    }

    private <T> InsertOnDuplicateSetStep<Record> applyUpdateOnConflictForField(Field field, Optional<T> value, InsertOnDuplicateSetStep<Record> updateOnConflict) {
        return updateOnConflict.set(field, value.orElse(null));
    }

    public Mono<Optional<Vacation>> retrieveVacation(AccountId accountId) {
        return this.postgresExecutor.executeSingleRowOptional(dsl -> dsl.selectFrom(PostgresVacationDataDefinition.PostgresVacationResponseTable.TABLE_NAME).where(PostgresVacationDataDefinition.PostgresVacationResponseTable.ACCOUNT_ID.eq((Object)accountId.getIdentifier()))).map(recordOptional -> recordOptional.map(record -> Vacation.builder().enabled(((Boolean)record.get(PostgresVacationDataDefinition.PostgresVacationResponseTable.IS_ENABLED)).booleanValue()).fromDate(Optional.ofNullable((ZonedDateTime)PostgresCommons.LOCAL_DATE_TIME_ZONED_DATE_TIME_FUNCTION.apply((LocalDateTime)record.get(PostgresVacationDataDefinition.PostgresVacationResponseTable.FROM_DATE, LocalDateTime.class)))).toDate(Optional.ofNullable((ZonedDateTime)PostgresCommons.LOCAL_DATE_TIME_ZONED_DATE_TIME_FUNCTION.apply((LocalDateTime)record.get(PostgresVacationDataDefinition.PostgresVacationResponseTable.TO_DATE, LocalDateTime.class)))).subject(Optional.ofNullable((String)record.get(PostgresVacationDataDefinition.PostgresVacationResponseTable.SUBJECT))).textBody(Optional.ofNullable((String)record.get(PostgresVacationDataDefinition.PostgresVacationResponseTable.TEXT))).htmlBody(Optional.ofNullable((String)record.get(PostgresVacationDataDefinition.PostgresVacationResponseTable.HTML))).build()));
    }
}

