/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.ids;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.UUID;
import org.apache.james.mailbox.model.MessageId;

public class CassandraMessageId
implements MessageId {
    private final UUID uuid;

    public static CassandraMessageId of(UUID uuid) {
        return new CassandraMessageId(uuid);
    }

    private CassandraMessageId(UUID uuid) {
        this.uuid = uuid;
    }

    public String serialize() {
        return this.uuid.toString();
    }

    public UUID get() {
        return this.uuid;
    }

    public boolean isSerializable() {
        return true;
    }

    public final boolean equals(Object o) {
        if (o instanceof CassandraMessageId) {
            CassandraMessageId other = (CassandraMessageId)o;
            return Objects.equals(this.uuid, other.uuid);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.uuid);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("uuid", (Object)this.uuid).toString();
    }

    public static class Factory
    implements MessageId.Factory {
        public CassandraMessageId generate() {
            return Factory.of(Uuids.timeBased());
        }

        public static CassandraMessageId of(UUID uuid) {
            return new CassandraMessageId(uuid);
        }

        public CassandraMessageId fromString(String serialized) {
            return Factory.of(UUID.fromString(serialized));
        }
    }
}

