/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.opensearch.search;

import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.opensearch.search.OpenSearchSearcher;
import org.apache.james.mailbox.searchhighligt.SearchHighlighter;
import org.apache.james.mailbox.searchhighligt.SearchSnippet;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch.core.search.Hit;
import reactor.core.publisher.Flux;

public class OpenSearchSearchHighlighter
implements SearchHighlighter {
    public static final String ATTACHMENT_TEXT_CONTENT_FIELD = "attachments.textContent";
    public static final String ATTACHMENT_FILENAME_FIELD = "attachments.fileName";
    public static final List<String> SNIPPET_FIELDS = List.of("messageId", "subject", "textBody", "attachments.textContent", "attachments.fileName");
    private final OpenSearchSearcher openSearchSearcher;
    private final StoreMailboxManager storeMailboxManager;
    private final MessageId.Factory messageIdFactory;

    @Inject
    @Singleton
    public OpenSearchSearchHighlighter(OpenSearchSearcher openSearchSearcher, StoreMailboxManager storeMailboxManager, MessageId.Factory messageIdFactory) {
        this.openSearchSearcher = openSearchSearcher;
        this.storeMailboxManager = storeMailboxManager;
        this.messageIdFactory = messageIdFactory;
    }

    public Flux<SearchSnippet> highlightSearch(List<MessageId> messageIds, MultimailboxesSearchQuery expression, MailboxSession session) {
        if (messageIds.isEmpty() || expression.getSearchQuery().getCriteria().isEmpty()) {
            return Flux.empty();
        }
        return this.storeMailboxManager.getInMailboxIds(expression, session).collectList().flatMapMany(mailboxIds -> this.highlightSearch((List<MailboxId>)mailboxIds, expression.getSearchQuery(), messageIds.size()));
    }

    private Flux<SearchSnippet> highlightSearch(List<MailboxId> mailboxIds, SearchQuery query, int limit) {
        return this.openSearchSearcher.search(mailboxIds, query, Optional.of(limit), SNIPPET_FIELDS, true).map(this::buildSearchSnippet);
    }

    private SearchSnippet buildSearchSnippet(Hit<ObjectNode> searchResult) {
        MessageId messageId = Optional.ofNullable((JsonData)searchResult.fields().get("messageId")).map(jsonData -> jsonData.toJson().asJsonArray().getString(0)).map(arg_0 -> ((MessageId.Factory)this.messageIdFactory).fromString(arg_0)).orElseThrow(() -> new IllegalStateException("Can not extract MessageID for search result: " + searchResult.id()));
        Map highlightHit = searchResult.highlight();
        Optional<String> highlightedSubject = Optional.ofNullable((List)highlightHit.get("subject")).map(List::getFirst);
        Optional<String> highlightedTextBody = Optional.ofNullable((List)highlightHit.get("textBody")).or(() -> Optional.ofNullable((List)highlightHit.get("htmlBody"))).or(() -> Optional.ofNullable((List)highlightHit.get(ATTACHMENT_TEXT_CONTENT_FIELD))).or(() -> Optional.ofNullable((List)highlightHit.get(ATTACHMENT_FILENAME_FIELD))).map(List::getFirst);
        return new SearchSnippet(messageId, highlightedSubject, highlightedTextBody);
    }
}

