/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import java.util.List;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imapserver.netty.NettyConstants;
import org.apache.james.protocols.api.CommandDetectionSession;
import org.apache.james.protocols.netty.AllButStartTlsLineBasedChannelHandler;

public class SwitchableLineBasedFrameDecoder
extends AllButStartTlsLineBasedChannelHandler {
    public static final String PATTERN = ImapConstants.STARTTLS_COMMAND.getName().toLowerCase();

    public SwitchableLineBasedFrameDecoder(ChannelPipeline pipeline, int maxFrameLength, boolean stripDelimiter) {
        super(pipeline, maxFrameLength, stripDelimiter, PATTERN);
    }

    protected CommandDetectionSession retrieveSession(ChannelHandlerContext ctx) {
        return (CommandDetectionSession)ctx.channel().attr(NettyConstants.IMAP_SESSION_ATTRIBUTE_KEY).get();
    }

    protected boolean multiPartsAndOneStartTls(List<String> parts) {
        return parts.stream().map(this::removeTag).anyMatch(line -> line.startsWith(PATTERN)) && parts.size() > 1;
    }

    protected boolean hasInvalidStartTlsPart(List<String> parts) {
        return parts.stream().map(this::removeTag).anyMatch(line -> line.startsWith(PATTERN) && !line.endsWith(PATTERN));
    }

    protected String removeTag(String input) {
        String trimmedInput = input.trim();
        int tagEnd = trimmedInput.indexOf(32);
        if (tagEnd < 0) {
            return input;
        }
        return trimmedInput.substring(tagEnd + 1);
    }

    protected boolean hasStartTLS(String trimedLowerCasedInput) {
        return super.hasStartTLS(this.removeTag(trimedLowerCasedInput));
    }
}

