/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.droplists.memory;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import org.apache.james.core.MailAddress;
import org.apache.james.droplists.api.DeniedEntityType;
import org.apache.james.droplists.api.DropList;
import org.apache.james.droplists.api.DropListEntry;
import org.apache.james.droplists.api.OwnerScope;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MemoryDropList
implements DropList {
    private final Multimap<OwnerScope, DropListEntry> globalDropList = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private final Multimap<OwnerScope, DropListEntry> domainDropList = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private final Multimap<OwnerScope, DropListEntry> userDropList = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());

    public Mono<Void> add(DropListEntry entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0);
        OwnerScope ownerScope = entry.getOwnerScope();
        Multimap<OwnerScope, DropListEntry> selectedDropList = this.getDropListByScope(ownerScope);
        return Mono.fromRunnable(() -> selectedDropList.put((Object)ownerScope, (Object)entry));
    }

    public Mono<Void> remove(DropListEntry entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0);
        OwnerScope ownerScope = entry.getOwnerScope();
        Multimap<OwnerScope, DropListEntry> selectedDropList = this.getDropListByScope(ownerScope);
        return Mono.fromRunnable(() -> selectedDropList.remove((Object)ownerScope, (Object)entry));
    }

    public Flux<DropListEntry> list(OwnerScope ownerScope, String owner) {
        Preconditions.checkArgument((ownerScope != null ? 1 : 0) != 0);
        Preconditions.checkArgument((owner != null ? 1 : 0) != 0);
        Multimap<OwnerScope, DropListEntry> selectedDropList = this.getDropListByScope(ownerScope);
        return Flux.fromIterable((Iterable)selectedDropList.get((Object)ownerScope)).filter(entry -> entry.getOwner().equals(owner));
    }

    public Mono<DropList.Status> query(OwnerScope ownerScope, String owner, MailAddress sender) {
        Preconditions.checkArgument((ownerScope != null ? 1 : 0) != 0);
        Preconditions.checkArgument((owner != null ? 1 : 0) != 0);
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0);
        Multimap<OwnerScope, DropListEntry> selectedDropList = this.getDropListByScope(ownerScope);
        boolean isBlocked = selectedDropList.get((Object)ownerScope).stream().anyMatch(entry -> this.isEntryMatchingOwner(ownerScope, owner, (DropListEntry)entry) && this.isEntryMatchingDeniedEntity(sender, (DropListEntry)entry));
        return Mono.just((Object)(isBlocked ? DropList.Status.BLOCKED : DropList.Status.ALLOWED));
    }

    private Multimap<OwnerScope, DropListEntry> getDropListByScope(OwnerScope ownerScope) {
        return switch (ownerScope) {
            default -> throw new MatchException(null, null);
            case OwnerScope.GLOBAL -> this.globalDropList;
            case OwnerScope.DOMAIN -> this.domainDropList;
            case OwnerScope.USER -> this.userDropList;
        };
    }

    private boolean isEntryMatchingOwner(OwnerScope ownerScope, String owner, DropListEntry entry) {
        if (ownerScope.equals((Object)OwnerScope.GLOBAL)) {
            return true;
        }
        return entry.getOwner().equals(owner);
    }

    private boolean isEntryMatchingDeniedEntity(MailAddress sender, DropListEntry entry) {
        String entityFromSender = entry.getDeniedEntityType() == DeniedEntityType.DOMAIN ? sender.getDomain().asString() : sender.asString();
        return entry.getDeniedEntity().equals(entityFromSender);
    }
}

