/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.mailets;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CRLFInputStream
extends FilterInputStream {
    private static final int LAST_WAS_OTHER = 0;
    private static final int LAST_WAS_CR = 1;
    private static final int LAST_WAS_LF = 2;
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    private int statusLast;
    private boolean underlyingStreamHasNext = true;
    private final IntArrayFIFOQueue queue = new IntArrayFIFOQueue(16384);

    public CRLFInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        if (this.underlyingStreamHasNext) {
            int b = super.read();
            this.doEnqueue(b);
        }
        if (this.queue.isEmpty()) {
            return -1;
        }
        return this.queue.dequeueInt();
    }

    private void doEnqueue(int b) {
        switch (b) {
            case 13: {
                this.queue.enqueue(b);
                this.queue.enqueue(10);
                this.statusLast = 1;
                break;
            }
            case 10: {
                if (this.statusLast != 1) {
                    this.queue.enqueue(13);
                    this.queue.enqueue(b);
                }
                this.statusLast = 2;
                break;
            }
            case -1: {
                this.underlyingStreamHasNext = false;
                this.queue.enqueue(b);
                this.statusLast = 0;
                break;
            }
            default: {
                this.queue.enqueue(b);
                this.statusLast = 0;
            }
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        int i;
        if (this.underlyingStreamHasNext) {
            byte[] buffer = new byte[b.length];
            int read = this.in.read(buffer);
            if (read == -1) {
                this.underlyingStreamHasNext = false;
            }
            for (int j = 0; j < read; ++j) {
                this.doEnqueue(buffer[j]);
            }
        }
        if (this.queue.isEmpty()) {
            return -1;
        }
        for (i = 0; i < b.length && !this.queue.isEmpty(); ++i) {
            b[i] = (byte)this.queue.dequeueInt();
        }
        return i;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (this.underlyingStreamHasNext) {
            byte[] buffer = new byte[len];
            int read = this.in.read(buffer, 0, len);
            if (read == -1) {
                this.underlyingStreamHasNext = false;
            }
            for (int j = 0; j < read; ++j) {
                this.doEnqueue(buffer[j]);
            }
        }
        if (this.queue.isEmpty()) {
            return -1;
        }
        for (i = 0; i < b.length && !this.queue.isEmpty(); ++i) {
            b[off + i] = (byte)this.queue.dequeueInt();
        }
        return i;
    }
}

