/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.JSON;
import org.jooq.JSONEntry;
import org.jooq.JSONEntryValueStep;
import org.jooq.Param;
import org.jooq.Record1;
import org.jooq.SQLDialect;
import org.jooq.Scope;
import org.jooq.Select;
import org.jooq.conf.NestedCollectionEmulation;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.AbstractRowAsField;
import org.jooq.impl.ComplexCheckQueryPart;
import org.jooq.impl.ConvertedDataType;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;

final class JSONEntryImpl<T>
extends AbstractQueryPart
implements JSONEntry<T>,
JSONEntryValueStep,
ComplexCheckQueryPart {
    static final Set<SQLDialect> SUPPORT_JSON_MERGE_PRESERVE = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private final Field<String> key;
    private final Field<T> value;

    JSONEntryImpl(Field<String> key) {
        this(key, null);
    }

    JSONEntryImpl(Field<String> key, Field<T> value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public final boolean isComplex(Context<?> ctx) {
        return Tools.isComplex(ctx, this.value);
    }

    @Override
    public final Field<String> key() {
        return this.key;
    }

    @Override
    public final Field<T> value() {
        return this.value;
    }

    public final <X> JSONEntry<X> value(X newValue) {
        return this.value(Tools.field(newValue));
    }

    public final <X> JSONEntry<X> value(Field<X> newValue) {
        return new JSONEntryImpl<X>(this.key, newValue);
    }

    public final <X> JSONEntry<X> value(Select<? extends Record1<X>> newValue) {
        return this.value(DSL.field(newValue));
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DUCKDB: 
            case MARIADB: 
            case MYSQL: 
            case POSTGRES: 
            case SQLITE: 
            case YUGABYTEDB: {
                ctx.visit(this.key).sql(", ").visit(JSONEntryImpl.jsonCast(ctx, this.value));
                break;
            }
            case TRINO: {
                ctx.visit(Keywords.K_KEY).sql(' ').visit(JSONEntryImpl.jsonCast(ctx, this.key)).sql(' ').visit(Keywords.K_VALUE).sql(' ').visit(JSONEntryImpl.jsonCast(ctx, this.value));
                break;
            }
            default: {
                ctx.visit(Keywords.K_KEY).sql(' ').visit(this.key).sql(' ').visit(Keywords.K_VALUE).sql(' ').visit(JSONEntryImpl.jsonCast(ctx, this.value));
            }
        }
    }

    static final Function<? super Field<?>, ? extends Field<?>> jsonCastMapper(Context<?> ctx) {
        return field -> JSONEntryImpl.jsonCast(ctx, field);
    }

    static final Field<?> jsonCast(Context<?> ctx, Field<?> field) {
        return JSONEntryImpl.jsonCast(ctx, field, false);
    }

    static final Field<?> jsonCast(Context<?> ctx, Field<?> field, boolean castJSONTypes) {
        DataType type = field.getDataType();
        switch (ctx.family()) {
            case H2: {
                if (JSONEntryImpl.isType(type, UUID.class)) {
                    return field.cast(SQLDataType.VARCHAR(36));
                }
                if (type.isEnum()) {
                    return field.cast(SQLDataType.VARCHAR);
                }
                if (type.isTemporal()) {
                    return field.cast(SQLDataType.VARCHAR);
                }
                if (!type.isBinary()) break;
                return DSL.function(Names.N_RAWTOHEX, SQLDataType.VARCHAR, field);
            }
            case MARIADB: 
            case MYSQL: {
                if (type.getSQLDataType() == SQLDataType.BIT) {
                    return field.cast(SQLDataType.BOOLEAN);
                }
                if (JSONEntryImpl.isType(type, Boolean.class)) {
                    return JSONEntryImpl.booleanJsonExtract(field);
                }
                if (!castJSONTypes || !type.isJSON()) break;
                if (ctx.family() == SQLDialect.MYSQL) {
                    return field.cast(field.getDataType());
                }
                return DSL.function(Names.N_JSON_EXTRACT, field.getDataType(), field, DSL.inline("$"));
            }
            case CLICKHOUSE: {
                if (JSONEntryImpl.isType(type, Boolean.class)) {
                    return field.cast(SQLDataType.BOOLEAN);
                }
                if (!JSONEntryImpl.isJSON(ctx, type)) break;
                return field.cast(SQLDataType.JSON);
            }
            case SQLITE: {
                if (JSONEntryImpl.isType(type, Boolean.class)) {
                    return DSL.function(Names.N_JSON, SQLDataType.JSON, JSONEntryImpl.booleanCase(field));
                }
                if (type.isBinary()) {
                    return Tools.ifNotNull(field, DSL.function(Names.N_HEX, SQLDataType.VARCHAR, field));
                }
                if (!castJSONTypes || !type.isJSON()) break;
                return DSL.function(Names.N_JSON, SQLDataType.JSON, field);
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                if (field instanceof Param) {
                    if (!field.getDataType().isOther()) {
                        return field.cast(field.getDataType());
                    }
                    return field.cast(SQLDataType.VARCHAR);
                }
                return field;
            }
            case TRINO: {
                if (type.getSQLDataType() == SQLDataType.CHAR || type.isUUID() || type.isTemporal() && !type.isTimestamp()) {
                    return field.cast(SQLDataType.VARCHAR);
                }
                if (type.isBinary()) {
                    return DSL.function(Names.N_TO_HEX, SQLDataType.VARCHAR, field);
                }
                return field;
            }
        }
        return field;
    }

    private static final Field<?> booleanJsonExtract(Field<Boolean> field) {
        return Tools.isVal1(field, v -> v.isInline()) ? field : DSL.case_(field).when((Field<Boolean>)DSL.inline(true), JSONEntryImpl.booleanJsonExtract0(DSL.inline(true))).when(DSL.inline(false), JSONEntryImpl.booleanJsonExtract0(DSL.inline(false)));
    }

    private static final Field<JSON> booleanJsonExtract0(Field<?> field) {
        return DSL.function(Names.N_JSON_EXTRACT, SQLDataType.JSON, DSL.function(Names.N_JSON_ARRAY, SQLDataType.JSON, field), DSL.inline("$[0]"));
    }

    private static final Field<String> booleanCase(Field<?> field) {
        return DSL.case_(field).when((Field<?>)DSL.inline(true), DSL.inline("true")).when(DSL.inline(false), DSL.inline("false"));
    }

    static final <T> Field<T> unescapeNestedJSON(Context<?> ctx, Field<T> value) {
        if (JSONEntryImpl.isJSON(ctx, value.getDataType())) {
            switch (ctx.family()) {
                case MARIADB: 
                case MYSQL: 
                case SQLITE: {
                    return DSL.function(Names.N_JSON_EXTRACT, value.getDataType(), value, DSL.inline("$"));
                }
            }
        }
        return value;
    }

    static final boolean isType(DataType<?> t, Class<?> type) {
        return ConvertedDataType.delegate(t).getType() == type;
    }

    static final boolean isJSON(Context<?> ctx, DataType<?> type) {
        DataType<?> t = ConvertedDataType.delegate(type);
        return t.isJSON() || t.isEmbeddable() && AbstractRowAsField.forceMultisetContent(ctx, () -> t.getRow().size() > 1) && JSONEntryImpl.emulateMultisetWithJSON(ctx) || t.isRecord() && AbstractRowAsField.forceMultisetContent(ctx, () -> t.getRow().size() > 1) && JSONEntryImpl.emulateMultisetWithJSON(ctx) || t.isMultiset() && JSONEntryImpl.emulateMultisetWithJSON(ctx);
    }

    private static final boolean emulateMultisetWithJSON(Scope scope) {
        return Tools.emulateMultiset(scope.configuration()) == NestedCollectionEmulation.JSON || Tools.emulateMultiset(scope.configuration()) == NestedCollectionEmulation.JSONB;
    }

    static final Field<?> jsonMerge(Scope scope, String empty, Field<?> ... fields) {
        return DSL.function(SUPPORT_JSON_MERGE_PRESERVE.contains((Object)scope.dialect()) ? Names.N_JSON_MERGE_PRESERVE : Names.N_JSON_MERGE, fields[0].getDataType(), Tools.combine(DSL.inline(empty), fields));
    }

    @Override
    public final Field<String> $key() {
        return this.key;
    }

    @Override
    public final Field<?> $value() {
        return this.value;
    }
}

