/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.server;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.james.filesystem.api.JamesDirectoriesProvider;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.modules.server.JmxConfiguration;
import org.apache.james.util.FunctionalUtils;
import org.apache.james.util.RestrictingRMISocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXServer
implements Startable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JMXServer.class);
    private final JmxConfiguration jmxConfiguration;
    private final Set<String> registeredKeys;
    private final Object lock;
    private final String jmxPasswordFilePath;
    private final String jmxAccessFilePath;
    private JMXConnectorServer jmxConnectorServer;
    private boolean isStarted;
    private RestrictingRMISocketFactory restrictingRMISocketFactory;

    @Inject
    public JMXServer(JmxConfiguration jmxConfiguration, JamesDirectoriesProvider directoriesProvider) {
        this.jmxConfiguration = jmxConfiguration;
        this.jmxPasswordFilePath = directoriesProvider.getConfDirectory() + "jmxremote.password";
        this.jmxAccessFilePath = directoriesProvider.getConfDirectory() + "jmxremote.access";
        this.isStarted = false;
        this.registeredKeys = new HashSet<String>();
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.jmxConfiguration.isEnabled()) {
                return;
            }
            if (this.isStarted) {
                return;
            }
            this.isStarted = true;
            this.doStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isStarted) {
                return;
            }
            this.isStarted = false;
            this.doStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String key, Object remote) throws Exception {
        ManagementFactory.getPlatformMBeanServer().registerMBean(remote, new ObjectName(key));
        Object object = this.lock;
        synchronized (object) {
            this.registeredKeys.add(key);
        }
    }

    private void doStart() {
        try {
            String serviceURL = "service:jmx:rmi://" + this.jmxConfiguration.getHost().getHostName() + "/jndi/rmi://" + this.jmxConfiguration.getHost().getHostName() + ":" + this.jmxConfiguration.getHost().getPort() + "/jmxrmi";
            this.restrictingRMISocketFactory = new RestrictingRMISocketFactory(this.jmxConfiguration.getHost().getHostName());
            LocateRegistry.createRegistry(this.jmxConfiguration.getHost().getPort(), (RMIClientSocketFactory)this.restrictingRMISocketFactory, (RMIServerSocketFactory)this.restrictingRMISocketFactory);
            this.generateJMXPasswordFileIfNeed();
            if (!this.existJmxPasswordFile()) {
                LOGGER.warn("No authentication setted up for the JMX component. This expose you to local privilege escalation attacks risk.");
            }
            Map environment = (Map)Optional.of(this.existJmxPasswordFile()).filter(FunctionalUtils.identityPredicate()).map(hasJmxPasswordFile -> ImmutableMap.of((Object)"jmx.remote.x.password.file", (Object)this.jmxPasswordFilePath, (Object)"jmx.remote.x.access.file", (Object)this.jmxAccessFilePath, (Object)"jmx.remote.rmi.server.credentials.filter.pattern", (Object)"java.lang.String;!*")).orElse(ImmutableMap.of((Object)"jmx.remote.rmi.server.credentials.filter.pattern", (Object)"java.lang.String;!*"));
            this.jmxConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(new JMXServiceURL(serviceURL), environment, ManagementFactory.getPlatformMBeanServer());
            this.jmxConnectorServer.start();
            LOGGER.info("JMX server started");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void doStop() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.registeredKeys.forEach(Throwing.consumer(key -> mBeanServer.unregisterMBean(new ObjectName((String)key))));
            this.registeredKeys.clear();
            this.jmxConnectorServer.stop();
            this.restrictingRMISocketFactory.getSockets().forEach(Throwing.consumer(ServerSocket::close).sneakyThrow());
            LOGGER.info("JMX server stopped");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void generateJMXPasswordFileIfNeed() {
        if (Boolean.parseBoolean(System.getProperty("james.jmx.credential.generation", "true")) && !this.existJmxPasswordFile()) {
            this.generateJMXPasswordFile();
        }
    }

    private boolean existJmxPasswordFile() {
        return Files.exists(Path.of(this.jmxPasswordFilePath, new String[0]), new LinkOption[0]) && Files.exists(Path.of(this.jmxAccessFilePath, new String[0]), new LinkOption[0]);
    }

    private void generateJMXPasswordFile() {
        block18: {
            try {
                File accessFile;
                File passwordFile = new File(this.jmxPasswordFilePath);
                if (!passwordFile.exists()) {
                    try (FileOutputStream outputStream = new FileOutputStream(passwordFile);){
                        String randomPassword = RandomStringUtils.random((int)10, (boolean)true, (boolean)true);
                        IOUtils.write((String)("james-admin " + randomPassword + "\n"), (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
                        this.setPermissionOwnerOnly(passwordFile);
                        LOGGER.info("Generated JMX password file: " + passwordFile.getPath());
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error when creating JMX password file: " + passwordFile.getPath(), e);
                    }
                }
                if ((accessFile = new File(this.jmxAccessFilePath)).exists()) break block18;
                try (FileOutputStream outputStream = new FileOutputStream(accessFile);){
                    IOUtils.write((String)"james-admin readwrite\n", (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
                    this.setPermissionOwnerOnly(accessFile);
                    LOGGER.info("Generated JMX access file: " + accessFile.getPath());
                }
                catch (IOException e) {
                    throw new RuntimeException("Error when creating JMX access file: " + accessFile.getPath(), e);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failure to auto-generate JMX password, fallback to unsecure JMX", (Throwable)e);
            }
        }
    }

    private void setPermissionOwnerOnly(File file) throws IOException {
        Files.setPosixFilePermissions(file.toPath(), Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
    }
}

