/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.rabbitmq.RabbitMQMailQueue;
import org.apache.james.task.Task;
import org.apache.james.task.TaskManager;
import org.apache.james.util.DurationParser;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.service.ClearMailQueueTask;
import org.apache.james.webadmin.service.RepublishNotprocessedMailsTask;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.tasks.TaskRegistrationKey;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import spark.Request;
import spark.ResponseTransformer;
import spark.Service;

public class RabbitMQMailQueuesRoutes
implements Routes {
    private static final TaskRegistrationKey REPUBLISH_NOT_PROCESSED_MAILS_REGISTRATION_KEY = TaskRegistrationKey.of((String)"RepublishNotProcessedMails");
    private final MailQueueFactory<RabbitMQMailQueue> mailQueueFactory;
    private final JsonTransformer jsonTransformer;
    private final TaskManager taskManager;
    private final Clock clock;
    private final Set<TaskFromRequestRegistry.TaskRegistration> extraTasks;

    @Inject
    @VisibleForTesting
    RabbitMQMailQueuesRoutes(MailQueueFactory<RabbitMQMailQueue> mailQueueFactory, Clock clock, JsonTransformer jsonTransformer, TaskManager taskManager, @Named(value="RabbitMQMailQueuesRoutes") Set<TaskFromRequestRegistry.TaskRegistration> extraTasks) {
        this.mailQueueFactory = mailQueueFactory;
        this.clock = clock;
        this.jsonTransformer = jsonTransformer;
        this.taskManager = taskManager;
        this.extraTasks = extraTasks;
    }

    public String getBasePath() {
        return "/mailQueues";
    }

    public void define(Service service) {
        this.republishNotProcessedMails(service);
    }

    public void republishNotProcessedMails(Service service) {
        service.post("/mailQueues/:mailQueueName", TaskFromRequestRegistry.builder().register(REPUBLISH_NOT_PROCESSED_MAILS_REGISTRATION_KEY, this::republishNotProcessedMails).registrations(this.extraTasks).buildAsRoute(this.taskManager), (ResponseTransformer)this.jsonTransformer);
    }

    private Task republishNotProcessedMails(Request request) {
        MailQueueName mailQueue = MailQueueName.of((String)request.params(":mailQueueName"));
        this.getMailQueue(mailQueue).close();
        return new RepublishNotprocessedMailsTask(mailQueue, name -> (ManageableMailQueue)this.mailQueueFactory.getQueue(name).orElseThrow(() -> new ClearMailQueueTask.UnknownSerializedQueue(name.asString())), this.getOlderThan(request));
    }

    private RabbitMQMailQueue getMailQueue(MailQueueName mailQueueName) {
        return (RabbitMQMailQueue)this.mailQueueFactory.getQueue(mailQueueName).orElseThrow(() -> ErrorResponder.builder().message("%s can not be found", new Object[]{mailQueueName}).statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).haltError());
    }

    private Instant getOlderThan(Request req) {
        try {
            Duration olderThan = Optional.ofNullable(req.queryParams("olderThan")).filter(Predicate.not(String::isEmpty)).map(rawString -> DurationParser.parse((String)rawString, (ChronoUnit)ChronoUnit.DAYS)).orElseThrow();
            return this.clock.instant().minus(olderThan);
        }
        catch (NoSuchElementException e) {
            throw ErrorResponder.builder().message("Missing olderThan").statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).haltError();
        }
        catch (Exception e) {
            throw ErrorResponder.builder().statusCode(400).cause(e).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid olderThan").haltError();
        }
    }
}

