/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.examples;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientId;
import org.bouncycastle.mail.smime.SMIMEEnvelopedParser;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.mail.smime.examples.ExampleUtils;
import org.bouncycastle.mail.smime.util.FileBackedMimeBodyPart;
import org.bouncycastle.mail.smime.util.SharedFileInputStream;

public class ReadLargeEncryptedMail {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 3) {
            System.err.println("usage: ReadLargeEncryptedMail pkcs12Keystore password outputFile");
            System.exit(0);
        }
        KeyStore keyStore = KeyStore.getInstance("PKCS12", "BC");
        String string = ExampleUtils.findKeyAlias(keyStore, stringArray[0], stringArray[1].toCharArray());
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        JceKeyTransRecipientId jceKeyTransRecipientId = new JceKeyTransRecipientId(x509Certificate);
        Properties properties = System.getProperties();
        Session session = Session.getDefaultInstance(properties, null);
        MimeMessage mimeMessage = new MimeMessage(session, new SharedFileInputStream("encrypted.message"));
        SMIMEEnvelopedParser sMIMEEnvelopedParser = new SMIMEEnvelopedParser(mimeMessage);
        RecipientInformationStore recipientInformationStore = sMIMEEnvelopedParser.getRecipientInfos();
        RecipientInformation recipientInformation = recipientInformationStore.get(jceKeyTransRecipientId);
        FileBackedMimeBodyPart fileBackedMimeBodyPart = SMIMEUtil.toMimeBodyPart(recipientInformation.getContentStream(new JceKeyTransEnvelopedRecipient((PrivateKey)keyStore.getKey(string, null)).setProvider("BC")));
        ExampleUtils.dumpContent(fileBackedMimeBodyPart, stringArray[2]);
    }
}

