/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.task.MailboxMergingTask;
import org.apache.james.mailbox.cassandra.mail.task.MailboxMergingTaskRunner;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;

public class MailboxMergingTaskDTO
implements TaskDTO {
    private static final CassandraId.Factory CASSANDRA_ID_FACTORY = new CassandraId.Factory();
    private final String type;
    private final long totalMessageCount;
    private final String oldMailboxId;
    private final String newMailboxId;

    private static MailboxMergingTaskDTO toDTO(MailboxMergingTask domainObject, String typeName) {
        return new MailboxMergingTaskDTO(typeName, domainObject.getContext().getTotalMessageCount(), domainObject.getOldMailboxId().serialize(), domainObject.getNewMailboxId().serialize());
    }

    public static TaskDTOModule<MailboxMergingTask, MailboxMergingTaskDTO> module(MailboxMergingTaskRunner taskRunner) {
        return (TaskDTOModule)DTOModule.forDomainObject(MailboxMergingTask.class).convertToDTO(MailboxMergingTaskDTO.class).toDomainObjectConverter(dto -> dto.toDomainObject(taskRunner)).toDTOConverter(MailboxMergingTaskDTO::toDTO).typeName(MailboxMergingTask.MAILBOX_MERGING.asString()).withFactory(TaskDTOModule::new);
    }

    public MailboxMergingTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="totalMessageCount") long totalMessageCount, @JsonProperty(value="oldMailboxId") String oldMailboxId, @JsonProperty(value="newMailboxId") String newMailboxId) {
        this.type = type;
        this.totalMessageCount = totalMessageCount;
        this.oldMailboxId = oldMailboxId;
        this.newMailboxId = newMailboxId;
    }

    private MailboxMergingTask toDomainObject(MailboxMergingTaskRunner taskRunner) {
        return new MailboxMergingTask(taskRunner, this.totalMessageCount, CASSANDRA_ID_FACTORY.fromString(this.oldMailboxId), CASSANDRA_ID_FACTORY.fromString(this.newMailboxId));
    }

    public String getType() {
        return this.type;
    }

    public long getTotalMessageCount() {
        return this.totalMessageCount;
    }

    public String getOldMailboxId() {
        return this.oldMailboxId;
    }

    public String getNewMailboxId() {
        return this.newMailboxId;
    }
}

